/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigBlast;
import icbm.classic.content.explosive.blast.BlastBeam;
import icbm.classic.lib.transform.vector.Location;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastExothermic
extends BlastBeam {
    public BlastExothermic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.red = 0.7f;
        this.green = 0.3f;
        this.blue = 0.0f;
    }

    @Override
    public void doExplode() {
        super.doExplode();
        ICBMSounds.BEAM_CHARGING.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, 0.8f, true);
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        if (!this.world().field_72995_K) {
            ICBMSounds.POWER_DOWN.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, 0.8f, true);
            if (this.canFocusBeam(this.world(), this.location) && this.isThreadCompleted()) {
                ConcurrentLinkedQueue list = this.getThreadResults();
                for (BlockPos targetPosition : list) {
                    double chance;
                    double distanceFromCenter = this.location.distance((Vec3i)targetPosition);
                    if (distanceFromCenter > (double)this.getBlastRadius() || !((chance = (double)this.getBlastRadius() - Math.random() * distanceFromCenter) > distanceFromCenter * 0.55)) continue;
                    IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
                    Block block = blockState.func_177230_c();
                    if (blockState.func_185904_a() == Material.field_151586_h || block == Blocks.field_150432_aD) {
                        this.world().func_175698_g(targetPosition);
                    }
                    if (blockState.func_185904_a() == Material.field_151576_e && (double)this.world().field_73012_v.nextFloat() > 0.8) {
                        this.world().func_180501_a(targetPosition, Blocks.field_150356_k.func_176223_P(), 3);
                    }
                    if (!block.func_176200_f((IBlockAccess)this.world(), targetPosition) || !Blocks.field_150480_ab.func_176196_c(this.world(), targetPosition)) continue;
                    if ((double)this.world().field_73012_v.nextFloat() > 0.99) {
                        this.world().func_180501_a(targetPosition, Blocks.field_150356_k.func_176223_P(), 3);
                        continue;
                    }
                    this.world().func_180501_a(targetPosition, Blocks.field_150480_ab.func_176223_P(), 3);
                    blockState = this.world().func_180495_p(targetPosition.func_177977_b());
                    block = blockState.func_177230_c();
                    if (!ConfigBlast.EXOTHERMIC_CREATE_NETHER_RACK || block != Blocks.field_150348_b && block != Blocks.field_150349_c && block != Blocks.field_150346_d || !((double)this.world().field_73012_v.nextFloat() > 0.75)) continue;
                    this.world().func_180501_a(targetPosition.func_177977_b(), Blocks.field_150424_aL.func_176223_P(), 3);
                }
                ICBMSounds.EXPLOSION_FIRE.play(this.field_77287_j, this.location.x() + 0.5, this.location.y() + 0.5, this.location.z() + 0.5, 6.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
            }
            if (!this.world().func_82736_K().func_82766_b("doDaylightCycle")) {
                this.world().func_72877_b(18000L);
            }
        }
    }

    @Override
    public boolean canFocusBeam(World worldObj, Location position) {
        return true;
    }
}

