/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.content.missile.EntityMissile;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MissileTrackerData {
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_TARGET = "target";
    private static final String NBT_MISSILE_DATA = "data";
    public int preLoadChunkTimer;
    public int ticksLeftToTarget;
    public Pos targetPos;
    public NBTTagCompound missileData;

    public MissileTrackerData(EntityMissile missile) {
        this.targetPos = missile.targetPos;
        this.missileData = missile.func_189511_e(new NBTTagCompound());
        this.missileData.func_82580_o("Pos");
    }

    public MissileTrackerData(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksLeftToTarget = nbt.func_74762_e(NBT_TICKS);
        this.targetPos = new Pos(nbt.func_74775_l(NBT_TARGET));
        this.missileData = nbt.func_74775_l(NBT_MISSILE_DATA);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_TICKS, this.ticksLeftToTarget);
        nbt.func_74782_a(NBT_TARGET, (NBTBase)this.targetPos.writeNBT(new NBTTagCompound()));
        nbt.func_74782_a(NBT_MISSILE_DATA, (NBTBase)this.missileData);
        return nbt;
    }
}

