/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCacheFluid
implements IStorageCache<FluidStack> {
    public static final Consumer<INetwork> INVALIDATE = n -> n.getFluidStorageCache().invalidate();
    private INetwork network;
    private CopyOnWriteArrayList<IStorage<FluidStack>> storages = new CopyOnWriteArrayList();
    private IStackList<FluidStack> list = API.instance().createFluidStackList();
    private List<IStorageCacheListener<FluidStack>> listeners = new LinkedList<IStorageCacheListener<FluidStack>>();
    private List<Pair<FluidStack, Integer>> batchedChanges = new ArrayList<Pair<FluidStack, Integer>>();

    public StorageCacheFluid(INetwork network) {
        this.network = network;
    }

    @Override
    public synchronized void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addFluidStorages(this.storages));
        this.list.clear();
        this.sort();
        for (IStorage<FluidStack> storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (FluidStack stack : storage.getStacks()) {
                this.add(stack, stack.amount, true, false);
            }
        }
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public synchronized void add(@Nonnull FluidStack stack, int size, boolean rebuilding, boolean batched) {
        this.list.add(stack, size);
        if (!rebuilding) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(stack, size));
            } else {
                this.batchedChanges.add((Pair<FluidStack, Integer>)Pair.of((Object)stack.copy(), (Object)size));
            }
        }
    }

    @Override
    public synchronized void remove(@Nonnull FluidStack stack, int size, boolean batched) {
        if (this.list.remove(stack, size)) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(stack, -size));
            } else {
                this.batchedChanges.add((Pair<FluidStack, Integer>)Pair.of((Object)stack.copy(), (Object)(-size)));
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.batchedChanges.isEmpty()) {
            this.batchedChanges.forEach(c -> this.listeners.forEach(l -> l.onChanged(c.getKey(), (Integer)c.getValue())));
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<FluidStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<FluidStack> getList() {
        return this.list;
    }

    @Override
    public List<IStorage<FluidStack>> getStorages() {
        return this.storages;
    }
}

