/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;

public class PacketSpawnParticle
extends LocationDoublePacket<PacketSpawnParticle> {
    private double dx;
    private double dy;
    private double dz;
    private int particleId;
    private int numParticles;
    private double rx;
    private double ry;
    private double rz;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(EnumParticleTypes particle, double x, double y, double z, double dx, double dy, double dz) {
        super(x, y, z);
        this.particleId = particle.ordinal();
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.numParticles = 1;
        this.rz = 0.0;
        this.ry = 0.0;
        this.rx = 0.0;
    }

    public PacketSpawnParticle(EnumParticleTypes particle, double x, double y, double z, double dx, double dy, double dz, int numParticles, double rx, double ry, double rz) {
        this(particle, x, y, z, dx, dy, dz);
        this.numParticles = numParticles;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public PacketSpawnParticle(EnumCustomParticleType particle, double x, double y, double z, double dx, double dy, double dz) {
        super(x, y, z);
        this.particleId = EnumParticleTypes.values().length + particle.ordinal();
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.numParticles = 1;
        this.rz = 0.0;
        this.ry = 0.0;
        this.rx = 0.0;
    }

    public PacketSpawnParticle(EnumCustomParticleType particle, double x, double y, double z, double dx, double dy, double dz, int numParticles, double rx, double ry, double rz) {
        this(particle, x, y, z, dx, dy, dz);
        this.numParticles = numParticles;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.particleId);
        buffer.writeDouble(this.dx);
        buffer.writeDouble(this.dy);
        buffer.writeDouble(this.dz);
        buffer.writeInt(this.numParticles);
        if (this.numParticles > 1) {
            buffer.writeDouble(this.rx);
            buffer.writeDouble(this.ry);
            buffer.writeDouble(this.rz);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.particleId = buffer.readInt();
        this.dx = buffer.readDouble();
        this.dy = buffer.readDouble();
        this.dz = buffer.readDouble();
        this.numParticles = buffer.readInt();
        if (this.numParticles > 1) {
            this.rx = buffer.readDouble();
            this.ry = buffer.readDouble();
            this.rz = buffer.readDouble();
        }
    }

    @Override
    public void handleClientSide(PacketSpawnParticle message, EntityPlayer player) {
        for (int i = 0; i < this.numParticles; ++i) {
            double x = message.x + (this.numParticles == 1 ? 0.0 : player.field_70170_p.field_73012_v.nextDouble() * this.rx);
            double y = message.y + (this.numParticles == 1 ? 0.0 : player.field_70170_p.field_73012_v.nextDouble() * this.ry);
            double z = message.z + (this.numParticles == 1 ? 0.0 : player.field_70170_p.field_73012_v.nextDouble() * this.rz);
            if (this.particleId >= EnumParticleTypes.values().length) {
                EnumCustomParticleType particle = EnumCustomParticleType.values()[message.particleId - EnumParticleTypes.values().length];
                PneumaticCraftRepressurized.proxy.playCustomParticle(particle, player.field_70170_p, x, y, z, message.dx, message.dy, message.dz);
                continue;
            }
            player.field_70170_p.func_175688_a(EnumParticleTypes.values()[message.particleId], x, y, z, message.dx, message.dy, message.dz, new int[0]);
        }
    }

    @Override
    public void handleServerSide(PacketSpawnParticle message, EntityPlayer player) {
    }
}

