/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidSorter
extends TileEntityIEBase
implements IEBlockInterfaces.IGuiTile {
    public byte[] sortWithNBT = new byte[]{1, 1, 1, 1, 1, 1};
    public FluidStack[][] filters = new FluidStack[6][8];
    private static Set<BlockPos> usedRouters = null;
    IFluidHandler[] insertionHandlers = new IFluidHandler[]{new SorterFluidHandler(this, EnumFacing.DOWN), new SorterFluidHandler(this, EnumFacing.UP), new SorterFluidHandler(this, EnumFacing.NORTH), new SorterFluidHandler(this, EnumFacing.SOUTH), new SorterFluidHandler(this, EnumFacing.WEST), new SorterFluidHandler(this, EnumFacing.EAST)};

    public int routeFluid(EnumFacing inputSide, FluidStack stack, boolean doFill) {
        int ret = 0;
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            EnumFacing[][] validOutputs = this.getValidOutputs(inputSide, stack);
            ret += this.doInsert(stack, validOutputs[0], doFill);
            ret += this.doInsert(stack, validOutputs[1], doFill);
            if (first) {
                usedRouters = null;
            }
        }
        return ret;
    }

    private boolean canRoute() {
        return usedRouters == null || !usedRouters.contains(this.field_174879_c);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = usedRouters == null;
        if (first) {
            usedRouters = new HashSet<BlockPos>();
        }
        usedRouters.add(this.field_174879_c);
        return first;
    }

    private int doInsert(FluidStack stack, EnumFacing[] sides, boolean doFill) {
        int ret = 0;
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && stack.amount > 0; --lengthFiltered) {
            int rand = Utils.RAND.nextInt(lengthFiltered);
            EnumFacing currentSide = sides[rand];
            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, this.field_174879_c.func_177972_a(currentSide));
            if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, currentSide.func_176734_d())) {
                IFluidHandler fluidOut = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, currentSide.func_176734_d());
                assert (fluidOut != null);
                int filledHere = fluidOut.fill(stack, doFill);
                stack.amount -= filledHere;
                ret += filledHere;
            }
            sides[rand] = sides[lengthFiltered - 1];
        }
        return ret;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sortWithNBT.length) {
            return this.sortWithNBT[side] == 1;
        }
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 14;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.func_74764_b("sideConfig")) {
            this.sortWithNBT = message.func_74770_j("sideConfig");
        }
        if (message.func_74764_b("filter_side")) {
            int side = message.func_74762_e("filter_side");
            int slot = message.func_74762_e("filter_slot");
            this.filters[side][slot] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)message.func_74775_l("filter"));
        }
        this.func_70296_d();
    }

    public EnumFacing[][] getValidOutputs(EnumFacing inputSide, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return new EnumFacing[2][0];
        }
        ArrayList<EnumFacing> validFilteredInvOuts = new ArrayList<EnumFacing>(6);
        ArrayList<EnumFacing> validUnfilteredInvOuts = new ArrayList<EnumFacing>(6);
        for (EnumFacing side : EnumFacing.values()) {
            if (side == inputSide || !this.field_145850_b.func_175667_e(this.func_174877_v().func_177972_a(side))) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (FluidStack filterStack : this.filters[side.ordinal()]) {
                boolean b;
                if (filterStack == null) continue;
                unmapped = false;
                boolean bl = b = filterStack.getFluid() == fluidStack.getFluid();
                if (this.doNBT(side.ordinal())) {
                    b &= FluidStack.areFluidStackTagsEqual((FluidStack)filterStack, (FluidStack)fluidStack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                validFilteredInvOuts.add(side);
                continue;
            }
            if (!unmapped) continue;
            validUnfilteredInvOuts.add(side);
        }
        return new EnumFacing[][]{validFilteredInvOuts.toArray(new EnumFacing[0]), validUnfilteredInvOuts.toArray(new EnumFacing[0])};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sortWithNBT = nbt.func_74770_j("sortWithNBT");
        for (int side = 0; side < 6; ++side) {
            NBTTagList filterList = nbt.func_150295_c("filter_" + side, 10);
            for (int i = 0; i < filterList.func_74745_c(); ++i) {
                this.filters[side][i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)filterList.func_150305_b(i));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74773_a("sortWithNBT", this.sortWithNBT);
        for (int side = 0; side < 6; ++side) {
            NBTTagList filterList = new NBTTagList();
            for (int i = 0; i < this.filters[side].length; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                if (this.filters[side][i] != null) {
                    this.filters[side][i].writeToNBT(tag);
                }
                filterList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("filter_" + side, (NBTBase)filterList);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null) {
            return (T)this.insertionHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    static class SorterFluidHandler
    implements IFluidHandler {
        TileEntityFluidSorter tile;
        EnumFacing facing;

        SorterFluidHandler(TileEntityFluidSorter tile, EnumFacing facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            return this.tile.routeFluid(this.facing, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, 0)};
        }
    }
}

