/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.servermonitor.bungeecord;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;
import pw.aaron1011.servermonitor.bungeecord.PingCallback;
import pw.aaron1011.servermonitor.bungeecord.ServerStatus;

public class ServerMonitorBungeeCord
extends Plugin
implements Listener {
    public static ServerMonitorBungeeCord INSTANCE;
    private Map<PingCallback, ServerInfo> needsPing = new ConcurrentHashMap<PingCallback, ServerInfo>();
    private Map<ServerInfo, PingCallback> needsPingReverse = new ConcurrentHashMap<ServerInfo, PingCallback>();
    private Map<ServerInfo, ServerStatus> serverStatus = new ConcurrentHashMap<ServerInfo, ServerStatus>();
    private Configuration config;

    public void onEnable() {
        File file;
        INSTANCE = this;
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try (InputStream in = this.getResourceAsStream("config.yml");){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy config!", e);
            }
        }
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading config: ", e);
        }
        this.getLogger().info("ServerMonitor loaded successfully!");
        for (ServerInfo info : ProxyServer.getInstance().getServers().values()) {
            this.serverStatus.put(info, ServerStatus.OFFLINE);
            this.startPinging(info);
        }
        ProxyServer.getInstance().getScheduler().schedule((Plugin)this, this::pingServers, 0L, (long)this.config.getInt("ping_interval"), TimeUnit.SECONDS);
    }

    public ServerInfo getServerInfo(PingCallback callback) {
        return this.needsPing.get(callback);
    }

    private void pingServers() {
        for (Map.Entry<PingCallback, ServerInfo> entry : this.needsPing.entrySet()) {
            entry.getKey().setInFlight();
            entry.getValue().ping((Callback)entry.getKey());
        }
    }

    private void startPinging(ServerInfo serverInfo) {
        if (this.needsPingReverse.containsKey(serverInfo)) {
            return;
        }
        this.getLogger().info("Starting to ping: " + serverInfo.getAddress());
        PingCallback callback = new PingCallback();
        this.needsPing.put(callback, serverInfo);
        this.needsPingReverse.put(serverInfo, callback);
    }

    private void stopPinging(Server server) {
        if (!this.needsPingReverse.containsKey(server.getInfo())) {
            return;
        }
        this.getLogger().info("Stopping pinging: " + server.getAddress());
        this.needsPingReverse.get(server.getInfo()).setDone();
    }

    @EventHandler
    public void onPlayerJoin(ServerSwitchEvent event) {
        this.stopPinging(event.getPlayer().getServer());
        this.updateServerStatus(event.getPlayer().getServer().getInfo(), ServerStatus.ONLINE, true);
        if (event.getPlayer().getServer().getInfo().getPlayers().size() == 1) {
            this.getLogger().info("Sending initial update to server " + event.getPlayer().getServer().getInfo().getName());
            for (Map.Entry<ServerInfo, ServerStatus> entry : this.serverStatus.entrySet()) {
                if (entry.getKey().equals(event.getPlayer().getServer().getInfo())) continue;
                this.notifyServerImmediate(event.getPlayer().getServer().getInfo(), entry.getKey(), entry.getValue(), true);
            }
        }
    }

    @EventHandler
    public void onPlayerDisconnect(ServerDisconnectEvent event) {
        if (event.getPlayer().getServer() == null) {
            return;
        }
        this.updateServerStatus(event.getPlayer().getServer().getInfo(), ServerStatus.ONLINE, true);
        this.updateServerStatus(event.getTarget(), ServerStatus.ONLINE, true);
        Collection players = event.getTarget().getPlayers();
        if (players.size() == 0) {
            this.startPinging(event.getPlayer().getServer().getInfo());
        }
    }

    public void removeInternal(PingCallback callback) {
        ServerInfo info = this.needsPing.remove(callback);
        this.needsPingReverse.remove(info);
    }

    public void updateServerStatus(ServerInfo serverInfo, ServerStatus status, boolean force) {
        boolean statusChanged;
        boolean bl = statusChanged = this.serverStatus.put(serverInfo, status) != status;
        if (statusChanged || force) {
            this.getLogger().info("Status of server " + serverInfo.getName() + " changed to " + (Object)((Object)status));
            for (ServerInfo targetServer : ProxyServer.getInstance().getServers().values()) {
                this.notifyServerImmediate(targetServer, serverInfo, status, statusChanged);
            }
        }
    }

    private void writeUTF(ByteBuffer buffer, byte[] string) {
        if ((short)string.length != string.length) {
            throw new IllegalArgumentException("String is too long: " + string);
        }
        buffer.putShort((short)string.length);
        buffer.put(string);
    }

    private void notifyServerImmediate(ServerInfo target, ServerInfo changed, ServerStatus newStatus, boolean statusChanged) {
        this.notifyServer(target, changed, newStatus, false, statusChanged);
    }

    private void notifyServer(ServerInfo target, ServerInfo changed, ServerStatus newStatus, boolean queue, boolean statusChanged) {
        this.getLogger().info("Notifing: " + target);
        byte messageId = 0;
        byte status = newStatus == ServerStatus.OFFLINE ? (byte)0 : 1;
        short numPlayers = (short)changed.getPlayers().size();
        byte[] serverName = changed.getName().getBytes();
        boolean shouldBroadcast = statusChanged;
        List notifySection = this.config.getSection("notify").getStringList(target.getName());
        String broadcastMessage = "";
        if (shouldBroadcast &= notifySection.contains(changed.getName())) {
            broadcastMessage = this.config.getString("broadcast_message");
            String statusMessage = newStatus == ServerStatus.ONLINE ? "online" : "offline";
            broadcastMessage = broadcastMessage.replace("{server}", changed.getName()).replace("{status}", statusMessage);
        }
        byte[] broadcastMessageRaw = broadcastMessage.getBytes();
        int len = 6 + serverName.length + 2 + broadcastMessageRaw.length;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put(messageId);
        buffer.put(status);
        buffer.putShort(numPlayers);
        this.writeUTF(buffer, serverName);
        this.writeUTF(buffer, broadcastMessageRaw);
        target.sendData("ServerMonitor", buffer.array(), queue);
    }
}

