/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.servermonitor.sponge.data;

import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import pw.aaron1011.servermonitor.sponge.ServerMonitorSponge;

public class ConfigFileManager<T> {
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private ConfigurationNode node;
    private T config;
    private Class<T> type;
    private final ConfigurationOptions options;

    public ConfigFileManager(ConfigurationLoader<CommentedConfigurationNode> loader, ConfigurationOptions options, Class<T> type) {
        this.loader = loader;
        this.options = options;
        this.type = type;
    }

    public T getPluginConfig() {
        return this.config;
    }

    public void reload(boolean notify) {
        this.load(notify);
        this.save();
    }

    public void load(boolean notify) {
        try {
            this.node = this.loader.load(this.options);
            this.config = this.node.getValue(TypeToken.of(this.type), () -> {
                try {
                    return this.type.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.checkConfig();
        }
        catch (Exception e) {
            ServerMonitorSponge.INSTANCE.logger.error("Error reloading config file!", (Throwable)e);
        }
    }

    public void save() {
        try {
            this.node.setValue(TypeToken.of(this.type), this.config);
            this.loader.save(this.node);
        }
        catch (Exception e) {
            ServerMonitorSponge.INSTANCE.logger.error("Failed to save config file", (Throwable)e);
        }
    }

    public void checkConfig() {
    }
}

