/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.servermonitor.sponge.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import pw.aaron1011.servermonitor.sponge.ServerMonitorSponge;
import pw.aaron1011.servermonitor.sponge.data.LocationData;
import pw.aaron1011.servermonitor.sponge.data.SignInstance;

@ConfigSerializable
public class SignData {
    @Setting(value="signs")
    private Map<String, List<SignInstance>> signs = new HashMap<String, List<SignInstance>>();
    private Map<LocationData, SignInstance> locationCache = new HashMap<LocationData, SignInstance>();

    public void rebuildCache() {
        this.locationCache.clear();
        for (List<SignInstance> instances : this.signs.values()) {
            for (SignInstance instance : instances) {
                this.locationCache.put(instance.locationData, instance);
            }
        }
    }

    public void addInstance(SignInstance instance) {
        this.signs.computeIfAbsent(instance.serverName, s -> new ArrayList()).add(instance);
        this.locationCache.put(instance.locationData, instance);
        ServerMonitorSponge.INSTANCE.signFileManager.save();
    }

    public void removeInstance(SignInstance instance) {
        this.signs.get(instance.serverName).remove(instance);
        this.locationCache.remove(instance.locationData);
        ServerMonitorSponge.INSTANCE.signFileManager.save();
    }

    public List<SignInstance> getInstances(String serverName) {
        return this.signs.get(serverName);
    }

    public Optional<SignInstance> getInstance(Location<World> location) {
        return Optional.ofNullable(this.locationCache.get(new LocationData(location)));
    }
}

