/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.traits.ArmorTraits;
import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.traits.AbstractArmorTrait;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TraitAmbitious
extends AbstractArmorTrait {
    public TraitAmbitious() {
        super("ambitious", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingXPDrop(LivingExperienceDropEvent evt) {
        int addXP;
        int xpToDrop = evt.getDroppedExperience();
        if (xpToDrop > 0 && (addXP = TraitAmbitious.getXpToAdd(evt.getAttackingPlayer())) > 0) {
            evt.setDroppedExperience(addXP + xpToDrop);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent evt) {
        int addXP;
        int xpToDrop = evt.getExpToDrop();
        if (xpToDrop > 0 && (addXP = TraitAmbitious.getXpToAdd(evt.getPlayer())) > 0) {
            evt.setExpToDrop(xpToDrop + addXP);
        }
    }

    private static int getXpToAdd(EntityPlayer player) {
        int level = (int)ArmorHelper.getArmorAbilityLevel(player, ArmorTraits.ambitious.identifier);
        return level > 0 ? random.nextInt(level * 2 + 1) + 2 : 0;
    }
}

