/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Optional;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

@NonnullByDefault
public interface TeleportHelper {
    public static final int DEFAULT_HEIGHT = 3;
    public static final int DEFAULT_WIDTH = 9;
    public static final int DEFAULT_FLOOR_CHECK_DISTANCE = 2;

    default public Optional<Location<World>> getSafeLocation(Location<World> location) {
        return this.getSafeLocation(location, 3, 9, 2, TeleportHelperFilters.DEFAULT, new TeleportHelperFilter[0]);
    }

    default public Optional<Location<World>> getSafeLocation(Location<World> location, int height, int width) {
        return this.getSafeLocation(location, height, width, 2, TeleportHelperFilters.DEFAULT, new TeleportHelperFilter[0]);
    }

    default public Optional<Location<World>> getSafeLocation(Location<World> location, int height, int width, int floorDistance) {
        return this.getSafeLocation(location, height, width, floorDistance, TeleportHelperFilters.DEFAULT, TeleportHelperFilters.CONFIG);
    }

    public Optional<Location<World>> getSafeLocation(Location<World> var1, int var2, int var3, int var4, TeleportHelperFilter var5, TeleportHelperFilter ... var6);

    default public Optional<Location<World>> getSafeLocationWithBlacklist(Location<World> location, int height, int width, int floorDistance, TeleportHelperFilter ... filters) {
        return this.getSafeLocation(location, height, width, floorDistance, TeleportHelperFilters.CONFIG, filters);
    }
}

