/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class PhaseTrackerCategory
extends ConfigCategory {
    @Setting(value="verbose", comment="If 'true', the phase tracker will print out when there are too many phases \nbeing entered, usually considered as an issue of phase re-entrance and \nindicates an unexpected issue of tracking phases not to complete. \nIf this is not reported yet, please report to Sponge. If it has been \nreported, you may disable this.")
    private boolean isVerbose = true;
    @Setting(value="verbose-errors", comment="If 'true', the phase tracker will dump extra information about the current phases \nwhen certain non-PhaseTracker related exceptions occur. This is usually not necessary, as the information \nin the exception itself can normally be used to determine the cause of the issue")
    private boolean verboseErrors = false;
    @Setting(value="capture-async-spawning-entities", comment="If set to 'true', when a mod or plugin attempts to spawn an entity \noff the main server thread, Sponge will automatically \ncapture said entity to spawn it properly on the main \nserver thread. The catch to this is that some mods are \nnot considering the consequences of spawning an entity \noff the server thread, and are unaware of potential race \nconditions they may cause. If this is set to false, \nSponge will politely ignore the entity being spawned, \nand emit a warning about said spawn anyways.")
    private boolean captureAndSpawnEntitiesSync = true;
    @Setting(value="resync-commands-from-async", comment="If set to 'true', when a mod or plugin attempts to submit a command\nasynchronously, Sponge will automatically capture said command\nand submit it for processing on the server thread. The catch to\nthis is that some mods are performing these commands in vanilla\nwithout considering the possible consequences of such commands\naffecting any thread-unsafe parts of Minecraft, such as worlds,\nblock edits, entity spawns, etc. If this is set to false, Sponge\nwill politely ignore the command being executed, and emit a warning\nabout said command anyways.")
    private boolean resyncAsyncCommands = true;
    @Setting(value="generate-stacktrace-per-phase", comment="If 'true', more thorough debugging for PhaseStates \nsuch that a StackTrace is created every time a PhaseState \nswitches, allowing for more fine grained troubleshooting \nin the cases of runaway phase states. Note that this is \nnot extremely performant and may have some associated costs \nwith generating the stack traces constantly.")
    private boolean generateStackTracePerStateEntry = false;
    @Setting(value="maximum-printed-runaway-counts", comment="If verbose is not enabled, this restricts the amount of \nrunaway phase state printouts, usually happens on a server \nwhere a PhaseState is not completing. Although rare, it should \nnever happen, but when it does, sometimes it can continuously print \nmore and more. This attempts to placate that while a fix can be worked on \nto resolve the runaway. If verbose is enabled, they will always print.")
    private int maxRunawayCount = 3;
    @Setting(value="max-block-processing-depth", comment="The maximum number of times to recursively process transactions in a single phase.\nSome mods may interact badly with Sponge's block capturing system, causing Sponge to\nend up capturing block transactions every time it tries to process an existing batch.\nDue to the recursive nature of the depth-first processing that Sponge uses to handle block transactions,\nthis can result in a stack overflow, which causes us to lose all infomration about the original cause of the issue.\nTo prevent a stack overflow, Sponge tracks the current processing depth, and aborts processing when it exceeds\nthis threshold.\nThe default value should almost always work properly -  it's unlikely you'll ever have to change it.")
    private int maxBlockProcessingDepth = 1000;
    @Setting(value="report-null-source-blocks-on-neighbor-notifications", comment="If true, when a mod attempts to perform a neighbor notification\non a block, some mods do not know to perform a 'null' check\non the source block of their TileEntity. This usually goes by\nunnoticed by other mods, because they may perform '==' instance\nequality checks instead of calling methods on the potentially\nnull Block, but Sponge uses the block to build information to\nhelp tracking. This has caused issues in the past. Generally,\nthis can be useful for leaving \"true\" so a proper report is\ngenerated once for your server, and can be reported to the\noffending mod author.\nThis is 'false' by default in SpongeVanilla.\nReview the following links for more info:\n https://gist.github.com/gabizou/ad570dc09dfed259cac9d74284e78e8b\n https://github.com/SpongePowered/SpongeForge/issues/2787\n")
    private boolean reportNullSourceBlocks = this.isVanilla();
    @Setting(value="auto-fix-null-source-block-providing-tile-entities", comment="A mapping that is semi-auto-populating for TileEntities whose types\nare found to be providing \"null\" Block sources as neighbor notifications\nthat end up causing crashes or spam reports. If the value is set to \n\"true\", then a \"workaround\" will be attempted. If not, the \n\ncurrent BlockState at the target source will be queried from the world.\nThis map having a specific\nentry of a TileEntity will prevent a log or warning come up to any logs\nwhen that \"null\" arises, and Sponge will self-rectify the TileEntity\nby calling the method \"getBlockType()\". It is advised that if the mod\nid in question is coming up, that the mod author is notified about the\nerror-prone usage of the field \"blockType\". You can refer them to\nthe following links for the issue:\n https://gist.github.com/gabizou/ad570dc09dfed259cac9d74284e78e8b\n https://github.com/SpongePowered/SpongeForge/issues/2787\nAlso, please provide them with these links for the example PR to\nfix the issue itself, as the fix is very simple:\nhttps://github.com/TehNut/Soul-Shards-Respawn/pull/24\nhttps://github.com/Epoxide-Software/Enchanting-Plus/pull/135\n")
    private Map<String, Boolean> autoFixedTiles = new HashMap<String, Boolean>();

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public int getMaxBlockProcessingDepth() {
        return this.maxBlockProcessingDepth;
    }

    public void resetMaxDepthTo1000() {
        this.maxBlockProcessingDepth = 1000;
    }

    public boolean verboseErrors() {
        return this.verboseErrors;
    }

    public boolean captureEntitiesAsync() {
        return this.captureAndSpawnEntitiesSync;
    }

    public boolean resyncCommandsAsync() {
        return this.resyncAsyncCommands;
    }

    public boolean generateStackTracePerStateEntry() {
        return this.generateStackTracePerStateEntry;
    }

    public int getMaximumRunawayCount() {
        return this.maxRunawayCount;
    }

    public boolean isReportNullSourceBlocks() {
        return this.reportNullSourceBlocks;
    }

    public void setReportNullSourceBlocks(boolean reportNullSourceBlocks) {
        this.reportNullSourceBlocks = reportNullSourceBlocks;
    }

    public Map<String, Boolean> getAutoFixedTiles() {
        return this.autoFixedTiles;
    }

    private boolean isVanilla() {
        try {
            return Launch.classLoader.getClassBytes("net.minecraftforge.common.ForgeVersion") == null;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public void setAutoFixedTiles(Map<String, Boolean> autoFixedTiles) {
        this.autoFixedTiles = autoFixedTiles;
    }
}

