/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBodyPartRotationalData;
import org.spongepowered.api.data.manipulator.mutable.entity.BodyPartRotationalData;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeBodyPartRotationalData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.Constants;

public class SpongeBodyPartRotationalData
extends AbstractData<BodyPartRotationalData, ImmutableBodyPartRotationalData>
implements BodyPartRotationalData {
    private Map<BodyPart, Vector3d> rotations;

    public SpongeBodyPartRotationalData() {
        this((Map<BodyPart, Vector3d>)ImmutableMap.builder().put((Object)BodyParts.HEAD, (Object)Constants.Entity.ArmorStand.DEFAULT_HEAD_ROTATION).put((Object)BodyParts.CHEST, (Object)Constants.Entity.ArmorStand.DEFAULT_CHEST_ROTATION).put((Object)BodyParts.LEFT_ARM, (Object)Constants.Entity.ArmorStand.DEFAULT_LEFT_ARM_ROTATION).put((Object)BodyParts.RIGHT_ARM, (Object)Constants.Entity.ArmorStand.DEFAULT_RIGHT_ARM_ROTATION).put((Object)BodyParts.LEFT_LEG, (Object)Constants.Entity.ArmorStand.DEFAULT_LEFT_LEG_ROTATION).put((Object)BodyParts.RIGHT_LEG, (Object)Constants.Entity.ArmorStand.DEFAULT_RIGHT_LEG_ROTATION).build());
    }

    public SpongeBodyPartRotationalData(Map<BodyPart, Vector3d> rotations) {
        super(BodyPartRotationalData.class);
        this.rotations = Maps.newHashMap((Map)((Map)Preconditions.checkNotNull(rotations, (Object)"rotations")));
        this.registerGettersAndSetters();
    }

    @Override
    public DataContainer toContainer() {
        Vector3d headRotation = this.rotations.get(BodyParts.HEAD);
        Vector3d chestRotation = this.rotations.get(BodyParts.CHEST);
        Vector3d leftArmRotation = this.rotations.get(BodyParts.LEFT_ARM);
        Vector3d rightArmRotation = this.rotations.get(BodyParts.RIGHT_ARM);
        Vector3d leftLegRotation = this.rotations.get(BodyParts.LEFT_LEG);
        Vector3d rightLegRotation = this.rotations.get(BodyParts.RIGHT_LEG);
        return super.toContainer().set(Keys.BODY_ROTATIONS, (Object)this.rotations).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_X), (Object)headRotation.getX()).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)headRotation.getY()).set(Keys.HEAD_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)headRotation.getZ()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_X), (Object)chestRotation.getX()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)chestRotation.getY()).set(Keys.CHEST_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)chestRotation.getZ()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_X), (Object)leftArmRotation.getX()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)leftArmRotation.getY()).set(Keys.LEFT_ARM_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)leftArmRotation.getZ()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_X), (Object)rightArmRotation.getX()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)rightArmRotation.getY()).set(Keys.RIGHT_ARM_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)rightArmRotation.getZ()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_X), (Object)leftLegRotation.getX()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)leftLegRotation.getY()).set(Keys.LEFT_LEG_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)leftLegRotation.getZ()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_X), (Object)rightLegRotation.getX()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_Y), (Object)rightLegRotation.getY()).set(Keys.RIGHT_LEG_ROTATION.getQuery().then(Queries.POSITION_Z), (Object)rightLegRotation.getZ());
    }

    @Override
    public MapValue<BodyPart, Vector3d> partRotation() {
        return new SpongeMapValue<BodyPart, Vector3d>(Keys.BODY_ROTATIONS, this.rotations);
    }

    @Override
    public Value<Vector3d> headDirection() {
        return new SpongeValue<Vector3d>(Keys.HEAD_ROTATION, this.rotations.get(BodyParts.HEAD));
    }

    @Override
    public Value<Vector3d> bodyRotation() {
        return new SpongeValue<Vector3d>(Keys.CHEST_ROTATION, this.rotations.get(BodyParts.CHEST));
    }

    @Override
    public Value<Vector3d> leftArmDirection() {
        return new SpongeValue<Vector3d>(Keys.LEFT_ARM_ROTATION, this.rotations.get(BodyParts.LEFT_ARM));
    }

    @Override
    public Value<Vector3d> rightArmDirection() {
        return new SpongeValue<Vector3d>(Keys.RIGHT_ARM_ROTATION, this.rotations.get(BodyParts.RIGHT_ARM));
    }

    @Override
    public Value<Vector3d> leftLegDirection() {
        return new SpongeValue<Vector3d>(Keys.LEFT_LEG_ROTATION, this.rotations.get(BodyParts.LEFT_LEG));
    }

    @Override
    public Value<Vector3d> rightLegDirection() {
        return new SpongeValue<Vector3d>(Keys.RIGHT_LEG_ROTATION, this.rotations.get(BodyParts.RIGHT_LEG));
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.BODY_ROTATIONS, () -> this.rotations);
        this.registerFieldSetter(Keys.BODY_ROTATIONS, rotations -> {
            this.rotations = Maps.newHashMap((Map)rotations);
        });
        this.registerKeyValue(Keys.BODY_ROTATIONS, this::partRotation);
        this.registerFieldGetter(Keys.HEAD_ROTATION, () -> this.rotations.get(BodyParts.HEAD));
        this.registerFieldSetter(Keys.HEAD_ROTATION, value -> this.rotations.put(BodyParts.HEAD, (Vector3d)value));
        this.registerKeyValue(Keys.HEAD_ROTATION, this::headDirection);
        this.registerFieldGetter(Keys.CHEST_ROTATION, () -> this.rotations.get(BodyParts.CHEST));
        this.registerFieldSetter(Keys.CHEST_ROTATION, value -> this.rotations.put(BodyParts.CHEST, (Vector3d)value));
        this.registerKeyValue(Keys.CHEST_ROTATION, this::bodyRotation);
        this.registerFieldGetter(Keys.LEFT_ARM_ROTATION, () -> this.rotations.get(BodyParts.LEFT_ARM));
        this.registerFieldSetter(Keys.LEFT_ARM_ROTATION, value -> this.rotations.put(BodyParts.LEFT_ARM, (Vector3d)value));
        this.registerKeyValue(Keys.LEFT_ARM_ROTATION, this::leftArmDirection);
        this.registerFieldGetter(Keys.RIGHT_ARM_ROTATION, () -> this.rotations.get(BodyParts.RIGHT_ARM));
        this.registerFieldSetter(Keys.RIGHT_ARM_ROTATION, value -> this.rotations.put(BodyParts.RIGHT_ARM, (Vector3d)value));
        this.registerKeyValue(Keys.RIGHT_ARM_ROTATION, this::rightArmDirection);
        this.registerFieldGetter(Keys.LEFT_LEG_ROTATION, () -> this.rotations.get(BodyParts.LEFT_LEG));
        this.registerFieldSetter(Keys.LEFT_LEG_ROTATION, value -> this.rotations.put(BodyParts.LEFT_LEG, (Vector3d)value));
        this.registerKeyValue(Keys.LEFT_LEG_ROTATION, this::leftLegDirection);
        this.registerFieldGetter(Keys.RIGHT_LEG_ROTATION, () -> this.rotations.get(BodyParts.RIGHT_LEG));
        this.registerFieldSetter(Keys.RIGHT_LEG_ROTATION, value -> this.rotations.put(BodyParts.RIGHT_LEG, (Vector3d)value));
        this.registerKeyValue(Keys.RIGHT_LEG_ROTATION, this::rightLegDirection);
    }

    @Override
    public BodyPartRotationalData copy() {
        return new SpongeBodyPartRotationalData(this.rotations);
    }

    @Override
    public ImmutableBodyPartRotationalData asImmutable() {
        return new ImmutableSpongeBodyPartRotationalData(this.rotations);
    }
}

