/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.persistence.schematic.SchematicUpdater1_to_2;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.mixin.core.server.MinecraftServerAccessor;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.PairStream;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.BlockPaletteWrapper;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeSchematicBuilder;

public class SchematicTranslator
implements DataTranslator<Schematic> {
    private static final SchematicTranslator INSTANCE = new SchematicTranslator();
    private static final TypeToken<Schematic> TYPE_TOKEN = TypeToken.of(Schematic.class);
    private static final ConcurrentSkipListSet<String> MISSING_MOD_IDS = new ConcurrentSkipListSet();
    private static final DataContentUpdater V1_TO_2 = new SchematicUpdater1_to_2();
    @Nullable
    private static DataFixer VANILLA_FIXER;

    public static SchematicTranslator get() {
        return INSTANCE;
    }

    private SchematicTranslator() {
    }

    @Override
    public String getId() {
        return "sponge:schematic";
    }

    @Override
    public String getName() {
        return "Sponge Schematic Translator";
    }

    @Override
    public TypeToken<Schematic> getToken() {
        return TYPE_TOKEN;
    }

    @Override
    public Schematic translate(DataView unprocessed) throws InvalidDataException {
        Palette<BiomeType> biomePalette;
        BlockPaletteWrapper palette;
        Optional<DataView> dot_data;
        int dataVersion;
        List dataViews;
        int version;
        if (VANILLA_FIXER == null) {
            VANILLA_FIXER = ((MinecraftServerAccessor)SpongeImpl.getServer()).accessor$getDataFixer();
        }
        if ((version = unprocessed.getInt(Constants.Sponge.Schematic.VERSION).get().intValue()) > 2) {
            throw new InvalidDataException(String.format("Unknown schematic version %d (current version is %d)", version, 2));
        }
        if (version == 1) {
            unprocessed = V1_TO_2.update(unprocessed);
        }
        if ((dataViews = (List)unprocessed.getViewList(Constants.Sponge.Schematic.Versions.V1_TILE_ENTITY_DATA).orElse(null)) != null) {
            unprocessed.remove(Constants.Sponge.Schematic.Versions.V1_TILE_ENTITY_DATA);
            unprocessed.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, dataViews);
        }
        boolean needsFixers = (dataVersion = unprocessed.getInt(Constants.Sponge.Schematic.DATA_VERSION).get().intValue()) < 1343 && VANILLA_FIXER != null;
        DataView updatedView = unprocessed;
        DataView metadata = updatedView.getView(Constants.Sponge.Schematic.METADATA).orElse(null);
        if (metadata != null && (dot_data = metadata.getView(DataQuery.of("."))).isPresent()) {
            DataView data = dot_data.get();
            for (DataQuery key : data.getKeys(false)) {
                if (metadata.contains(key)) continue;
                metadata.set(key, data.get(key).get());
            }
        }
        if (metadata != null) {
            String schematicName = metadata.getString(Constants.Sponge.Schematic.NAME).orElse("unknown");
            metadata.getStringList(Constants.Sponge.Schematic.REQUIRED_MODS).ifPresent(mods -> {
                for (String modId : mods) {
                    if (Sponge.getPluginManager().getPlugin(modId).isPresent() || !MISSING_MOD_IDS.add(modId)) continue;
                    SpongeImpl.getLogger().warn("When attempting to load the Schematic: " + schematicName + " there is a missing modid: " + modId + " some blocks/tiles/entities may not load correctly.");
                }
            });
        }
        short width = updatedView.getShort(Constants.Sponge.Schematic.WIDTH).get();
        short height = updatedView.getShort(Constants.Sponge.Schematic.HEIGHT).get();
        short length = updatedView.getShort(Constants.Sponge.Schematic.LENGTH).get();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new InvalidDataException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, (int)height, (int)length, 65535));
        }
        int[] offset = (int[])updatedView.get(Constants.Sponge.Schematic.OFFSET).orElse(new int[3]);
        if (offset.length != 3) {
            throw new InvalidDataException("Schematic offset was not of length 3");
        }
        Optional<DataView> paletteData = updatedView.getView(Constants.Sponge.Schematic.PALETTE);
        int palette_max = updatedView.getInt(Constants.Sponge.Schematic.PALETTE_MAX).orElse(65535);
        if (paletteData.isPresent()) {
            BimapPalette<BlockState> bimap = new BimapPalette<BlockState>(PaletteTypes.LOCAL_BLOCKS, palette_max != 65535 ? palette_max : 64);
            palette = new BlockPaletteWrapper(bimap, BlockPaletteTypes.LOCAL);
            DataView paletteMap = paletteData.get();
            Set<DataQuery> paletteKeys = paletteMap.getKeys(false);
            for (DataQuery key : paletteKeys) {
                BlockState state = Sponge.getRegistry().getType(BlockState.class, key.getParts().get(0)).orElseGet(BlockTypes.BEDROCK::getDefaultState);
                bimap.assign(state, paletteMap.getInt(key).get());
            }
        } else {
            palette = GlobalPalette.getBlockPalette();
        }
        Optional<DataView> biomePaletteData = updatedView.getView(Constants.Sponge.Schematic.BIOME_PALETTE);
        int biome_max = updatedView.getInt(Constants.Sponge.Schematic.BIOME_PALETTE_MAX).orElse(65535);
        if (biomePaletteData.isPresent()) {
            BimapPalette<BiomeType> bimap = new BimapPalette<BiomeType>(PaletteTypes.LOCAL_BIOMES, biome_max != 4095 ? palette_max : 64);
            biomePalette = bimap;
            DataView biomeMap = biomePaletteData.get();
            Set<DataQuery> biomeKeys = biomeMap.getKeys(false);
            for (DataQuery biomeKey : biomeKeys) {
                BiomeType biome = Sponge.getRegistry().getType(BiomeType.class, biomeKey.getParts().get(0)).get();
                bimap.assign(biome, biomeMap.getInt(biomeKey).get());
            }
        } else {
            biomePalette = GlobalPalette.getBiomePalette();
        }
        SpongeSchematicBuilder builder = new SpongeSchematicBuilder();
        builder.blockPalette((Palette)palette);
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(palette, new Vector3i(-offset[0], -offset[1], -offset[2]), new Vector3i(width, height, length));
        byte[] blockdata = (byte[])updatedView.get(Constants.Sponge.Schematic.BLOCK_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
        int index = 0;
        int i = 0;
        int value = 0;
        int varint_length = 0;
        while (i < blockdata.length) {
            value = 0;
            varint_length = 0;
            while (true) {
                value |= (blockdata[i] & 0x7F) << varint_length++ * 7;
                if (varint_length > 5) {
                    throw new RuntimeException("VarInt too big (probably corrupted data)");
                }
                if ((blockdata[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / (width * length);
            int z = index % (width * length) / width;
            int x = index % (width * length) % width;
            BlockState state = (BlockState)((Object)palette.get(value).get());
            buffer.setBlock(x - offset[0], y - offset[1], z - offset[2], state);
            ++index;
        }
        builder.blocks(buffer);
        updatedView.get(Constants.Sponge.Schematic.BIOME_DATA).ifPresent(biomesObj -> {
            ByteArrayMutableBiomeBuffer biomeBuffer = new ByteArrayMutableBiomeBuffer(biomePalette, new Vector3i(-offset[0], -offset[1], -offset[2]), new Vector3i(width, height, length));
            byte[] biomes = (byte[])biomesObj;
            int biomeIndex = 0;
            int biomeJ = 0;
            int bVal = 0;
            int varIntLength = 0;
            while (biomeJ < biomes.length) {
                bVal = 0;
                varIntLength = 0;
                while (true) {
                    bVal |= (biomes[biomeJ] & 0x7F) << varIntLength++ * 7;
                    if (varIntLength > 5) {
                        throw new RuntimeException("VarInt too big (probably corrupted data)");
                    }
                    if ((biomes[biomeJ] & 0x80) != 128) {
                        ++biomeJ;
                        break;
                    }
                    ++biomeJ;
                }
                int z = biomeIndex % (width * length) / width;
                int x = biomeIndex % (width * length) % width;
                BiomeType type = (BiomeType)((Object)biomePalette.get((BiomeType)bVal).get());
                biomeBuffer.setBiome(x - offset[0], 0, z - offset[2], type);
                ++biomeIndex;
            }
            builder.biomes(biomeBuffer);
        });
        HashMap tiles = Maps.newHashMap();
        updatedView.getViewList(Constants.Sponge.Schematic.BLOCKENTITY_DATA).ifPresent(tileData -> tileData.forEach(tile -> {
            int[] pos = (int[])tile.get(Constants.Sponge.Schematic.BLOCKENTITY_POS).get();
            tile.getString(Constants.Sponge.Schematic.BLOCKENTITY_ID).map(TileEntityTypeRegistryModule.getInstance()::getById).filter(Optional::isPresent).map(Optional::get).ifPresent(type -> {
                DataView upgraded;
                if (needsFixers) {
                    NBTTagCompound tileNbt = NbtTranslator.getInstance().translate((DataView)tile);
                    tileNbt = VANILLA_FIXER.func_188251_a((IFixType)FixTypes.BLOCK_ENTITY, tileNbt, version);
                    upgraded = NbtTranslator.getInstance().translate(tileNbt);
                } else {
                    upgraded = tile;
                }
                TileEntityArchetype archetype = new SpongeTileEntityArchetypeBuilder().state(buffer.getBlock(pos[0] - offset[0], pos[1] - offset[1], pos[2] - offset[2])).tileData(upgraded).tile((TileEntityType)type).build();
                Vector3i position = new Vector3i(pos[0] - offset[0], pos[1] - offset[1], pos[2] - offset[2]);
                tiles.put(position, archetype);
            });
        }));
        builder.tiles(tiles);
        ArrayList entityArchetypes = new ArrayList();
        updatedView.getViewList(Constants.Sponge.Schematic.ENTITIES).map(Collection::stream).ifPresent(stream -> {
            Stream<DataView> viewStream = stream.filter(entity -> entity.contains(Constants.Sponge.Schematic.ENTITIES_POS, Constants.Sponge.Schematic.ENTITIES_ID));
            PairStream.from(viewStream, entity -> entity.getString(Constants.Sponge.Schematic.ENTITIES_ID).map(EntityTypeRegistryModule.getInstance()::getById)).filter((view, entityType) -> entityType.map(Optional::get).isPresent()).filter((view, entityType) -> !Player.class.isAssignableFrom(entityType.map(Optional::get).get().getEntityClass())).map((view, type) -> {
                DataView upgraded;
                if (needsFixers) {
                    NBTTagCompound entityNbt = NbtTranslator.getInstance().translate((DataView)view);
                    entityNbt = VANILLA_FIXER.func_188251_a((IFixType)FixTypes.ENTITY, entityNbt, version);
                    upgraded = NbtTranslator.getInstance().translate(entityNbt);
                } else {
                    upgraded = view;
                }
                return new SpongeEntityArchetypeBuilder().type((EntityType)((Optional)type.get()).get()).entityData(upgraded).build();
            }).forEach(entityArchetypes::add);
        });
        if (!entityArchetypes.isEmpty()) {
            builder.entities((Collection)entityArchetypes);
        }
        if (metadata != null) {
            DataContainer meta = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
            for (DataQuery key : metadata.getKeys(false)) {
                meta.set(key, metadata.get(key).get());
            }
            builder.metadata(meta);
        }
        return builder.build();
    }

    @Override
    public DataContainer translate(Schematic schematic) throws InvalidDataException {
        DataContainer data = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        this.addTo(schematic, (DataView)data);
        return data;
    }

    @Override
    public DataView addTo(Schematic schematic, DataView data) {
        DataQuery paletteQuery;
        int xMin = schematic.getBlockMin().getX();
        int yMin = schematic.getBlockMin().getY();
        int zMin = schematic.getBlockMin().getZ();
        int width = schematic.getBlockSize().getX();
        int height = schematic.getBlockSize().getY();
        int length = schematic.getBlockSize().getZ();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new IllegalArgumentException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        data.set(Constants.Sponge.Schematic.WIDTH, (Object)width);
        data.set(Constants.Sponge.Schematic.HEIGHT, (Object)height);
        data.set(Constants.Sponge.Schematic.LENGTH, (Object)length);
        data.set(Constants.Sponge.Schematic.VERSION, (Object)2);
        data.set(Constants.Sponge.Schematic.DATA_VERSION, (Object)1343);
        for (DataQuery metaKey : schematic.getMetadata().getKeys(false)) {
            data.set(Constants.Sponge.Schematic.METADATA.then(metaKey), schematic.getMetadata().get(metaKey).get());
        }
        HashSet<String> requiredMods = new HashSet<String>();
        int[] offset = new int[]{-xMin, -yMin, -zMin};
        data.set(Constants.Sponge.Schematic.OFFSET, offset);
        BlockPalette palette = schematic.getPalette();
        try (ByteArrayOutputStream buffer2 = new ByteArrayOutputStream(width * height * length);){
            for (int y = 0; y < height; ++y) {
                int y0 = yMin + y;
                for (int z = 0; z < length; ++z) {
                    int z0 = zMin + z;
                    for (int x = 0; x < width; ++x) {
                        int x0 = xMin + x;
                        BlockState state = schematic.getBlock(x0, y0, z0);
                        this.writeIdToBuffer(buffer2, palette.getOrAssign(state));
                    }
                }
            }
            data.set(Constants.Sponge.Schematic.BLOCK_DATA, buffer2.toByteArray());
        }
        catch (IOException buffer2) {
            // empty catch block
        }
        Palette<BiomeType> biomePalette = schematic.getBiomePalette();
        schematic.getBiomes().ifPresent(biomes -> {
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * length);){
                for (int z = 0; z < length; ++z) {
                    int z0 = zMin + z;
                    for (int x = 0; x < width; ++x) {
                        int x0 = xMin + x;
                        BiomeType state = biomes.getBiome(x0, 0, z0);
                        this.writeIdToBuffer(buffer, biomePalette.getOrAssign(state));
                    }
                }
                data.set(Constants.Sponge.Schematic.BLOCK_DATA, buffer.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        if (palette.getType() == PaletteTypes.LOCAL_BLOCKS) {
            paletteQuery = Constants.Sponge.Schematic.PALETTE;
            for (BlockState state : palette.getEntries()) {
                data.set(paletteQuery.then(state.getId()), (Object)palette.getOrAssign(state));
                String modId = state.getType().getId().split(":")[0];
                if ("minecraft".equals(modId) || modId == null || modId.isEmpty()) continue;
                requiredMods.add(modId);
            }
            data.set(Constants.Sponge.Schematic.PALETTE_MAX, (Object)palette.getHighestId());
        }
        if (biomePalette.getType() == PaletteTypes.LOCAL_BIOMES) {
            paletteQuery = Constants.Sponge.Schematic.BIOME_PALETTE;
            for (BiomeType biomeType : biomePalette.getEntries()) {
                data.set(paletteQuery.then(biomeType.getId()), (Object)biomePalette.getOrAssign(biomeType));
                String modId = biomeType.getId().split(":")[0];
                if ("minecraft".equals(modId) || modId == null || modId.isEmpty()) continue;
                requiredMods.add(modId);
            }
            data.set(Constants.Sponge.Schematic.BIOME_PALETTE_MAX, (Object)biomePalette.getHighestId());
        }
        ArrayList tileEntities = Lists.newArrayList();
        for (Map.Entry<Vector3i, TileEntityArchetype> entry : schematic.getTileEntityArchetypes().entrySet()) {
            Vector3i pos = entry.getKey();
            DataContainer tiledata = entry.getValue().getTileData();
            int[] apos = new int[]{pos.getX() - xMin, pos.getY() - yMin, pos.getZ() - zMin};
            tiledata.set(Constants.Sponge.Schematic.BLOCKENTITY_POS, (Object)apos);
            SpongeTileEntityType tileEntityType = (SpongeTileEntityType)entry.getValue().getTileEntityType();
            String modId = tileEntityType.getId().split(":")[0];
            if ("minecraft".equalsIgnoreCase(modId) && !"minecraft".equalsIgnoreCase(tileEntityType.getModId()) && !"sponge".equalsIgnoreCase(tileEntityType.getModId())) {
                requiredMods.add(modId);
            }
            if (!"minecraft".equalsIgnoreCase(modId) && modId != null && !modId.isEmpty()) {
                requiredMods.add(modId);
            }
            tileEntities.add(tiledata);
        }
        data.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, tileEntities);
        ArrayList entities = Lists.newArrayList();
        for (EntityArchetype entityArchetype : schematic.getEntityArchetypes()) {
            DataContainer entityData = entityArchetype.getEntityData();
            entities.add(entityData);
            SpongeEntityType type = (SpongeEntityType)entityArchetype.getType();
            String modId = type.getId().split(":")[0];
            if ("minecraft".equalsIgnoreCase(modId) && !"minecraft".equalsIgnoreCase(type.getModId()) && !"sponge".equalsIgnoreCase(type.getModId())) {
                requiredMods.add(modId);
            }
            if ("minecraft".equals(modId) || modId == null || modId.isEmpty()) continue;
            requiredMods.add(modId);
        }
        data.set(Constants.Sponge.Schematic.ENTITIES, entities);
        if (!requiredMods.isEmpty()) {
            data.set(Constants.Sponge.Schematic.METADATA.then(Constants.Sponge.Schematic.REQUIRED_MODS), requiredMods);
        }
        return data;
    }

    private void writeIdToBuffer(ByteArrayOutputStream buffer, int orAssign) {
        int id = orAssign;
        while ((id & 0xFFFFFF80) != 0) {
            buffer.write(id & 0x7F | 0x80);
            id >>>= 7;
        }
        buffer.write(id);
    }
}

