/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.explosive.FusedExplosive;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;
import org.spongepowered.common.bridge.world.TeleporterBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldProviderBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.event.tracking.phase.entity.InvokingTeleporterContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseAccessor;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.world.WorldManager;

public final class EntityUtil {
    public static final Function<PhaseContext<?>, Supplier<Optional<User>>> ENTITY_CREATOR_FUNCTION = context -> () -> Stream.builder().add(() -> context.getSource(User.class)).add(context::getNotifier).add(context::getOwner).build().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    private static final Predicate<net.minecraft.entity.Entity> TRACEABLE = Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L());

    private EntityUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static net.minecraft.entity.Entity transferEntityToWorld(net.minecraft.entity.Entity entity, @Nullable MoveEntityEvent.Teleport event, @Nullable WorldServer toWorld, @Nullable ForgeITeleporterBridge teleporter, boolean recreate) {
        net.minecraft.entity.Entity toReturn;
        Transform<World> toTransform;
        boolean loadChunks;
        WorldServer fromWorld;
        Entity sEntity;
        block82: {
            if (entity.field_70170_p.field_72995_K) return null;
            if (entity.field_70128_L) {
                return null;
            }
            sEntity = (Entity)entity;
            EntityBridge mEntity = (EntityBridge)entity;
            Transform<World> fromTransform = sEntity.getTransform();
            fromWorld = (WorldServer)fromTransform.getExtent();
            fromWorld.field_72984_F.func_76320_a("changeDimension");
            loadChunks = true;
            if (event == null) {
                if (toWorld == null) return null;
                if (teleporter == null) {
                    return null;
                }
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                     InvokingTeleporterContext context = EntityUtil.createInvokingTeleporterPhase(entity, toWorld, teleporter);){
                    if (!context.getDidPort()) {
                        net.minecraft.entity.Entity entity2 = entity;
                        return entity2;
                    }
                    frame.pushCause(context.getTeleporter());
                    frame.pushCause(entity);
                    frame.addContext(EventContextKeys.TELEPORT_TYPE, TeleportTypes.PORTAL);
                    event = SpongeEventFactory.createMoveEntityEventTeleportPortal(frame.getCurrentCause(), fromTransform, context.getExitTransform(), context.getTeleporter(), sEntity, true, true);
                    if (SpongeImpl.postEvent(event)) {
                        Vector3i chunkPosition;
                        if (event.getFromTransform().getExtent() != sEntity.getTransform().getExtent()) {
                            if (teleporter instanceof TeleporterBridge) {
                                chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                                ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                            }
                            context.getCapturedBlockSupplier().restoreOriginals();
                            mEntity.bridge$setLocationAndAngles(fromTransform);
                        }
                        chunkPosition = null;
                        return chunkPosition;
                    }
                    toTransform = event.getToTransform();
                    toWorld = (WorldServer)toTransform.getExtent();
                    if (context.getExitTransform().getExtent() != toTransform.getExtent()) {
                        Vector3i chunkPosition;
                        event.setCancelled(true);
                        if (teleporter instanceof TeleporterBridge) {
                            chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                            ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        }
                        context.getCapturedBlockSupplier().restoreOriginals();
                        mEntity.bridge$setLocationAndAngles(toTransform);
                        chunkPosition = null;
                        return chunkPosition;
                    }
                    if (!((MoveEntityEvent.Teleport.Portal)event).getUsePortalAgent()) {
                        if (teleporter instanceof TeleporterBridge) {
                            Vector3i chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                            ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        }
                        context.getCapturedBlockSupplier().restoreOriginals();
                    } else if (teleporter instanceof TeleporterBridge && !context.getCapturedBlockSupplier().isEmpty() && !TrackingUtil.processBlockCaptures(context)) {
                        Vector3i chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                        ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        net.minecraft.entity.Entity entity3 = null;
                        return entity3;
                    }
                    loadChunks = false;
                    break block82;
                }
            }
            if (event.isCancelled()) {
                return null;
            }
            toTransform = event.getToTransform();
            toWorld = (WorldServer)toTransform.getExtent();
        }
        fromWorld.field_72984_F.func_76318_c("reloading");
        if (recreate) {
            toReturn = EntityList.func_191304_a(entity.getClass(), (net.minecraft.world.World)toWorld);
            sEntity = (Entity)toReturn;
            if (toReturn == null) {
                return entity;
            }
            ((EntityAccessor)toReturn).accessor$CopyDataFromOldEntity(entity);
        } else {
            toReturn = entity;
        }
        if (!event.getKeepsVelocity()) {
            toReturn.field_70159_w = 0.0;
            toReturn.field_70181_x = 0.0;
            toReturn.field_70179_y = 0.0;
        }
        if (loadChunks) {
            Vector3i toChunkPosition = toTransform.getLocation().getChunkPosition();
            toWorld.func_72863_F().func_186028_c(toChunkPosition.getX(), toChunkPosition.getZ());
        }
        fromWorld.field_72984_F.func_76320_a("moving");
        ((EntityBridge)toReturn).bridge$setLocationAndAngles(toTransform);
        fromWorld.field_72984_F.func_76319_b();
        try (Object ignored = EntityPhase.State.CHANGING_DIMENSION.createPhaseContext().setTargetWorld(toWorld).buildAndSwitch();){
            if (recreate) {
                boolean flag = toReturn.field_98038_p;
                toReturn.field_98038_p = true;
                toWorld.func_72838_d(toReturn);
                toReturn.field_98038_p = flag;
                toWorld.func_72866_a(toReturn, false);
            } else {
                toWorld.func_72838_d(toReturn);
                toWorld.func_72866_a(toReturn, false);
            }
        }
        if (toReturn instanceof EntityMinecartTNT && ((FusedExplosive)sEntity).isPrimed()) {
            toReturn.field_70170_p.func_72960_a(toReturn, (byte)10);
        }
        entity.field_70128_L = true;
        fromWorld.field_72984_F.func_76319_b();
        fromWorld.func_82742_i();
        toWorld.func_82742_i();
        fromWorld.field_72984_F.func_76319_b();
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static EntityPlayerMP transferPlayerToWorld(EntityPlayerMP player, @Nullable MoveEntityEvent.Teleport event, @Nullable WorldServer toWorld, @Nullable ForgeITeleporterBridge teleporter) {
        int dimensionId;
        Transform<World> toTransform;
        WorldServer fromWorld;
        PlayerList playerList;
        block85: {
            if (player.field_70170_p.field_72995_K) return null;
            if (player.field_70128_L) {
                return null;
            }
            playerList = SpongeImpl.getServer().func_184103_al();
            Player sPlayer = (Player)player;
            Transform<World> fromTransform = sPlayer.getTransform();
            fromWorld = (WorldServer)fromTransform.getExtent();
            fromWorld.field_72984_F.func_76320_a("changeDimension");
            if (event == null) {
                if (toWorld == null) return null;
                if (teleporter == null) {
                    return null;
                }
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                     InvokingTeleporterContext context = EntityUtil.createInvokingTeleporterPhase((net.minecraft.entity.Entity)player, toWorld, teleporter);){
                    if (!context.getDidPort()) {
                        EntityPlayerMP entityPlayerMP = null;
                        return entityPlayerMP;
                    }
                    frame.pushCause(context.getTeleporter());
                    frame.pushCause(player);
                    frame.addContext(EventContextKeys.TELEPORT_TYPE, TeleportTypes.PORTAL);
                    event = SpongeEventFactory.createMoveEntityEventTeleportPortal(frame.getCurrentCause(), fromTransform, context.getExitTransform(), context.getTeleporter(), sPlayer, true, true);
                    if (SpongeImpl.postEvent(event)) {
                        Vector3i chunkPosition;
                        if (event.getFromTransform().getExtent() != sPlayer.getTransform().getExtent()) {
                            if (teleporter instanceof TeleporterBridge) {
                                chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                                ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                            }
                            context.getCapturedBlockSupplier().restoreOriginals();
                            ((EntityBridge)player).bridge$setLocationAndAngles(fromTransform);
                        }
                        chunkPosition = null;
                        return chunkPosition;
                    }
                    toTransform = event.getToTransform();
                    toWorld = (WorldServer)toTransform.getExtent();
                    if (context.getExitTransform().getExtent() != toTransform.getExtent()) {
                        Vector3i chunkPosition;
                        event.setCancelled(true);
                        if (teleporter instanceof TeleporterBridge) {
                            chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                            ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        }
                        context.getCapturedBlockSupplier().restoreOriginals();
                        ((EntityBridge)player).bridge$setLocationAndAngles(toTransform);
                        chunkPosition = null;
                        return chunkPosition;
                    }
                    if (!((MoveEntityEvent.Teleport.Portal)event).getUsePortalAgent()) {
                        Vector3i chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                        if (teleporter instanceof TeleporterBridge) {
                            ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        }
                        context.getCapturedBlockSupplier().restoreOriginals();
                        break block85;
                    } else if (teleporter instanceof TeleporterBridge && !context.getCapturedBlockSupplier().isEmpty() && !TrackingUtil.processBlockCaptures(context)) {
                        Vector3i chunkPosition = context.getExitTransform().getLocation().getChunkPosition();
                        ((TeleporterBridge)teleporter).bridge$removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                        EntityPlayerMP entityPlayerMP = null;
                        return entityPlayerMP;
                    }
                    break block85;
                }
            }
            if (event.isCancelled()) {
                return null;
            }
            toTransform = event.getToTransform();
            toWorld = (WorldServer)toTransform.getExtent();
        }
        if (!((EntityPlayerMPBridge)player).bridge$usesCustomClient()) {
            int toClientDimId;
            int fromClientDimId = WorldManager.getClientDimensionId(player, (net.minecraft.world.World)fromWorld);
            if (fromClientDimId == (toClientDimId = WorldManager.getClientDimensionId(player, (net.minecraft.world.World)toWorld))) {
                int fakeDimId;
                switch (fromClientDimId) {
                    case 1: {
                        fakeDimId = -1;
                        break;
                    }
                    case 0: {
                        fakeDimId = 1;
                        break;
                    }
                    default: {
                        fakeDimId = 0;
                    }
                }
                player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(fakeDimId, toWorld.func_175659_aa(), toWorld.func_175624_G(), player.field_71134_c.func_73081_b()));
            }
            dimensionId = toClientDimId;
        } else {
            WorldManager.sendDimensionRegistration(player, toWorld.field_73011_w);
            dimensionId = ((WorldServerBridge)toWorld).bridge$getDimensionId();
        }
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId, toWorld.func_175659_aa(), toWorld.func_175624_G(), player.field_71134_c.func_73081_b()));
        player.field_71093_bK = ((WorldServerBridge)toWorld).bridge$getDimensionId();
        player.func_70029_a((net.minecraft.world.World)toWorld);
        playerList.func_187243_f(player);
        fromWorld.func_72973_f((net.minecraft.entity.Entity)player);
        player.field_70128_L = false;
        Vector3d position = toTransform.getPosition();
        player.func_70012_b(position.getX(), position.getY(), position.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
        Object ignored = EntityPhase.State.CHANGING_DIMENSION.createPhaseContext().setTargetWorld(toWorld).buildAndSwitch();
        Object fakeDimId = null;
        try {
            toWorld.func_72838_d((net.minecraft.entity.Entity)player);
            toWorld.func_72866_a((net.minecraft.entity.Entity)player, false);
        }
        catch (Throwable chunkPosition) {
            fakeDimId = chunkPosition;
            throw chunkPosition;
        }
        finally {
            if (ignored != null) {
                if (fakeDimId != null) {
                    try {
                        ((PhaseContext)ignored).close();
                    }
                    catch (Throwable chunkPosition) {
                        ((Throwable)fakeDimId).addSuppressed(chunkPosition);
                    }
                } else {
                    ((PhaseContext)ignored).close();
                }
            }
        }
        fromWorld.func_184164_w().func_72695_c(player);
        toWorld.func_184164_w().func_72683_a(player);
        Vector3i toChunkPosition = toTransform.getLocation().getChunkPosition();
        toWorld.func_72863_F().func_186025_d(toChunkPosition.getX(), toChunkPosition.getZ());
        if (event instanceof MoveEntityEvent.Teleport.Portal) {
            CriteriaTriggers.field_193134_u.func_193143_a(player, fromWorld.field_73011_w.func_186058_p(), toWorld.field_73011_w.func_186058_p());
            if (fromWorld.field_73011_w.func_186058_p() == DimensionType.NETHER && toWorld.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && player.func_193106_Q() != null) {
                CriteriaTriggers.field_193131_B.func_193168_a(player, player.func_193106_Q());
            }
        }
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(toWorld);
        playerList.func_72354_b(player, toWorld);
        playerList.func_72385_f(player);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        AttributeMap attributemap = (AttributeMap)player.func_110140_aT();
        Collection watchedAttribs = attributemap.func_111160_c();
        if (!watchedAttribs.isEmpty()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), watchedAttribs));
        }
        player.field_71135_a.func_147359_a((Packet)new SPacketServerDifficulty(toWorld.func_175659_aa(), toWorld.func_72912_H().func_176123_z()));
        player.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((net.minecraft.entity.Entity)player, toWorld.func_82736_K().func_82766_b("reducedDebugInfo") ? (byte)22 : 23));
        if (!event.getKeepsVelocity()) {
            player.field_70159_w = 0.0;
            player.field_70181_x = 0.0;
            player.field_70179_y = 0.0;
        }
        SpongeImplHooks.handlePostChangeDimensionEvent(player, fromWorld, toWorld);
        return player;
    }

    private static InvokingTeleporterContext createInvokingTeleporterPhase(net.minecraft.entity.Entity entity, WorldServer toWorld, ForgeITeleporterBridge teleporter) {
        SpongeImplHooks.registerPortalAgentType(teleporter);
        MinecraftServer mcServer = SpongeImpl.getServer();
        Entity sEntity = (Entity)entity;
        Transform<World> fromTransform = sEntity.getTransform();
        WorldServer fromWorld = (WorldServer)entity.field_70170_p;
        int toDimensionId = ((WorldServerBridge)toWorld).bridge$getDimensionId();
        if (toDimensionId == 1 && fromWorld.field_73011_w instanceof WorldProviderEnd) {
            toDimensionId = 0;
        }
        toWorld = mcServer.func_71218_a(toDimensionId);
        Map<String, String> portalAgents = ((WorldInfoBridge)fromWorld.func_72912_H()).bridge$getConfigAdapter().getConfig().getWorld().getPortalAgents();
        String worldName = teleporter.getClass().getName().equals("net.minecraft.world.Teleporter") ? portalAgents.get("minecraft:default_" + toWorld.field_73011_w.func_186058_p().func_186065_b().toLowerCase(Locale.ENGLISH)) : portalAgents.get("minecraft:" + teleporter.getClass().getSimpleName());
        if (worldName != null) {
            for (WorldProperties properties : Sponge.getServer().getAllWorldProperties()) {
                Optional<World> spongeWorld;
                if (!properties.getWorldName().equalsIgnoreCase(worldName) || !(spongeWorld = Sponge.getServer().loadWorld(properties)).isPresent() || !((teleporter = (ForgeITeleporterBridge)(toWorld = (WorldServer)spongeWorld.get()).func_85176_s()) instanceof TeleporterBridge) || fromWorld.field_73011_w.func_177495_o() || toWorld.field_73011_w.func_177495_o()) continue;
                ((TeleporterBridge)teleporter).bridge$setNetherPortalType(false);
            }
        }
        fromWorld.field_72984_F.func_76320_a("reposition");
        Transform<World> toTransform = EntityUtil.getPortalExitTransform(entity, fromWorld, toWorld);
        fromWorld.field_72984_F.func_76319_b();
        InvokingTeleporterContext context = (InvokingTeleporterContext)EntityPhase.State.INVOKING_TELEPORTER.createPhaseContext().setTargetWorld(toWorld).setTeleporter((PortalAgent)((Object)teleporter)).setExitTransform(toTransform).buildAndSwitch();
        if (!(fromWorld.field_73011_w instanceof WorldProviderEnd)) {
            if (!teleporter.bridge$isVanilla() || entity.func_181014_aG() != null || toWorld.field_73011_w instanceof WorldProviderEnd) {
                Vector3d position = toTransform.getPosition();
                entity.func_70012_b(position.getX(), position.getY(), position.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
                fromWorld.field_72984_F.func_76320_a("placing");
                if (!teleporter.bridge$isVanilla() || toWorld.field_73011_w instanceof WorldProviderEnd) {
                    context.setDidPort(true);
                }
                teleporter.bridge$placeEntity((net.minecraft.world.World)toWorld, entity, (float)fromTransform.getRotation().getY());
                fromWorld.field_72984_F.func_76319_b();
                context.setExitTransform(sEntity.getTransform().setExtent((World)toWorld));
                position = fromTransform.getPosition();
                entity.func_70012_b(position.getX(), position.getY(), position.getZ(), (float)fromTransform.getYaw(), (float)fromTransform.getPitch());
            }
        } else {
            context.setDidPort(true);
        }
        return context;
    }

    private static Transform<World> getPortalExitTransform(net.minecraft.entity.Entity entity, WorldServer fromWorld, WorldServer toWorld) {
        double z;
        double y;
        double x;
        WorldProvider fromWorldProvider = fromWorld.field_73011_w;
        WorldProvider toWorldProvider = toWorld.field_73011_w;
        if (toWorldProvider instanceof WorldProviderEnd) {
            BlockPos coordinate = toWorld.func_180504_m();
            x = coordinate.func_177958_n();
            y = coordinate.func_177956_o();
            z = coordinate.func_177952_p();
        } else if (fromWorldProvider instanceof WorldProviderEnd && toWorldProvider instanceof WorldProviderSurface) {
            BlockPos coordinate = toWorld.func_175694_M();
            x = coordinate.func_177958_n();
            y = coordinate.func_177956_o();
            z = coordinate.func_177952_p();
        } else {
            double moveFactor = ((WorldProviderBridge)fromWorldProvider).bridge$getMovementFactor() / ((WorldProviderBridge)toWorldProvider).bridge$getMovementFactor();
            x = MathHelper.func_151237_a((double)(entity.field_70165_t * moveFactor), (double)(toWorld.func_175723_af().func_177726_b() + 16.0), (double)(toWorld.func_175723_af().func_177728_d() - 16.0));
            y = entity.field_70163_u;
            z = MathHelper.func_151237_a((double)(entity.field_70161_v * moveFactor), (double)(toWorld.func_175723_af().func_177736_c() + 16.0), (double)(toWorld.func_175723_af().func_177733_e() - 16.0));
            entity.field_70177_z = 90.0f;
            entity.field_70125_A = 0.0f;
            x = MathHelper.func_76125_a((int)((int)x), (int)-29999872, (int)29999872);
            z = MathHelper.func_76125_a((int)((int)z), (int)-29999872, (int)29999872);
        }
        Transform<World> transform = new Transform<World>((World)toWorld, new Vector3d(x, y, z), new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f));
        return transform;
    }

    public static boolean isEntityDead(net.minecraft.entity.Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)entity;
            return base.func_110143_aJ() <= 0.0f || base.field_70725_aQ > 0 || ((EntityLivingBaseAccessor)entity).accessor$isLivingDead();
        }
        return entity.field_70128_L;
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Location<World> location) {
        Transform<World> fromTransform = ((Entity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setLocation(location).setRotation(new Vector3d(entityIn.field_70125_A, entityIn.field_70177_z, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, double posX, double posY, double posZ, float yaw, float pitch) {
        Transform<World> fromTransform = ((Entity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setPosition(new Vector3d(posX, posY, posZ)).setRotation(new Vector3d(pitch, yaw, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Transform<World> fromTransform, Transform<World> toTransform) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entityIn);
            MoveEntityEvent.Teleport event = SpongeEventFactory.createMoveEntityEventTeleport(Sponge.getCauseStackManager().getCurrentCause(), fromTransform, toTransform, (Entity)entityIn, false);
            SpongeImpl.postEvent(event);
            MoveEntityEvent.Teleport teleport = event;
            return teleport;
        }
    }

    public static boolean processEntitySpawnsFromEvent(SpawnEntityEvent event, Supplier<Optional<User>> entityCreatorSupplier) {
        boolean spawnedAny = false;
        for (Entity entity : event.getEntities()) {
            spawnedAny = EntityUtil.processEntitySpawn(entity, entityCreatorSupplier);
        }
        return spawnedAny;
    }

    public static boolean processEntitySpawnsFromEvent(PhaseContext<?> context, SpawnEntityEvent destruct) {
        return EntityUtil.processEntitySpawnsFromEvent(destruct, ENTITY_CREATOR_FUNCTION.apply(context));
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<User>> supplier) {
        Optional<net.minecraft.entity.Entity> customEntityItem;
        ItemStack item;
        net.minecraft.entity.Entity minecraftEntity = (net.minecraft.entity.Entity)entity;
        if (minecraftEntity instanceof EntityItem && !(item = ((EntityItem)minecraftEntity).func_92059_d()).func_190926_b() && (customEntityItem = Optional.ofNullable(SpongeImplHooks.getCustomEntityIfItem(minecraftEntity))).isPresent()) {
            net.minecraft.entity.Entity entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(spawned -> {
                if (entityToSpawn instanceof OwnershipTrackedBridge) {
                    ((OwnershipTrackedBridge)entityToSpawn).tracked$setOwnerReference((User)spawned);
                }
            });
            if (entityToSpawn.field_70128_L) {
                entityToSpawn.field_70128_L = false;
            }
            ((WorldServerBridge)entityToSpawn.field_70170_p).bridge$forceSpawnEntity(entityToSpawn);
            return true;
        }
        supplier.get().ifPresent(spawned -> {
            if (entity instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)((Object)entity)).tracked$setOwnerReference((User)spawned);
            }
        });
        ((WorldServerBridge)((Object)entity.getWorld())).bridge$forceSpawnEntity((net.minecraft.entity.Entity)entity);
        return true;
    }

    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks, boolean includeEntities) {
        RayTraceResult blockRay = EntityUtil.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.field_72307_f.func_72438_d(traceStart) : traceDistance;
        EntityTrace trace = new EntityTrace(blockDistance);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        AxisAlignedBB boundingBox = source.func_174813_aQ();
        AxisAlignedBB traceBox = boundingBox.func_72321_a(lookDir.field_72450_a, lookDir.field_72448_b, lookDir.field_72449_c);
        List entities = source.field_70170_p.func_175674_a(source, traceBox.func_72314_b(1.0, 1.0, 1.0), TRACEABLE);
        for (net.minecraft.entity.Entity entity : entities) {
            double distanceToEntity;
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult entityRay1 = entityBB.func_72327_a(traceStart, traceEnd);
            if (entityBB.func_72318_a(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay1 == null ? traceStart : entityRay1.field_72307_f;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay1 == null || !((distanceToEntity = traceStart.func_72438_d(entityRay1.field_72307_f)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.func_184208_bv() == source.func_184208_bv()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay1.field_72307_f;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay1.field_72307_f;
            trace.distance = distanceToEntity;
        }
        if (trace.entity != null && (trace.distance < blockDistance || blockRay == null)) {
            return trace.asRayTraceResult();
        }
        return blockRay;
    }

    @Nullable
    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks) {
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        return source.field_70170_p.func_147447_a(traceStart, traceEnd, false, false, true);
    }

    private static Vec3d getPositionEyes(net.minecraft.entity.Entity entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        }
        double interpX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double interpY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)entity.func_70047_e();
        double interpZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        return new Vec3d(interpX, interpY, interpZ);
    }

    @Nullable
    public static EntityItem entityOnDropItem(net.minecraft.entity.Entity entity, ItemStack itemStack, float offsetY, double xPos, double zPos) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        double posX = xPos;
        double posY = entity.field_70163_u + (double)offsetY;
        double posZ = zPos;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        PhaseContext<?> phaseContext = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState currentState = phaseContext.state;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ItemStack item = SpongeCommonEventFactory.throwDropItemAndConstructEvent(entity, posX, posY, posZ, snapshot, original, frame);
            if (item == null || item.func_190926_b()) {
                EntityItem entityItem = null;
                return entityItem;
            }
            EntityItem entityitem = new EntityItem(entity.field_70170_p, posX, posY, posZ, item);
            entityitem.func_174869_p();
            if (currentState.spawnItemOrCapture(phaseContext, entity, entityitem)) {
                EntityItem entityItem = entityitem;
                return entityItem;
            }
            EntityUtil.processEntitySpawn((Entity)entityitem, Optional::empty);
            EntityItem entityItem = entityitem;
            return entityItem;
        }
    }

    private static Vector3d createDropMotion(boolean dropAround, EntityPlayer player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -MathHelper.func_76126_a((float)f1) * f;
            z = MathHelper.func_76134_b((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            z = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            y = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    public static Optional<EntityType> fromNameToType(String name) {
        Class<? extends net.minecraft.entity.Entity> clazz = SpongeImplHooks.getEntityClass(new ResourceLocation(name));
        if (clazz == null) {
            return Optional.empty();
        }
        return Optional.of(EntityTypeRegistryModule.getInstance().getForClass((Class)clazz));
    }

    public static Optional<EntityType> fromLocationToType(ResourceLocation location) {
        Class<? extends net.minecraft.entity.Entity> clazz = SpongeImplHooks.getEntityClass(location);
        if (clazz == null) {
            return Optional.empty();
        }
        return Optional.of(EntityTypeRegistryModule.getInstance().getForClass((Class)clazz));
    }

    public static boolean isUntargetable(net.minecraft.entity.Entity from, net.minecraft.entity.Entity target) {
        if (((VanishableBridge)target).bridge$isVanished() && ((VanishableBridge)target).bridge$isUntargetable()) {
            return true;
        }
        return from.field_70170_p != target.field_70170_p;
    }

    static final class EntityTrace {
        net.minecraft.entity.Entity entity;
        Vec3d location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        RayTraceResult asRayTraceResult() {
            return new RayTraceResult(this.entity, this.location);
        }
    }
}

