/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.EntityDeathContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityDropPhaseState;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;

final class EntityDeathState
extends EntityPhaseState<EntityDeathContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityDeathContext> DEATH_STATE_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        Entity dyingEntity = ctx.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", ctx));
        DamageSource damageSource = ctx.getDamageSource();
        frame.pushCause(dyingEntity);
        frame.pushCause(damageSource);
    });

    EntityDeathState() {
    }

    @Override
    public boolean tracksBlockSpecificDrops(EntityDeathContext context) {
        return true;
    }

    @Override
    public boolean tracksEntityDeaths() {
        return true;
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityDeathContext> getFrameModifier() {
        return this.DEATH_STATE_MODIFIER;
    }

    @Override
    public EntityDeathContext createNewContext() {
        return (EntityDeathContext)((EntityDeathContext)new EntityDeathContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(EntityDeathContext context) {
        Entity dyingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        boolean isPlayer = dyingEntity instanceof EntityPlayer;
        EntityPlayer entityPlayer = isPlayer ? (EntityPlayer)dyingEntity : null;
        boolean hasCaptures = !context.getPerEntityItemEntityDropSupplier().isEmpty();
        context.getPerEntityItemEntityDropSupplier().acceptAndRemoveIfPresent(dyingEntity.getUniqueId(), items -> {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (EntityItem item : items) {
                entities.add((Entity)item);
            }
            if (isPlayer) {
                entityPlayer.field_71071_by.func_174888_l();
            }
            try (CauseStackManager.StackFrame internal = Sponge.getCauseStackManager().pushCauseFrame();){
                internal.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                SpongeCommonEventFactory.callDropItemDestruct(entities, context);
            }
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> this.standardSpawnCapturedEntities(context, (List<? extends Entity>)entities));
        if (!hasCaptures) {
            ArrayList<Entity> entities2 = new ArrayList<Entity>();
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            boolean keepInventoryRule = false;
            if (entityPlayer != null && ((EntityPlayerBridge)entityPlayer).bridge$keepInventory()) {
                keepInventoryRule = entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory");
                entityPlayer.field_70170_p.func_82736_K().func_82764_b("keepInventory", "true");
            }
            SpongeCommonEventFactory.callDropItemDestruct(entities2, context);
            if (entityPlayer != null && ((EntityPlayerBridge)entityPlayer).bridge$keepInventory()) {
                entityPlayer.field_70170_p.func_82736_K().func_82764_b("keepInventory", String.valueOf(keepInventoryRule));
            }
        }
        EntityDropPhaseState.processPerItemDrop(context, dyingEntity, isPlayer, entityPlayer);
        TrackingUtil.processBlockCaptures(context);
    }
}

