/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.Packet;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class CloseWindowState
extends BasicPacketState {
    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        context.openContainer(playerMP.field_71070_bA);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getSource(EntityPlayerMP.class).get();
        Container container = context.getOpenContainer();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        if (lastCursor != null) {
            Sponge.getCauseStackManager().pushCause(player);
            InteractInventoryEvent.Close event = SpongeCommonEventFactory.callInteractInventoryCloseEvent(container, player, lastCursor, newCursor, true);
            if (event.isCancelled()) {
                Sponge.getCauseStackManager().popCause();
                return;
            }
            Sponge.getCauseStackManager().popCause();
        }
        if (context.getCapturedItemsSupplier().isEmpty() && context.getCapturedItemStackSupplier().isEmpty() && context.getCapturedBlockSupplier().isEmpty()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                List<Entity> entities = items.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    SpongeCommonEventFactory.callDropItemClose(entities, context, () -> Optional.of((Player)player));
                }
            });
            context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(stacks -> {
                List items = stacks.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                List<Entity> entities = items.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    SpongeCommonEventFactory.callDropItemCustom(entities, context, () -> Optional.of((Player)player));
                }
            });
        }
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public boolean doesCaptureEntityDrops(BasicPacketContext context) {
        return true;
    }
}

