/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.block.BlockEventDataBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = IPhaseState.DEFAULT_OWNER_NOTIFIER.andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().getWorld());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        CPacketPlayerTryUseItemOnBlock placeBlock = (CPacketPlayerTryUseItemOnBlock)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.func_184586_b(placeBlock.func_187022_c());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.func_187022_c();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, BasicPacketContext context) {
        TrackingUtil.associateTrackerToTarget(blockChange, transaction, (Player)context.getPacketPlayer());
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, PhaseContext<?> currentContext, WorldServerBridge mixinWorldServer, BlockPos pos, BlockEventDataBridge blockEvent) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        BlockState state = ((World)((Object)mixinWorldServer)).getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((World)((Object)mixinWorldServer)).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state(state).build();
        blockEvent.bridge$setTickingLocatable(locatable);
        blockEvent.bridge$setSourceUser(player);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        ItemStack itemStack = context.getItemUsed();
        SpongeItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                SpongeCommonEventFactory.callSpawnEntity(entities, context);
            }
        });
        EnumHand hand = (EnumHand)context.getHandUsed();
        net.minecraft.item.ItemStack replaced = player.func_184586_b(hand);
        player.func_184611_a(hand, ItemStackUtil.toNative(itemStack.copy()));
        if (!TrackingUtil.processBlockCaptures(context) && !snapshot.isNone()) {
            PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), hand);
        } else {
            player.func_184611_a(hand, replaced);
        }
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<Entity> entities = drops.stream().map(drop -> drop.create(player.func_71121_q())).map(entity -> (Entity)entity).collect(Collectors.toList());
            if (!entities.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                    SpongeCommonEventFactory.callDropItemCustom(entities, context, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
                }
            }
        });
        TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.field_71070_bA;
        trackedInventory.bridge$setCaptureInventory(false);
        trackedInventory.bridge$getCapturedSlotTransactions().clear();
    }

    @Override
    public SpawnType getEntitySpawnType(BasicPacketContext context) {
        if (context.getItemUsed().getType().equals(ItemTypes.SPAWN_EGG)) {
            return SpawnTypes.SPAWN_EGG;
        }
        return SpawnTypes.PLACEMENT;
    }
}

