/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.entity.Entity;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;

public class EntityTickContext
extends TickContext<EntityTickContext> {
    double posX;
    double posY;
    double posZ;
    public double prevX;
    public double prevY;
    public double prevZ;

    EntityTickContext(IPhaseState<? extends EntityTickContext> phaseState) {
        super(phaseState);
    }

    @Override
    public EntityTickContext source(Object owner) {
        super.source(owner);
        if (owner instanceof TrackableBridge) {
            TrackableBridge mixinEntity = (TrackableBridge)owner;
            this.setBulkBlockCaptures(mixinEntity.bridge$allowsBlockBulkCapture());
            this.setBlockEvents(mixinEntity.bridge$allowsBlockEventCreation());
            this.setBulkEntityCaptures(mixinEntity.bridge$allowsEntityBulkCapture());
            this.setEntitySpawnEvents(mixinEntity.bridge$allowsEntityEventCreation());
        }
        this.populateEntityPosition((Entity)owner);
        return (EntityTickContext)super.source(owner);
    }

    @Override
    protected void reset() {
        super.reset();
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
        this.prevX = 0.0;
        this.prevY = 0.0;
        this.prevZ = 0.0;
    }

    public void populateEntityPosition(Entity entity) {
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
        this.prevX = entity.field_70142_S;
        this.prevY = entity.field_70137_T;
        this.prevZ = entity.field_70136_U;
    }
}

