/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.VersionNumber;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.launch.transformer.SpongeSuperclassRegistry;
import org.spongepowered.common.mixin.handler.TerminateVM;
import org.spongepowered.common.util.PathTokens;

public class SpongeLaunch {
    public static final String SUPERCLASS_TRANSFORMER = "org.spongepowered.common.launch.transformer.SpongeSuperclassTransformer";
    private static Path gameDir;
    private static Path pluginsDir;
    private static Path additionalPluginsDir;
    private static Path configDir;
    private static Path spongeConfigDir;
    private static Path pluginConfigDir;

    private SpongeLaunch() {
    }

    public static Path getGameDir() {
        return gameDir;
    }

    public static Path getPluginsDir() {
        return pluginsDir;
    }

    public static Path getAdditionalPluginsDir() {
        if (additionalPluginsDir == null) {
            additionalPluginsDir = Paths.get(PathTokens.replace(SpongeImpl.getGlobalConfigAdapter().getConfig().getGeneral().pluginsDir()), new String[0]);
        }
        return additionalPluginsDir;
    }

    public static Path getConfigDir() {
        return configDir;
    }

    public static Path getPluginConfigDir() {
        if (pluginConfigDir == null) {
            pluginConfigDir = Paths.get(PathTokens.replace(SpongeImpl.getGlobalConfigAdapter().getConfig().getGeneral().configDir()), new String[0]);
        }
        return pluginConfigDir;
    }

    public static Path getSpongeConfigDir() {
        return spongeConfigDir;
    }

    public static void initPaths(File gameDirIn) {
        gameDir = gameDirIn.toPath();
        pluginsDir = gameDir.resolve("mods");
        configDir = gameDir.resolve("config");
        spongeConfigDir = configDir.resolve("sponge");
    }

    public static void addJreExtensionsToClassPath() {
        Launch.classLoader.addClassLoaderExclusion("jdk.");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return;
        }
        if ((classLoader = classLoader.getParent()) instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                Launch.classLoader.addURL(url);
            }
        }
    }

    public static void setupMixinEnvironment() {
        MixinBootstrap.init();
        Mixins.addConfiguration("mixins.common.api.json");
        Mixins.addConfiguration("mixins.common.bungeecord.json");
        Mixins.addConfiguration("mixins.common.concurrentchecks.json");
        Mixins.addConfiguration("mixins.common.core.json");
        Mixins.addConfiguration("mixins.common.entityactivation.json");
        Mixins.addConfiguration("mixins.common.entitycollisions.json");
        Mixins.addConfiguration("mixins.common.exploit.json");
        Mixins.addConfiguration("mixins.common.movementchecks.json");
        Mixins.addConfiguration("mixins.common.multi-world-command.json");
        Mixins.addConfiguration("mixins.common.optimization.json");
        Mixins.addConfiguration("mixins.common.realtime.json");
        Mixins.addConfiguration("mixins.common.tileentityactivation.json");
        Mixins.addConfiguration("mixins.common.tracking.json");
        Mixins.addConfiguration("mixins.common.vanilla-command.json");
        VersionNumber environment = VersionNumber.parse(MixinEnvironment.getCurrentEnvironment().getVersion());
        VersionNumber required = VersionNumber.parse("0.7.11");
        if (required.compareTo(environment) > 0) {
            new PrettyPrinter(60).add("Old Mixin Version Loaded!").centre().hr().add("Hey, sorry, but Sponge requires a newer version of Mixin being loaded, and unfortunately\nwith an older version, nothing will work as it should. Please rename the sponge jar to load\nearlier than other coremods, so that Sponge's Mixin version will be loaded (they're backwards\ncompatible, but not forwards compatible). We're sorry for the inconvenience, but this is all\nthat we can do.").add().add("%s : %s", "Current Loaded Mixin", environment.toString()).add("%s : %s", "Required Mixin Version", required.toString()).log(SpongeImpl.getLogger(), Level.FATAL);
            TerminateVM.terminate("org.spongepowered.core", -1);
        }
    }

    public static void setupSuperClassTransformer() {
        SpongeSuperclassRegistry.registerSuperclassModification("org.spongepowered.api.entity.ai.task.AbstractAITask", "org.spongepowered.common.entity.ai.SpongeEntityAICommonSuperclass");
        SpongeSuperclassRegistry.registerSuperclassModification("org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSource", "org.spongepowered.common.event.damage.SpongeCommonDamageSource");
        SpongeSuperclassRegistry.registerSuperclassModification("org.spongepowered.api.event.cause.entity.damage.source.common.AbstractEntityDamageSource", "org.spongepowered.common.event.damage.SpongeCommonEntityDamageSource");
        SpongeSuperclassRegistry.registerSuperclassModification("org.spongepowered.api.event.cause.entity.damage.source.common.AbstractIndirectEntityDamageSource", "org.spongepowered.common.event.damage.SpongeCommonIndirectEntityDamageSource");
    }
}

