/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={Item.class})
public abstract class ItemMixin_API
implements ItemType {
    @Nullable
    protected BlockType blockType = null;
    @Nullable
    private ItemStack propertyItemStack;

    @Shadow
    public abstract int func_77639_j();

    @Shadow
    public abstract String func_77658_a();

    @Override
    public final String getId() {
        ResourceLocation resourceLocation = SpongeImplHooks.getItemResourceLocation((Item)this);
        Preconditions.checkState((resourceLocation != null ? 1 : 0) != 0, (Object)"Attempted to access the id before the Item is registered.");
        return resourceLocation.toString();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getDefaultProperty(Class<T> propertyClass) {
        if (this.propertyItemStack == null) {
            this.propertyItemStack = ItemStackUtil.fromNative(new net.minecraft.item.ItemStack((Item)this));
        }
        return SpongeImpl.getPropertyRegistry().getStore(propertyClass).flatMap(store -> store.getFor(this.propertyItemStack));
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_77658_a() + ".name");
    }

    @Override
    public int getMaxStackQuantity() {
        return this.func_77639_j();
    }

    @Override
    public Optional<BlockType> getBlock() {
        return Optional.ofNullable(this.blockType);
    }
}

