/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import java.util.List;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import org.spongepowered.api.block.tileentity.MobSpawner;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.data.value.mutable.WeightedCollectionValue;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.tileentity.MobSpawnerBaseLogicBridge;
import org.spongepowered.common.data.manipulator.mutable.SpongeMobSpawnerData;
import org.spongepowered.common.data.processor.common.SpawnerUtils;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeWeightedCollectionValue;
import org.spongepowered.common.mixin.api.mcp.tileentity.TileEntityMixin_API;
import org.spongepowered.common.util.Constants;

@NonnullByDefault
@Mixin(value={TileEntityMobSpawner.class})
public abstract class TileEntityMobSpawnerMixin_API
extends TileEntityMixin_API
implements MobSpawner {
    @Shadow
    public abstract MobSpawnerBaseLogic func_145881_a();

    @Override
    public void spawnEntityBatchImmediately(boolean force) {
        MobSpawnerBaseLogicBridge bridge = (MobSpawnerBaseLogicBridge)this.func_145881_a();
        if (force) {
            short oldMaxNearby = (short)bridge.bridge$getMaxNearbyEntities();
            bridge.bridge$setMaxNearbyEntities(Short.MAX_VALUE);
            bridge.bridge$setSpawnDelay(0);
            this.func_145881_a().func_98278_g();
            bridge.bridge$setMaxNearbyEntities(oldMaxNearby);
        } else {
            bridge.bridge$setSpawnDelay(0);
        }
    }

    @Override
    public MobSpawnerData getMobSpawnerData() {
        MobSpawnerBaseLogicBridge accessor = (MobSpawnerBaseLogicBridge)this.func_145881_a();
        return new SpongeMobSpawnerData((short)accessor.bridge$getSpawnDelay(), (short)accessor.bridge$getMinSpawnDelay(), (short)accessor.bridge$getMaxSpawnDelay(), (short)accessor.bridge$getSpawnCount(), (short)accessor.bridge$getMaxNearbyEntities(), (short)accessor.bridge$getActivatingRangeFromPlayer(), (short)accessor.bridge$getSpawnRange(), SpawnerUtils.getNextEntity(accessor), SpawnerUtils.getEntities(this.func_145881_a()));
    }

    @Override
    public MutableBoundedValue<Short> remainingDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REMAINING_DELAY).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)20).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getSpawnDelay()).build();
    }

    @Override
    public MutableBoundedValue<Short> minimumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MINIMUM_DELAY).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)200).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getMinSpawnDelay()).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_DELAY).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)800).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getMaxSpawnDelay()).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnCount() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_COUNT).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getSpawnCount()).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumNearbyEntities() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)6).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getMaxNearbyEntities()).build();
    }

    @Override
    public MutableBoundedValue<Short> requiredPlayerRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REQUIRED_PLAYER_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)16).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getActivatingRangeFromPlayer()).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue((short)((MobSpawnerBaseLogicBridge)this.func_145881_a()).bridge$getSpawnRange()).build();
    }

    @Override
    public Value<WeightedSerializableObject<EntityArchetype>> nextEntityToSpawn() {
        return new SpongeValue<WeightedSerializableObject<EntityArchetype>>(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, Constants.TileEntity.Spawner.DEFAULT_NEXT_ENTITY_TO_SPAWN, SpawnerUtils.getNextEntity((MobSpawnerBaseLogicBridge)this.func_145881_a()));
    }

    @Override
    public WeightedCollectionValue<EntityArchetype> possibleEntitiesToSpawn() {
        return new SpongeWeightedCollectionValue<EntityArchetype>(Keys.SPAWNER_ENTITIES, SpawnerUtils.getEntities(this.func_145881_a()));
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getMobSpawnerData());
    }
}

