/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.server.management.PlayerChunkMapBridge;
import org.spongepowered.common.bridge.server.management.PlayerChunkMapEntryBridge;
import org.spongepowered.common.bridge.world.ServerWorldEventHandlerBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.effect.sound.SoundEffectHelper;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.generation.ChunkRegenerateContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.mixin.api.mcp.world.WorldMixin_API;
import org.spongepowered.common.util.NonNullArrayList;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin_API
extends WorldMixin_API {
    @Shadow
    @Final
    private MinecraftServer field_73061_a;
    @Shadow
    @Final
    private Set<NextTickListEntry> field_73064_N;
    @Shadow
    @Final
    private TreeSet<NextTickListEntry> field_73065_O;
    @Shadow
    @Final
    private PlayerChunkMap field_73063_M;
    @Shadow
    @Final
    @Mutable
    private Teleporter field_85177_Q;

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity func_175733_a(UUID var1);

    @Shadow
    public abstract PlayerChunkMap func_184164_w();

    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Shadow
    public abstract void func_175654_a(BlockPos var1, Block var2, int var3, int var4);

    @Shadow
    protected abstract boolean func_175680_a(int var1, int var2, boolean var3);

    @Override
    public boolean isLoaded() {
        return WorldManager.isKnownWorld((WorldServer)this);
    }

    @Override
    public Path getDirectory() {
        File worldDirectory = this.field_73019_z.func_75765_b();
        if (worldDirectory == null) {
            new PrettyPrinter(60).add("A Server World has a null save directory!").centre().hr().add("%s : %s", "World Name", this.getName()).add("%s : %s", "Dimension", this.getProperties().getDimensionType()).add("Please report this to sponge developers so they may potentially fix this").trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return null;
        }
        return worldDirectory.toPath();
    }

    @Override
    public WorldGenerator getWorldGenerator() {
        return ((WorldServerBridge)((Object)this)).bridge$getSpongeGenerator();
    }

    @Override
    public ScheduledBlockUpdate addScheduledUpdate(int x, int y, int z, int priority, int ticks) {
        BlockPos pos = new BlockPos(x, y, z);
        this.func_175654_a(pos, this.func_180495_p(pos).func_177230_c(), ticks, priority);
        ScheduledBlockUpdate sbu = ((WorldServerBridge)((Object)this)).bridge$getScheduledBlockUpdate();
        ((WorldServerBridge)((Object)this)).bridge$setScheduledBlockUpdate(null);
        return sbu;
    }

    @Override
    public void removeScheduledUpdate(int x, int y, int z, ScheduledBlockUpdate update) {
        this.field_73064_N.remove(update);
        this.field_73065_O.remove(update);
    }

    @Override
    public boolean save() throws IOException {
        if (!this.func_72863_F().func_73157_c()) {
            return false;
        }
        try {
            WorldManager.saveWorld((WorldServer)this, true);
        }
        catch (MinecraftException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public Collection<ScheduledBlockUpdate> getScheduledUpdates(int x, int y, int z) {
        BlockPos position = new BlockPos(x, y, z);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (NextTickListEntry sbu : this.field_73065_O) {
            if (!sbu.field_180282_a.equals((Object)position)) continue;
            builder.add((Object)((ScheduledBlockUpdate)sbu));
        }
        return builder.build();
    }

    @Override
    public Optional<Entity> getEntity(UUID uuid) {
        return Optional.ofNullable((Entity)this.func_175733_a(uuid));
    }

    @Override
    public Optional<Chunk> regenerateChunk(int cx, int cy, int cz, ChunkRegenerateFlag flag) {
        Chunk spongeChunk;
        ArrayList<EntityPlayerMP> playerList = new ArrayList<EntityPlayerMP>();
        ArrayList<net.minecraft.entity.Entity> entityList = new ArrayList<net.minecraft.entity.Entity>();
        try (Object context = GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING.createPhaseContext().world((World)this);){
            ((PhaseContext)context).buildAndSwitch();
            spongeChunk = this.loadChunk(cx, cy, cz, false).orElse(null);
        }
        if (spongeChunk == null) {
            if (!flag.create()) {
                return Optional.empty();
            }
            return this.loadChunk(cx, cy, cz, true);
        }
        net.minecraft.world.chunk.Chunk chunk = (net.minecraft.world.chunk.Chunk)spongeChunk;
        boolean keepEntities = flag.entities();
        try (ChunkRegenerateContext context = GenerationPhase.State.CHUNK_REGENERATING.createPhaseContext().chunk(chunk);){
            context.buildAndSwitch();
            for (ClassInheritanceMultiMap multiEntityList : chunk.func_177429_s()) {
                for (net.minecraft.entity.Entity entity : multiEntityList) {
                    if (entity instanceof EntityPlayerMP) {
                        playerList.add((EntityPlayerMP)entity);
                        entityList.add(entity);
                        continue;
                    }
                    if (!keepEntities) continue;
                    entityList.add(entity);
                }
            }
            for (net.minecraft.entity.Entity entity : entityList) {
                chunk.func_76622_b(entity);
            }
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)chunk.func_177412_p().func_72863_F();
            ((ChunkProviderServerBridge)chunkProviderServer).bridge$unloadChunkAndSave(chunk);
            net.minecraft.world.chunk.Chunk newChunk = ((ChunkProviderServerBridge)chunkProviderServer).accessor$getChunkGenerator().func_185932_a(cx, cz);
            PlayerChunkMapEntry playerChunk = ((WorldServer)chunk.func_177412_p()).func_184164_w().func_187301_b(cx, cz);
            if (playerChunk != null) {
                ((PlayerChunkMapEntryBridge)playerChunk).bridge$setChunk(newChunk);
            }
            if (newChunk != null) {
                WorldServer world = (WorldServer)newChunk.func_177412_p();
                ((ChunkProviderServerBridge)world.func_72863_F()).accessor$getLoadedChunks().put(ChunkPos.func_77272_a((int)cx, (int)cz), (Object)newChunk);
                newChunk.func_76631_c();
                ((ChunkBridge)newChunk).accessor$populate(((ChunkProviderServerBridge)world.func_72863_F()).accessor$getChunkGenerator());
                for (net.minecraft.entity.Entity entity : entityList) {
                    newChunk.func_76612_a(entity);
                }
                if (((ChunkProviderBridge)chunkProviderServer).bridge$getLoadedChunkWithoutMarkingActive(cx, cz) == null) {
                    Optional<Chunk> optional = Optional.of((Chunk)newChunk);
                    return optional;
                }
                PlayerChunkMapEntry playerChunkMapEntry = ((WorldServer)newChunk.func_177412_p()).func_184164_w().func_187301_b(cx, cz);
                if (playerChunkMapEntry != null) {
                    List<EntityPlayerMP> chunkPlayers = ((PlayerChunkMapEntryBridge)playerChunkMapEntry).accessor$getPlayers();
                    for (EntityPlayerMP playerMP : chunkPlayers) {
                        playerMP.field_71135_a.func_147359_a((Packet)new SPacketChunkData(newChunk, 65534));
                        playerMP.field_71135_a.func_147359_a((Packet)new SPacketChunkData(newChunk, 1));
                    }
                }
            }
            Optional<Chunk> optional = Optional.of((Chunk)newChunk);
            return optional;
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        this.checkBlockBounds(x, y, z);
        IPhaseState<?> state = PhaseTracker.getInstance().getCurrentState();
        boolean isWorldGen = state.isWorldGeneration();
        boolean handlesOwnCompletion = state.handlesOwnStateCompletion();
        if (!isWorldGen) {
            Preconditions.checkArgument((flag != null ? 1 : 0) != 0, (Object)"BlockChangeFlag cannot be null!");
        }
        try (BasicPluginContext context = isWorldGen || handlesOwnCompletion ? null : PluginPhase.State.BLOCK_WORKER.createPhaseContext();){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = this.func_180501_a(new BlockPos(x, y, z), (IBlockState)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockSnapshot.NONE;
        }
        if (!this.func_175680_a(x >> 4, z >> 4, false)) {
            return BlockSnapshot.NONE;
        }
        BlockPos pos = new BlockPos(x, y, z);
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.worldId(this.getUniqueId()).position(new Vector3i(x, y, z));
        net.minecraft.world.chunk.Chunk chunk = this.func_175726_f(pos);
        IBlockState state = chunk.func_186032_a(x, y, z);
        builder.blockState(state);
        try {
            builder.extendedState((BlockState)state.func_185899_b((IBlockAccess)((WorldServer)this), pos));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tile != null) {
            TrackingUtil.addTileEntityToBuilder(tile, builder);
        }
        ((ChunkBridge)chunk).bridge$getBlockOwnerUUID(pos).ifPresent(builder::creator);
        ((ChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        NonNullArrayList entitiesToSpawn = new NonNullArrayList();
        entities.forEach(entitiesToSpawn::add);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entitiesToSpawn);
        if (Sponge.getEventManager().post(event)) {
            return ImmutableList.of();
        }
        for (Entity entity : event.getEntities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Entity entity : event.getEntities()) {
            builder.add((Object)entity);
        }
        return builder.build();
    }

    @Override
    public void triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        Explosion mcExplosion;
        Preconditions.checkNotNull((Object)explosion, (Object)"explosion");
        this.processingExplosion = true;
        ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(Sponge.getCauseStackManager().getCurrentCause(), explosion, this);
        if (SpongeImpl.postEvent(event)) {
            this.processingExplosion = false;
            return;
        }
        explosion = event.getExplosion();
        try {
            mcExplosion = (Explosion)explosion;
        }
        catch (Exception e) {
            new PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add(e).trace();
            return;
        }
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext().explosion((Explosion)explosion).source(explosion.getSourceExplosive().isPresent() ? explosion.getSourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean damagesTerrain = explosion.shouldBreakBlocks();
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(false);
            if (!damagesTerrain) {
                mcExplosion.func_180342_d();
            }
            this.processingExplosion = false;
        }
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"The entity cannot be null!");
        if (PhaseTracker.isEntitySpawnInvalid(entity)) {
            return true;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (!state.alreadyCapturingEntitySpawns()) {
            try (BasicPluginContext context = PluginPhase.State.CUSTOM_SPAWN.createPhaseContext();){
                context.buildAndSwitch();
                phaseTracker.spawnEntityWithCause(this, entity);
                boolean bl = true;
                return bl;
            }
        }
        return phaseTracker.spawnEntityWithCause(this, entity);
    }

    @Override
    public WorldStorage getWorldStorage() {
        return (WorldStorage)((WorldServer)this).func_72863_F();
    }

    @Override
    public PortalAgent getPortalAgent() {
        return (PortalAgent)this.field_85177_Q;
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume) {
        this.playSound(sound, category, position, volume, 1.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch) {
        this.playSound(sound, category, position, volume, pitch, 0.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch, double minVolume) {
        SoundEvent event;
        try {
            event = SoundEvents.func_187510_a((String)sound.getId());
        }
        catch (IllegalStateException e) {
            this.field_73021_x.stream().filter(listener -> listener instanceof ServerWorldEventHandlerBridge).map(listener -> (ServerWorldEventHandlerBridge)listener).forEach(listener -> listener.bridge$playCustomSoundToAllNearExcept(null, sound.getId(), (net.minecraft.util.SoundCategory)category, position.getX(), position.getY(), position.getZ(), (float)Math.max(minVolume, volume), (float)pitch));
            return;
        }
        this.func_184148_a(null, position.getX(), position.getY(), position.getZ(), event, (net.minecraft.util.SoundCategory)category, (float)Math.max(minVolume, volume), (float)pitch);
    }

    @Override
    public void stopSounds() {
        this.apiImpl$stopSounds(null, null);
    }

    @Override
    public void stopSounds(SoundType sound) {
        this.apiImpl$stopSounds((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), null);
    }

    @Override
    public void stopSounds(SoundCategory category) {
        this.apiImpl$stopSounds(null, (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    @Override
    public void stopSounds(SoundType sound, SoundCategory category) {
        this.apiImpl$stopSounds((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    private void apiImpl$stopSounds(@Nullable SoundType sound, @Nullable SoundCategory category) {
        this.field_73061_a.func_184103_al().func_148537_a((Packet)SoundEffectHelper.createStopSoundPacket(sound, category), ((WorldServerBridge)((Object)this)).bridge$getDimensionId());
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        List<Packet<?>> packets = SpongeParticleHelper.toPackets((SpongeParticleEffect)particleEffect, position);
        if (!packets.isEmpty()) {
            PlayerList playerList = this.field_73061_a.func_184103_al();
            double x = position.getX();
            double y = position.getY();
            double z = position.getZ();
            for (Packet<?> packet : packets) {
                playerList.func_148543_a(null, x, y, z, (double)radius, ((WorldServerBridge)((Object)this)).bridge$getDimensionId(), packet);
            }
        }
    }

    @Override
    public void playRecord(Vector3i position, RecordType recordType) {
        this.api$playRecord(position, (RecordType)Preconditions.checkNotNull((Object)recordType, (Object)"recordType"));
    }

    @Override
    public void stopRecord(Vector3i position) {
        this.api$playRecord(position, null);
    }

    private void api$playRecord(Vector3i position, @Nullable RecordType recordType) {
        this.field_73061_a.func_184103_al().func_148537_a((Packet)SpongeRecordType.createPacket(position, recordType), ((WorldServerBridge)((Object)this)).bridge$getDimensionId());
    }

    @Override
    public Weather getWeather() {
        if (this.field_72986_A.func_76061_m()) {
            return Weathers.THUNDER_STORM;
        }
        if (this.field_72986_A.func_76059_o()) {
            return Weathers.RAIN;
        }
        return Weathers.CLEAR;
    }

    @Override
    public long getRemainingDuration() {
        Weather weather = this.getWeather();
        if (weather.equals(Weathers.CLEAR)) {
            if (this.field_72986_A.func_176133_A() > 0) {
                return this.field_72986_A.func_176133_A();
            }
            return Math.min(this.field_72986_A.func_76071_n(), this.field_72986_A.func_76083_p());
        }
        if (weather.equals(Weathers.THUNDER_STORM)) {
            return this.field_72986_A.func_76071_n();
        }
        if (weather.equals(Weathers.RAIN)) {
            return this.field_72986_A.func_76083_p();
        }
        return 0L;
    }

    @Override
    public long getRunningDuration() {
        return this.field_72986_A.func_82573_f() - ((WorldServerBridge)((Object)this)).bridge$getWeatherStartTime();
    }

    @Override
    public void setWeather(Weather weather) {
        this.setWeather(weather, (300 + this.field_73012_v.nextInt(600)) * 20);
    }

    @Override
    public void setWeather(Weather weather, long duration) {
        ((WorldServerBridge)((Object)this)).bridge$setPreviousWeather(this.getWeather());
        if (weather.equals(Weathers.CLEAR)) {
            this.field_72986_A.func_176142_i((int)duration);
            this.field_72986_A.func_76080_g(0);
            this.field_72986_A.func_76090_f(0);
            this.field_72986_A.func_76084_b(false);
            this.field_72986_A.func_76069_a(false);
        } else if (weather.equals(Weathers.RAIN)) {
            this.field_72986_A.func_176142_i(0);
            this.field_72986_A.func_76080_g((int)duration);
            this.field_72986_A.func_76090_f((int)duration);
            this.field_72986_A.func_76084_b(true);
            this.field_72986_A.func_76069_a(false);
        } else if (weather.equals(Weathers.THUNDER_STORM)) {
            this.field_72986_A.func_176142_i(0);
            this.field_72986_A.func_76080_g((int)duration);
            this.field_72986_A.func_76090_f((int)duration);
            this.field_72986_A.func_76084_b(true);
            this.field_72986_A.func_76069_a(true);
        }
    }

    @Override
    public int getViewDistance() {
        return ((PlayerChunkMapBridge)this.field_73063_M).accessor$getViewDistance();
    }

    @Override
    public void setViewDistance(int viewDistance) {
        this.field_73063_M.func_152622_a(viewDistance);
        SpongeConfig<WorldConfig> configAdapter = ((WorldInfoBridge)this.func_72912_H()).bridge$getConfigAdapter();
        configAdapter.getConfig().getWorld().setViewDistance(((PlayerChunkMapBridge)this.field_73063_M).accessor$getViewDistance());
        configAdapter.save();
    }

    @Override
    public void resetViewDistance() {
        this.setViewDistance(this.field_73061_a.func_184103_al().func_72395_o());
    }
}

