/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.scoreboard.ScorePlayerTeamBridge;
import org.spongepowered.common.registry.type.text.TextColorRegistryModule;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.format.SpongeTextColor;

@Mixin(value={ScorePlayerTeam.class})
public abstract class ScorePlayerTeamMixin
implements ScorePlayerTeamBridge {
    @Shadow
    @Final
    @Mutable
    private @Nullable Scoreboard field_96677_a;
    @Shadow
    private String field_96673_d;
    @Shadow
    private TextFormatting field_178777_k;
    @Shadow
    private String field_96674_e;
    @Shadow
    private String field_96671_f;
    private @MonotonicNonNull Text bridge$displayName;
    private @MonotonicNonNull Text bridge$Prefix;
    private @MonotonicNonNull Text bridge$Suffix;
    private @MonotonicNonNull TextColor bridge$Color;

    @Shadow
    public abstract Collection<String> func_96670_d();

    private void impl$doTeamUpdate() {
        if (this.field_96677_a != null) {
            this.field_96677_a.func_96538_b((ScorePlayerTeam)this);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpDisplayNames(Scoreboard scoreboardIn, String name, CallbackInfo ci) {
        this.bridge$displayName = SpongeTexts.fromLegacy(name);
        this.bridge$Prefix = SpongeTexts.fromLegacy(this.field_96674_e);
        this.bridge$Suffix = SpongeTexts.fromLegacy(this.field_96671_f);
        this.bridge$Color = TextColorRegistryModule.enumChatColor.get(this.field_178777_k);
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void impl$nullCheckScoreboard(@Nullable Scoreboard scoreboard, ScorePlayerTeam team) {
        if (scoreboard != null) {
            scoreboard.func_96538_b(team);
        }
    }

    @Inject(method={"setDisplayName"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;displayName:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForDisplayName(String name, CallbackInfo ci) {
        this.bridge$displayName = SpongeTexts.fromLegacy(name);
    }

    @Inject(method={"setPrefix"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;prefix:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForPrefix(String prefix, CallbackInfo callbackInfo) {
        this.bridge$Prefix = SpongeTexts.fromLegacy(prefix);
    }

    @Inject(method={"setSuffix"}, at={@At(value="FIELD", target="Lnet/minecraft/scoreboard/ScorePlayerTeam;suffix:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$doTeamUpdateForSuffix(String suffix, CallbackInfo ci) {
        this.bridge$Suffix = SpongeTexts.fromLegacy(suffix);
    }

    @Inject(method={"setColor"}, at={@At(value="RETURN")})
    private void impl$doTeamUpdateForFormat(TextFormatting format, CallbackInfo ci) {
        this.bridge$Color = TextColorRegistryModule.enumChatColor.get(format);
        this.impl$doTeamUpdate();
    }

    @Override
    public @Nullable Scoreboard accessor$getScoreboard() {
        return this.field_96677_a;
    }

    @Override
    public void accessor$setScoreboard(@Nullable Scoreboard scoreboard) {
        this.field_96677_a = scoreboard;
    }

    @Override
    public Text bridge$getDisplayName() {
        return this.bridge$displayName;
    }

    @Override
    public void bridge$setDisplayName(Text text) {
        String newText = SpongeTexts.toLegacy(text);
        if (newText.length() > 32) {
            throw new IllegalArgumentException(String.format("Display name is %s characters long! It must be at most 32.", newText.length()));
        }
        this.bridge$displayName = text;
        this.field_96673_d = newText;
        this.impl$doTeamUpdate();
    }

    @Override
    public Text bridge$getPrefix() {
        return this.bridge$Prefix;
    }

    @Override
    public void bridge$setPrefix(Text text) {
        String newPrefix = SpongeTexts.toLegacy(text);
        if (newPrefix.length() > 16) {
            throw new IllegalArgumentException(String.format("Prefix is %s characters long! It must be at most 16.", newPrefix.length()));
        }
        this.bridge$Prefix = text;
        this.field_96674_e = newPrefix;
        this.impl$doTeamUpdate();
    }

    @Override
    public Text bridge$getSuffix() {
        return this.bridge$Suffix;
    }

    @Override
    public void bridge$setSuffix(Text suffix) {
        String newSuffix = SpongeTexts.toLegacy(suffix);
        if (newSuffix.length() > 16) {
            throw new IllegalArgumentException(String.format("Suffix is %s characters long! It must be at most 16.", newSuffix.length()));
        }
        this.bridge$Suffix = suffix;
        this.field_96671_f = newSuffix;
        this.impl$doTeamUpdate();
    }

    @Override
    public void bridge$setColor(TextColor color) {
        if (color.equals(TextColors.NONE)) {
            color = TextColors.RESET;
        }
        this.bridge$Color = color;
        this.field_178777_k = ((SpongeTextColor)color).getHandle();
        this.impl$doTeamUpdate();
    }

    @Override
    public MessageChannel bridge$getTeamChannel(EntityPlayerMP player) {
        return MessageChannel.fixed(this.func_96670_d().stream().map(name -> Sponge.getGame().getServer().getPlayer((String)name)).filter(Optional::isPresent).map(Optional::get).filter(member -> member != player).collect(Collectors.toSet()));
    }

    @Override
    public MessageChannel bridge$getNonTeamChannel() {
        return MessageChannel.fixed(Sponge.getGame().getServer().getOnlinePlayers().stream().filter(player -> ((EntityPlayerMP)player).func_96124_cp() != this).collect(Collectors.toSet()));
    }
}

