/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import com.flowpowered.math.vector.Vector3d;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.tileentity.MobSpawnerBaseLogicBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;

@Mixin(value={MobSpawnerBaseLogic.class})
public abstract class MobSpawnerBaseLogicMixin
implements MobSpawnerBaseLogicBridge {
    @Shadow
    private int field_98286_b;
    @Shadow
    private int field_98283_g;
    @Shadow
    private int field_98293_h;
    @Shadow
    private int field_98294_i;
    @Shadow
    private int field_98292_k;
    @Shadow
    private int field_98289_l;
    @Shadow
    private int field_98290_m;

    @Nullable
    @Redirect(method={"updateSpawner"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/AnvilChunkLoader;readWorldEntityPos(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;DDDZ)Lnet/minecraft/entity/Entity;"))
    private Entity impl$ThrowEventAndConstruct(NBTTagCompound compound, World world, double x, double y, double z, boolean doesNotForceSpawn) {
        Entity entity;
        String entityTypeString = compound.func_74779_i("id");
        Class<? extends Entity> clazz = SpongeImplHooks.getEntityClass(new ResourceLocation(entityTypeString));
        if (clazz == null) {
            PrettyPrinter printer = new PrettyPrinter(60).add("Unknown Entity for MobSpawners").centre().hr().addWrapped(60, "Sponge has found a MobSpawner attempting to locate potentiallya foreign entity type for a MobSpawner, unfortunately, there isn't away to get around the deserialization process looking up unregisteredentity types. This may be a bug with a mod or sponge.", new Object[0]).add("%s : %s", "Entity Name", entityTypeString).add();
            PhaseTracker.getInstance().generateVersionInfo(printer);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.WARN);
            return null;
        }
        CatalogType type = EntityTypeRegistryModule.getInstance().getForClass((Class)clazz);
        if (type == null) {
            return null;
        }
        if (ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.MOB_SPAWNER);
                Transform<org.spongepowered.api.world.World> transform = new Transform<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z));
                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), (EntityType)type, transform);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    Entity entity2 = null;
                    return entity2;
                }
            }
        }
        try {
            entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        }
        catch (Exception e) {
            return null;
        }
        if (entity == null) {
            return null;
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        if (doesNotForceSpawn && !world.func_72838_d(entity)) {
            return null;
        }
        if (compound.func_150297_b("Passengers", 9)) {
            NBTTagList passengerList = compound.func_150295_c("Passengers", 10);
            for (int i = 0; i < passengerList.func_74745_c(); ++i) {
                Entity passenger = this.impl$ThrowEventAndConstruct(passengerList.func_150305_b(i), world, x, y, z, doesNotForceSpawn);
                if (passenger == null) continue;
                passenger.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    @Override
    public int bridge$getSpawnDelay() {
        return this.field_98286_b;
    }

    @Override
    public void bridge$setSpawnDelay(int spawnDelay) {
        this.field_98286_b = spawnDelay;
    }

    @Override
    public int bridge$getMinSpawnDelay() {
        return this.field_98283_g;
    }

    @Override
    public int bridge$getMaxSpawnDelay() {
        return this.field_98293_h;
    }

    @Override
    public int bridge$getSpawnCount() {
        return this.field_98294_i;
    }

    @Override
    public int bridge$getMaxNearbyEntities() {
        return this.field_98292_k;
    }

    @Override
    public void bridge$setMaxNearbyEntities(int maxNearbyEntities) {
        this.field_98292_k = maxNearbyEntities;
    }

    @Override
    public int bridge$getActivatingRangeFromPlayer() {
        return this.field_98289_l;
    }

    @Override
    public int bridge$getSpawnRange() {
        return this.field_98290_m;
    }
}

