/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util.text;

import java.util.Iterator;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ObjectUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.util.text.ITextComponentBridge;
import org.spongepowered.common.bridge.util.text.StyleBridge;
import org.spongepowered.common.bridge.util.text.TextFormattingBridge;
import org.spongepowered.common.bridge.util.text.event.ClickEventBridge;
import org.spongepowered.common.bridge.util.text.event.HoverEventBridge;
import org.spongepowered.common.text.ResolvedChatStyle;
import org.spongepowered.common.text.TextComponentIterable;
import org.spongepowered.common.text.format.SpongeTextColor;

@Mixin(value={TextComponentBase.class})
public abstract class TextComponentBaseMixin
implements ITextComponentBridge,
ITextComponent {
    @Shadow
    private Style field_150263_b;
    @Shadow
    protected List<ITextComponent> field_150264_a;

    protected Text.Builder impl$createBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ITextComponent> bridge$childrenIterator() {
        return this.func_150253_a().iterator();
    }

    @Override
    public Iterable<ITextComponent> bridge$withChildren() {
        return new TextComponentIterable(this, true);
    }

    @Override
    public String bridge$toPlain() {
        StringBuilder builder = new StringBuilder();
        for (ITextComponent component : this.bridge$withChildren()) {
            builder.append(component.func_150261_e());
        }
        return builder.toString();
    }

    private StringBuilder getLegacyFormattingBuilder() {
        StringBuilder builder = new StringBuilder();
        Style style = this.func_150256_b();
        TextComponentBaseMixin.apply(builder, '\u00a7', (TextFormatting)ObjectUtils.defaultIfNull((Object)style.func_150215_a(), (Object)TextFormatting.RESET));
        TextComponentBaseMixin.apply(builder, '\u00a7', TextFormatting.BOLD, style.func_150223_b());
        TextComponentBaseMixin.apply(builder, '\u00a7', TextFormatting.ITALIC, style.func_150242_c());
        TextComponentBaseMixin.apply(builder, '\u00a7', TextFormatting.UNDERLINE, style.func_150234_e());
        TextComponentBaseMixin.apply(builder, '\u00a7', TextFormatting.STRIKETHROUGH, style.func_150236_d());
        TextComponentBaseMixin.apply(builder, '\u00a7', TextFormatting.OBFUSCATED, style.func_150233_f());
        return builder;
    }

    @Override
    public String bridge$getLegacyFormatting() {
        return this.getLegacyFormattingBuilder().toString();
    }

    @Override
    public String bridge$toLegacy(char code) {
        StringBuilder builder = new StringBuilder();
        ResolvedChatStyle current = null;
        Style previous = null;
        for (ITextComponent component : this.bridge$withChildren()) {
            Style newStyle = component.func_150256_b();
            ResolvedChatStyle style = TextComponentBaseMixin.resolve(current, previous, newStyle);
            previous = newStyle;
            if (current == null || current.color != style.color || current.bold && !style.bold || current.italic && !style.italic || current.underlined && !style.underlined || current.strikethrough && !style.strikethrough || current.obfuscated && !style.obfuscated) {
                if (style.color != null) {
                    TextComponentBaseMixin.apply(builder, code, style.color);
                } else if (current != null) {
                    TextComponentBaseMixin.apply(builder, code, TextFormatting.RESET);
                }
                TextComponentBaseMixin.apply(builder, code, TextFormatting.BOLD, style.bold);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.ITALIC, style.italic);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.UNDERLINE, style.underlined);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.STRIKETHROUGH, style.strikethrough);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.OBFUSCATED, style.obfuscated);
            } else {
                TextComponentBaseMixin.apply(builder, code, TextFormatting.BOLD, current.bold != style.bold);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.ITALIC, current.italic != style.italic);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.UNDERLINE, current.underlined != style.underlined);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.STRIKETHROUGH, current.strikethrough != style.strikethrough);
                TextComponentBaseMixin.apply(builder, code, TextFormatting.OBFUSCATED, current.obfuscated != style.obfuscated);
            }
            current = style;
            builder.append(component.func_150261_e());
        }
        return builder.toString();
    }

    @Override
    public String bridge$toLegacySingle(char code) {
        return this.getLegacyFormattingBuilder().append(this.func_150261_e()).toString();
    }

    private static ResolvedChatStyle resolve(ResolvedChatStyle current, Style previous, Style style) {
        StyleBridge bridge = (StyleBridge)style;
        if (current != null && bridge.bridge$getParentStyle() == previous) {
            return new ResolvedChatStyle((TextFormatting)ObjectUtils.defaultIfNull((Object)bridge.bridge$getColor(), (Object)current.color), TextComponentBaseMixin.firstNonNull(bridge.bridge$getBold(), current.bold), TextComponentBaseMixin.firstNonNull(bridge.bridge$getItalic(), current.italic), TextComponentBaseMixin.firstNonNull(bridge.bridge$getUnderlined(), current.underlined), TextComponentBaseMixin.firstNonNull(bridge.bridge$getStrikethrough(), current.strikethrough), TextComponentBaseMixin.firstNonNull(bridge.bridge$getObfuscated(), current.obfuscated));
        }
        return new ResolvedChatStyle(style.func_150215_a(), style.func_150223_b(), style.func_150242_c(), style.func_150234_e(), style.func_150236_d(), style.func_150233_f());
    }

    private static boolean firstNonNull(Boolean b1, boolean b2) {
        return b1 != null ? b1 : b2;
    }

    private static void apply(StringBuilder builder, char code, TextFormatting formatting) {
        builder.append(code).append(((TextFormattingBridge)formatting).bridge$getFormattingCode());
    }

    private static void apply(StringBuilder builder, char code, TextFormatting formatting, boolean state) {
        if (state) {
            TextComponentBaseMixin.apply(builder, code, formatting);
        }
    }

    @Override
    public Text bridge$toText() {
        Text.Builder builder = this.impl$createBuilder();
        StyleBridge style = (StyleBridge)this.field_150263_b;
        if (style != null) {
            if (style.bridge$getColor() != null) {
                builder.color(SpongeTextColor.of(style.bridge$getColor()));
            }
            builder.style(new TextStyle(style.bridge$getBold(), style.bridge$getItalic(), style.bridge$getUnderlined(), style.bridge$getStrikethrough(), style.bridge$getObfuscated()));
            if (style.bridge$getClickEvent() != null) {
                builder.onClick(((ClickEventBridge)style.bridge$getClickEvent()).bridge$getHandle());
            }
            if (style.bridge$getHoverEvent() != null) {
                builder.onHover(((HoverEventBridge)style.bridge$getHoverEvent()).bridge$getHandle());
            }
            if (style.bridge$getInsertion() != null) {
                builder.onShiftClick(TextActions.insertText(style.bridge$getInsertion()));
            }
        }
        for (ITextComponent child : this.field_150264_a) {
            builder.append(((ITextComponentBridge)child).bridge$toText());
        }
        return builder.build();
    }
}

