/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.LocatableSnapshot;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ChangeWorldWeatherEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.block.BlockEventDataBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.server.management.PlayerChunkMapBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.util.math.BlockPosBridge;
import org.spongepowered.common.bridge.world.NextTickListEntryBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldProviderBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.WorldTypeBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.bridge.world.gen.PopulatorProviderBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.WorldCategory;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.SpongeProxyBlockAccess;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.mixin.core.world.WorldMixin;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.ActivationCapability;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.CollisionsCapability;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.registry.type.world.BlockChangeFlagRegistryModule;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.relocate.co.aikar.timings.WorldTimingsHandler;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.border.PlayerBorderListener;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.SpongeGenerationPopulator;
import org.spongepowered.common.world.gen.SpongeWorldGenerator;
import org.spongepowered.common.world.gen.WorldGenConstants;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin
extends WorldMixin
implements WorldServerBridge {
    private final Map<net.minecraft.entity.Entity, Vector3d> impl$rotationUpdates = new HashMap<net.minecraft.entity.Entity, Vector3d>();
    @Nullable
    private SpongeChunkGenerator impl$spongegen;
    private long impl$weatherStartTime;
    private Weather prevWeather = Weathers.CLEAR;
    private WorldTimingsHandler impl$timings;
    private int impl$chunkGCTickCount = 0;
    private int impl$chunkGCLoadThreshold = 0;
    private int impl$chunkGCTickInterval = 600;
    private int impl$chunkLoadCount = 0;
    private long impl$chunkUnloadDelay = 30000L;
    private boolean impl$weatherThunderEnabled = true;
    private boolean impl$weatherIceAndSnowEnabled = true;
    private int impl$dimensionId;
    @Nullable
    private NextTickListEntry impl$tmpScheduledObj;
    @Nullable
    private GenericGenerationContext impl$spawnGenerationContext;
    @Shadow
    @Final
    private MinecraftServer field_73061_a;
    @Shadow
    @Final
    private PlayerChunkMap field_73063_M;
    @Shadow
    @Final
    @Mutable
    private Teleporter field_85177_Q;
    @Shadow
    private int field_80004_Q;
    private SpongeProxyBlockAccess proxyBlockAccess = new SpongeProxyBlockAccess(this);

    @Shadow
    protected void func_73042_a() throws MinecraftException {
    }

    @Shadow
    private boolean func_147485_a(BlockEventData event) {
        return false;
    }

    @Shadow
    protected abstract void func_73047_i();

    @Shadow
    public abstract PlayerChunkMap func_184164_w();

    @Shadow
    public abstract ChunkProviderServer func_72863_F();

    @Shadow
    protected abstract void func_184162_i();

    @Shadow
    protected abstract BlockPos func_175736_a(BlockPos var1);

    @Shadow
    private boolean func_184165_i(net.minecraft.entity.Entity entityIn) {
        return false;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;setWorld(Lnet/minecraft/world/World;)V"))
    private void onSetWorld(WorldProvider worldProvider, net.minecraft.world.World worldIn) {
        WorldInfo originalWorldInfo = worldIn.func_72912_H();
        worldProvider.func_76558_a(worldIn);
        this.field_72986_A = originalWorldInfo;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$initializeSpongeFields(MinecraftServer server, ISaveHandler saveHandlerIn, @Nullable WorldInfo info, int dimensionId, Profiler profilerIn, CallbackInfo callbackInfo) {
        if (info == null) {
            SpongeImpl.getLogger().warn("World constructed without a WorldInfo! This will likely cause problems. Subsituting dummy info.", (Throwable)new RuntimeException("Stack trace:"));
            info = new WorldInfo(new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.field_77137_b), "sponge$dummy_world");
        }
        this.field_72986_A = info;
        this.impl$timings = new WorldTimingsHandler((net.minecraft.world.World)((WorldServer)this));
        this.impl$dimensionId = dimensionId;
        this.prevWeather = ((World)((Object)this)).getWeather();
        this.impl$weatherStartTime = this.field_72986_A.func_82573_f();
        this.func_175723_af().func_177737_a((IBorderListener)new PlayerBorderListener(this.func_73046_m(), dimensionId));
        PortalAgentType portalAgentType = ((WorldProperties)this.field_72986_A).getPortalAgentType();
        if (!portalAgentType.equals(PortalAgentTypes.DEFAULT)) {
            try {
                this.field_85177_Q = (Teleporter)portalAgentType.getPortalAgentClass().getConstructor(WorldServer.class).newInstance(this);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().log(Level.ERROR, "Could not create PortalAgent of type " + portalAgentType.getId() + " for world " + ((World)((Object)this)).getName() + ": " + e.getMessage() + ". Falling back to default...");
            }
        }
        this.impl$updateWorldGenerator();
        WorldCategory worldCategory = ((WorldInfoBridge)this.func_72912_H()).bridge$getConfigAdapter().getConfig().getWorld();
        this.impl$chunkGCLoadThreshold = worldCategory.getChunkLoadThreshold();
        this.impl$chunkGCTickInterval = worldCategory.getTickInterval();
        this.impl$weatherIceAndSnowEnabled = worldCategory.getWeatherIceAndSnow();
        this.impl$weatherThunderEnabled = worldCategory.getWeatherThunder();
        this.field_80004_Q = 0;
        this.setMemoryViewDistance(this.chooseViewDistanceValue(worldCategory.getViewDistance()));
    }

    @Redirect(method={"init"}, at=@At(value="NEW", target="net/minecraft/world/storage/MapStorage"))
    private MapStorage impl$createMapStorageIfOverworldOrGetOverworldMapStorage(ISaveHandler saveHandler) {
        WorldServer overWorld = WorldManager.getWorldByDimensionId(0).orElse(null);
        if (this.impl$dimensionId != 0 && overWorld != null) {
            return overWorld.func_175693_T();
        }
        return new MapStorage(saveHandler);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/MapStorage;setData(Ljava/lang/String;Lnet/minecraft/world/storage/WorldSavedData;)V"))
    private void impl$onlySaveScoreboardIfDim0OrMapData(MapStorage storage, String name, WorldSavedData data) {
        if ("scoreboard".equals(name) && this.impl$dimensionId != 0) {
            return;
        }
        storage.func_75745_a(name, data);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/ScoreboardSaveData;setScoreboard(Lnet/minecraft/scoreboard/Scoreboard;)V"))
    private void impl$saveScoreboardOnlyIfDim0(ScoreboardSaveData scoreboardSaveData, Scoreboard scoreboard) {
        if (this.impl$dimensionId != 0) {
            return;
        }
        scoreboardSaveData.func_96499_a(scoreboard);
    }

    @Inject(method={"initialize"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;createSpawnPosition(Lnet/minecraft/world/WorldSettings;)V")})
    private void impl$startGeneration(WorldSettings settings, CallbackInfo ci) {
        this.impl$spawnGenerationContext = (GenericGenerationContext)((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().source(this)).buildAndSwitch();
    }

    @Inject(method={"initialize"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;createSpawnPosition(Lnet/minecraft/world/WorldSettings;)V", shift=At.Shift.AFTER)})
    private void impl$endSpawnGeneration(WorldSettings settings, CallbackInfo ci) {
        this.impl$spawnGenerationContext.close();
    }

    @Inject(method={"createSpawnPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$cancelBonusChestIfTheEnd(WorldSettings settings, CallbackInfo ci) {
        GeneratorType generatorType = (GeneratorType)settings.func_77165_h();
        if (!this.field_73011_w.func_76567_e() && ((World)((Object)this)).getProperties().doesGenerateBonusChest()) {
            this.func_73047_i();
        }
        if (generatorType != null && generatorType.equals(GeneratorTypes.THE_END) || ((ChunkProviderServerBridge)((WorldServer)this).func_72863_F()).accessor$getChunkGenerator() instanceof ChunkGeneratorEnd) {
            this.field_72986_A.func_176143_a(new BlockPos(100, 50, 0));
            ci.cancel();
        }
    }

    @Redirect(method={"createSpawnPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldSettings;isBonusChestEnabled()Z"))
    private boolean impl$checkIfBonusChestIsEnabledFromProperties(WorldSettings settings) {
        return ((World)((Object)this)).getProperties().doesGenerateBonusChest();
    }

    @Override
    public void bridge$updateConfigCache() {
        SpongeConfig<WorldConfig> configAdapter = ((WorldInfoBridge)this.field_72986_A).bridge$getConfigAdapter();
        WorldCategory worldCategory = configAdapter.getConfig().getWorld();
        this.impl$chunkGCLoadThreshold = worldCategory.getChunkLoadThreshold();
        this.impl$chunkGCTickInterval = worldCategory.getTickInterval();
        this.impl$weatherIceAndSnowEnabled = worldCategory.getWeatherIceAndSnow();
        this.impl$weatherThunderEnabled = worldCategory.getWeatherThunder();
        this.impl$chunkUnloadDelay = worldCategory.getChunkUnloadDelay() * 1000L;
        if (this.func_72863_F() != null) {
            int maxChunkUnloads = worldCategory.getMaxChunkUnloads();
            ((ChunkProviderBridge)this.func_72863_F()).bridge$setMaxChunkUnloads(maxChunkUnloads < 1 ? 1 : maxChunkUnloads);
            ((ChunkProviderServerBridge)this.func_72863_F()).bridge$setDenyChunkRequests(worldCategory.getDenyChunkRequests());
            for (net.minecraft.entity.Entity entity : this.field_72996_f) {
                if (entity instanceof ActivationCapability) {
                    ((ActivationCapability)entity).activation$requiresActivationCacheRefresh(true);
                }
                if (!(entity instanceof CollisionsCapability)) continue;
                ((CollisionsCapability)entity).collision$requiresCollisionsCacheRefresh(true);
            }
        }
    }

    @Override
    public void bridge$incrementChunkLoadCount() {
        if (this.impl$chunkGCLoadThreshold > 0) {
            ++this.impl$chunkLoadCount;
        }
    }

    private void impl$updateWorldGenerator() {
        DataContainer generatorSettings = ((World)((Object)this)).getProperties().getGeneratorSettings();
        SpongeWorldGenerator newGenerator = this.bridge$createWorldGenerator(generatorSettings);
        if (newGenerator.getBaseGenerationPopulator() instanceof IChunkGenerator) {
            if (WorldGenConstants.isValid((IChunkGenerator)newGenerator.getBaseGenerationPopulator(), PopulatorProviderBridge.class)) {
                ((PopulatorProviderBridge)((Object)newGenerator.getBaseGenerationPopulator())).bridge$addPopulators(newGenerator);
            }
        } else if (newGenerator.getBaseGenerationPopulator() instanceof PopulatorProviderBridge) {
            ((PopulatorProviderBridge)((Object)newGenerator.getBaseGenerationPopulator())).bridge$addPopulators(newGenerator);
        }
        for (WorldGeneratorModifier modifier : ((World)((Object)this)).getProperties().getGeneratorModifiers()) {
            modifier.modifyWorldGenerator(((World)((Object)this)).getProperties(), generatorSettings, newGenerator);
        }
        this.impl$spongegen = this.bridge$createChunkGenerator(newGenerator);
        this.impl$spongegen.setGenerationPopulators(newGenerator.getGenerationPopulators());
        this.impl$spongegen.setPopulators(newGenerator.getPopulators());
        this.impl$spongegen.setBiomeOverrides(newGenerator.getBiomeSettings());
        this.bridge$setProviderGenerator(this.impl$spongegen);
    }

    @Override
    public SpongeChunkGenerator bridge$createChunkGenerator(SpongeWorldGenerator newGenerator) {
        return new SpongeChunkGenerator((net.minecraft.world.World)this, newGenerator.getBaseGenerationPopulator(), newGenerator.getBiomeGenerator());
    }

    @Override
    public void bridge$setProviderGenerator(SpongeChunkGenerator newGenerator) {
        ((ChunkProviderServerBridge)this.field_73020_y).accessor$setChunkGenerator(newGenerator);
    }

    @Override
    public SpongeWorldGenerator bridge$createWorldGenerator(DataContainer settings) {
        Optional<String> optCustomSettings = settings.getString(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS);
        if (optCustomSettings.isPresent()) {
            return this.bridge$createWorldGenerator(optCustomSettings.get());
        }
        String jsonSettings = "";
        try {
            jsonSettings = DataFormats.JSON.write(settings);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().warn("Failed to convert settings from [{}] for GeneratorType [{}] used by World [{}].", (Object)settings, (Object)((net.minecraft.world.World)this).func_175624_G(), (Object)this, (Object)e);
        }
        return this.bridge$createWorldGenerator(jsonSettings);
    }

    @Override
    public SpongeWorldGenerator bridge$createWorldGenerator(String settings) {
        WorldServer worldServer = (WorldServer)this;
        WorldType worldType = worldServer.func_175624_G();
        IChunkGenerator chunkGenerator = ((WorldTypeBridge)worldType).bridge$getChunkGenerator().map(func -> (IChunkGenerator)func.apply(worldServer, settings)).orElseGet(() -> {
            IChunkGenerator current = ((ChunkProviderServerBridge)this.func_72863_F()).accessor$getChunkGenerator();
            if (current == null) {
                WorldProvider worldProvider = worldServer.field_73011_w;
                ((WorldProviderBridge)worldProvider).accessor$setGeneratorSettings(settings);
                return worldProvider.func_186060_c();
            }
            return current;
        });
        BiomeProvider biomeProvider = ((WorldTypeBridge)worldType).bridge$getBiomeProvider().map(func -> (BiomeProvider)func.apply(worldServer)).orElseGet(() -> ((WorldProvider)worldServer.field_73011_w).func_177499_m());
        return new SpongeWorldGenerator((net.minecraft.world.World)worldServer, (BiomeGenerator)biomeProvider, SpongeGenerationPopulator.of((net.minecraft.world.World)worldServer, chunkGenerator));
    }

    @Override
    public boolean func_175678_i(BlockPos pos) {
        if (this.bridge$isFake()) {
            return super.func_175678_i(pos);
        }
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null || chunk.field_189550_d) {
            return false;
        }
        return chunk.func_177444_d(pos);
    }

    @Override
    protected void impl$getRawLightWithoutMarkingChunkActive(BlockPos pos, EnumSkyBlock enumSkyBlock, CallbackInfoReturnable<Integer> cir) {
        if (this.bridge$isFake()) {
            super.impl$getRawLightWithoutMarkingChunkActive(pos, enumSkyBlock, cir);
            return;
        }
        Chunk chunk = ((ChunkProviderBridge)((WorldServer)this).func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null || chunk.field_189550_d) {
            cir.setReturnValue(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Overwrite
    protected void func_147456_g() {
        this.func_184162_i();
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            iterator1 = this.field_73063_M.func_187300_b();
            while (iterator1.hasNext()) {
                ((Chunk)iterator1.next()).func_150804_b(false);
            }
            return;
        }
        i = this.shadow$func_82736_K().func_180263_c("randomTickSpeed");
        flag = this.func_72896_J();
        flag1 = this.func_72911_I();
        this.field_72984_F.func_76320_a("pollingChunks");
        iterator = SpongeImplHooks.getChunkIterator((WorldServer)this);
        while (iterator.hasNext()) {
            this.field_72984_F.func_76320_a("getChunk");
            chunk = iterator.next();
            world = chunk.func_177412_p();
            j = chunk.field_76635_g * 16;
            k = chunk.field_76647_h * 16;
            this.field_72984_F.func_76318_c("checkNextLight");
            this.impl$timings.updateBlocksCheckNextLight.startTiming();
            chunk.func_76594_o();
            this.impl$timings.updateBlocksCheckNextLight.stopTiming();
            this.field_72984_F.func_76318_c("tickChunk");
            this.impl$timings.updateBlocksChunkTick.startTiming();
            chunk.func_150804_b(false);
            this.impl$timings.updateBlocksChunkTick.stopTiming();
            if (!((ChunkBridge)chunk).bridge$areNeighborsLoaded()) continue;
            this.field_72984_F.func_76318_c("thunder");
            this.impl$timings.updateBlocksThunder.startTiming();
            context = TickPhase.Tick.WEATHER.createPhaseContext().source(this);
            var10_11 = null;
            try {
                context.buildAndSwitch();
                if (this.impl$weatherThunderEnabled && SpongeImplHooks.canDoLightning(this.field_73011_w, chunk) && flag && flag1 && this.field_73012_v.nextInt(100000) == 0) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    l = this.field_73005_l >> 2;
                    blockpos = this.func_175736_a(new BlockPos(j + (l & 15), 0, k + (l >> 8 & 15)));
                    if (this.func_175727_C(blockpos)) {
                        difficultyinstance = this.func_175649_E(blockpos);
                        transform = new Transform<World>((World)this, VecHelper.toVector3d(blockpos).toDouble());
                        if (world.func_82736_K().func_82766_b("doMobSpawning") && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01) {
                            frame = Sponge.getCauseStackManager().pushCauseFrame();
                            var16_25 = null;
                            try {
                                frame.pushCause(((World)this).getWeather());
                                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
                                constructEntityEvent = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.HORSE, transform);
                                SpongeImpl.postEvent(constructEntityEvent);
                                if (!constructEntityEvent.isCancelled()) {
                                    entityhorse = new EntitySkeletonHorse((net.minecraft.world.World)((WorldServer)this));
                                    entityhorse.func_190691_p(true);
                                    entityhorse.func_70873_a(0);
                                    entityhorse.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                                    this.func_72838_d((net.minecraft.entity.Entity)entityhorse);
                                }
                                lightning = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.LIGHTNING, transform);
                                SpongeImpl.postEvent(lightning);
                                if (lightning.isCancelled() || SpongeImpl.postEvent(lightningPre = SpongeEventFactory.createLightningEventPre(frame.getCurrentCause()))) ** GOTO lbl112
                                this.func_72942_c((net.minecraft.entity.Entity)new EntityLightningBolt(world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), true));
                            }
                            catch (Throwable constructEntityEvent) {
                                var16_25 = constructEntityEvent;
                                throw constructEntityEvent;
                            }
                            finally {
                                if (frame != null) {
                                    if (var16_25 != null) {
                                        try {
                                            frame.close();
                                        }
                                        catch (Throwable constructEntityEvent) {
                                            var16_25.addSuppressed(constructEntityEvent);
                                        }
                                    } else {
                                        frame.close();
                                    }
                                }
                            }
                        } else {
                            frame = Sponge.getCauseStackManager().pushCauseFrame();
                            var16_26 = null;
                            try {
                                frame.pushCause(((World)this).getWeather());
                                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WEATHER);
                                event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.LIGHTNING, transform);
                                SpongeImpl.postEvent(event);
                                if (!event.isCancelled() && !SpongeImpl.postEvent(lightningPre = SpongeEventFactory.createLightningEventPre(frame.getCurrentCause()))) {
                                    this.func_72942_c((net.minecraft.entity.Entity)new EntityLightningBolt(world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), true));
                                }
                            }
                            catch (Throwable event) {
                                var16_26 = event;
                                throw event;
                            }
                            finally {
                                if (frame != null) {
                                    if (var16_26 != null) {
                                        try {
                                            frame.close();
                                        }
                                        catch (Throwable event) {
                                            var16_26.addSuppressed(event);
                                        }
                                    } else {
                                        frame.close();
                                    }
                                }
                            }
                        }
                    }
                }
                this.impl$timings.updateBlocksThunder.stopTiming();
                this.impl$timings.updateBlocksIceAndSnow.startTiming();
                this.field_72984_F.func_76318_c("iceandsnow");
                if (this.impl$weatherIceAndSnowEnabled && SpongeImplHooks.canDoRainSnowIce(this.field_73011_w, chunk) && this.field_73012_v.nextInt(16) == 0) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    j2 = this.field_73005_l >> 2;
                    blockpos1 = this.func_175725_q(new BlockPos(j + (j2 & 15), 0, k + (j2 >> 8 & 15)));
                    blockpos2 = blockpos1.func_177977_b();
                    if (this.func_175662_w(blockpos2)) {
                        this.func_175656_a(blockpos2, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (flag && this.func_175708_f(blockpos1, true)) {
                        this.func_175656_a(blockpos1, Blocks.field_150431_aC.func_176223_P());
                    }
                    if (flag && this.func_180494_b(blockpos2).func_76738_d()) {
                        this.func_180495_p(blockpos2).func_177230_c().func_176224_k((net.minecraft.world.World)((WorldServer)this), blockpos2);
                    }
                }
            }
            catch (Throwable var11_15) {
                var10_11 = var11_15;
                throw var11_15;
            }
            finally {
                if (context != null) {
                    if (var10_11 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable var11_14) {
                            var10_11.addSuppressed(var11_14);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            this.impl$timings.updateBlocksIceAndSnow.stopTiming();
            this.impl$timings.updateBlocksRandomTick.startTiming();
            this.field_72984_F.func_76318_c("tickBlocks");
            if (i <= 0) continue;
            for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
                if (extendedblockstorage == Chunk.field_186036_a || !extendedblockstorage.func_76675_b()) continue;
                for (i1 = 0; i1 < i; ++i1) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    j1 = this.field_73005_l >> 2;
                    k1 = j1 & 15;
                    l1 = j1 >> 8 & 15;
                    i2 = j1 >> 16 & 15;
                    iblockstate = extendedblockstorage.func_177485_a(k1, i2, l1);
                    block = iblockstate.func_177230_c();
                    this.field_72984_F.func_76320_a("randomTick");
                    if (block.func_149653_t()) {
                        pos = new BlockPos(k1 + j, i2 + extendedblockstorage.func_76662_d(), l1 + k);
                        spongeBlock = (BlockBridge)block;
                        timing = ((TimingBridge)block).bridge$getTimingsHandler();
                        var23_42 = null;
                        try {
                            timing.startTiming();
                            context = PhaseTracker.getInstance().getCurrentContext();
                            phaseState = context.state;
                            if (phaseState.alreadyCapturingBlockTicks(context)) {
                                block.func_180645_a(world, pos, iblockstate, this.field_73012_v);
                            } else {
                                TrackingUtil.randomTickBlock(this, block, pos, iblockstate, this.field_73012_v);
                            }
                        }
                        catch (Throwable var24_47) {
                            var23_42 = var24_47;
                            throw var24_47;
                        }
                        finally {
                            if (timing != null) {
                                if (var23_42 != null) {
                                    try {
                                        timing.close();
                                    }
                                    catch (Throwable var24_46) {
                                        var23_42.addSuppressed(var24_46);
                                    }
                                } else {
                                    timing.close();
                                }
                            }
                        }
                    }
                    this.field_72984_F.func_76319_b();
                }
            }
        }
        this.impl$timings.updateBlocksRandomTick.stopTiming();
        this.field_72984_F.func_76319_b();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/WorldInfo;setDifficulty(Lnet/minecraft/world/EnumDifficulty;)V"))
    private void syncDifficultyDueToHardcore(WorldInfo worldInfo, EnumDifficulty newDifficulty) {
        WorldManager.adjustWorldForDifficulty((WorldServer)this, newDifficulty, false);
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onBlockTickIsAreaLoaded(WorldServer worldIn, BlockPos fromPos, BlockPos toPos) {
        Chunk chunk;
        int posX = fromPos.func_177958_n() + 8;
        int posZ = fromPos.func_177952_p() + 8;
        if (fromPos.equals((Object)toPos)) {
            posX = fromPos.func_177958_n();
            posZ = fromPos.func_177952_p();
        }
        return (chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(posX >> 4, posZ >> 4)) != null && ((ChunkBridge)chunk).bridge$areNeighborsLoaded();
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;updateTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V"))
    private void spongeBlockUpdateTick(Block block, net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, Random rand) {
        PhaseContext<?> context;
        IPhaseState phaseState;
        if (this.field_72999_e) {
            this.field_72999_e = false;
        }
        if ((phaseState = context.state).alreadyCapturingBlockTicks(context = PhaseTracker.getInstance().getCurrentContext()) || phaseState.ignoresBlockUpdateTick(context)) {
            block.func_180650_b(worldIn, pos, state, rand);
            return;
        }
        TrackingUtil.updateTickBlock(this, block, pos, state, rand);
    }

    @Redirect(method={"updateBlockTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/NextTickListEntry;setPriority(I)V"))
    private void onCreateScheduledBlockUpdate(NextTickListEntry sbu, int priority) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> phaseState = phaseTracker.getCurrentState();
        if (phaseState.ignoresScheduledUpdates()) {
            this.impl$tmpScheduledObj = sbu;
            return;
        }
        sbu.func_82753_a(priority);
        ((NextTickListEntryBridge)sbu).bridge$setWorld((net.minecraft.world.World)((WorldServer)this));
        this.impl$tmpScheduledObj = sbu;
    }

    @Override
    @Overwrite
    public void func_72939_s() {
        TrackingUtil.tickWorldProvider(this);
        super.func_72939_s();
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;updateTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V"))
    private void onUpdateTick(Block block, net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, Random rand) {
        PhaseContext<?> context;
        IPhaseState phaseState = context.state;
        context = PhaseTracker.getInstance().getCurrentContext();
        if (phaseState.alreadyCapturingBlockTicks(context) || phaseState.ignoresBlockUpdateTick(context)) {
            block.func_180650_b(worldIn, pos, state, rand);
            return;
        }
        TrackingUtil.updateTickBlock(this, block, pos, state, rand);
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReportCategory;addBlockInfo(Lnet/minecraft/crash/CrashReportCategory;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V"))
    private void onBlockInfo(CrashReportCategory category, BlockPos pos, IBlockState state) {
        try {
            CrashReportCategory.func_175750_a((CrashReportCategory)category, (BlockPos)pos, (IBlockState)state);
        }
        catch (NoClassDefFoundError e) {
            SpongeImpl.getLogger().error("An error occurred while adding crash report info!", (Throwable)e);
            SpongeImpl.getLogger().error("Original caught error:", category.field_85078_a.field_71511_b);
            throw new ReportedException(category.field_85078_a);
        }
    }

    @Redirect(method={"addBlockEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer$ServerBlockEventList;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddBlockEvent(WorldServer.ServerBlockEventList list, Object obj, BlockPos pos, Block blockIn, int eventId, int eventParam) {
        BlockEventData blockEventData = (BlockEventData)obj;
        BlockEventDataBridge blockEvent = (BlockEventDataBridge)blockEventData;
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState phaseState = currentContext.state;
        if (phaseState.ignoresBlockEvent()) {
            return list.add((Object)blockEventData);
        }
        if (((BlockBridge)blockIn).bridge$shouldFireBlockEvents()) {
            blockEvent.bridge$setSourceUser(currentContext.getActiveUser());
            if (SpongeImplHooks.hasBlockTileEntity(blockIn, this.func_180495_p(pos))) {
                blockEvent.bridge$setTileEntity((org.spongepowered.api.block.tileentity.TileEntity)this.func_175625_s(pos));
            }
            if (blockEvent.bridge$getTileEntity() == null) {
                LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((World)((Object)this)).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)this.func_180495_p(pos)).build();
                blockEvent.bridge$setTickingLocatable(locatable);
            }
        }
        if (!((BlockBridge)blockIn).bridge$shouldFireBlockEvents()) {
            return list.add((Object)((BlockEventData)obj));
        }
        if (phaseState.doesBulkBlockCapture(currentContext) && currentContext.getCapturedBlockSupplier().trackEvent(pos, blockEventData)) {
            return true;
        }
        try (Object context = ((PhaseContext)BlockPhase.State.BLOCK_EVENT_QUEUE.createPhaseContext()).source(blockEvent);){
            ((PhaseContext)context).buildAndSwitch();
            phaseState.appendNotifierToBlockEvent(currentContext, (PhaseContext<?>)context, this, pos, blockEvent);
            if (ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
                if (blockIn instanceof BlockPistonBase) {
                    if (SpongeCommonEventFactory.handlePistonEvent(this, list, obj, pos, blockIn, eventId, eventParam)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    BlockPos notificationPos;
                    LocatableSnapshot notifySource = null;
                    if (!((BlockBridge)blockIn).bridge$isVanilla() && currentContext.getNeighborNotificationSource() != null) {
                        notifySource = currentContext.getNeighborNotificationSource();
                    }
                    BlockPos blockPos = notificationPos = notifySource != null ? VecHelper.toBlockPos(notifySource.getLocation().get()) : pos;
                    if (SpongeCommonEventFactory.callChangeBlockEventPre(this, notificationPos).isCancelled()) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = list.add((Object)blockEventData);
            return bl;
        }
    }

    @Redirect(method={"sendQueuedBlockEvents"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;fireBlockEvent(Lnet/minecraft/block/BlockEventData;)Z"))
    private boolean onFireBlockEvent(WorldServer worldIn, BlockEventData event) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> phaseState = phaseTracker.getCurrentState();
        if (phaseState.ignoresBlockEvent()) {
            return this.func_147485_a(event);
        }
        return TrackingUtil.fireMinecraftBlockEvent(worldIn, event);
    }

    @Override
    @Nullable
    protected TileEntity getTileEntityForRemoval(net.minecraft.world.World thisWorld, BlockPos pos) {
        if (this.bridge$isFake()) {
            return super.getTileEntityForRemoval(thisWorld, pos);
        }
        TileEntity tileEntity = this.proxyBlockAccess.func_175625_s(pos);
        if (tileEntity == null && !this.proxyBlockAccess.isTileEntityRemoved(pos)) {
            tileEntity = SpongeImplHooks.onChunkGetTileDuringRemoval((WorldServer)this, pos);
        }
        PhaseTracker tracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = tracker.getCurrentState();
        PhaseContext<?> currentContext = tracker.getCurrentContext();
        if (!(ShouldFire.CHANGE_BLOCK_EVENT && currentState.doesBulkBlockCapture(currentContext) && currentState.tracksTileEntityChanges(currentContext))) {
            return tileEntity;
        }
        if (tileEntity != null) {
            ((TileEntityBridge)tileEntity).bridge$setCaptured(true);
            currentContext.getCapturedBlockSupplier().logTileChange(this, pos, tileEntity, null);
        }
        return tileEntity;
    }

    @Override
    protected void onCheckTileEntityForRemoval(BlockPos pos, CallbackInfo ci, @Nullable TileEntity foundTile, net.minecraft.world.World thisWorld, BlockPos samePos) {
        if (PhaseTracker.getInstance().getCurrentState().isRestoring()) {
            return;
        }
        if (foundTile != null) {
            if (((TileEntityBridge)foundTile).bridge$isCaptured()) {
                ci.cancel();
            }
            if (this.proxyBlockAccess.isTileQueuedForRemoval(pos, foundTile)) {
                ci.cancel();
            }
        } else if (!this.proxyBlockAccess.getQueuedTiles(pos).isEmpty()) {
            ci.cancel();
        } else if (this.proxyBlockAccess.isTileEntityRemoved(pos)) {
            ci.cancel();
        }
    }

    @Override
    protected boolean onSetTileEntityForCapture(TileEntity newTile, BlockPos pos, TileEntity sameEntity) {
        TileEntity currentTile;
        if (this.bridge$isFake()) {
            return newTile.func_145837_r();
        }
        PhaseTracker tracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = tracker.getCurrentState();
        PhaseContext<?> currentContext = tracker.getCurrentContext();
        TileEntityBridge mixinTile = (TileEntityBridge)newTile;
        if (mixinTile.bridge$isCaptured()) {
            if (this.proxyBlockAccess.hasTileEntity(pos, newTile) && !this.proxyBlockAccess.isTileQueuedForRemoval(pos, newTile)) {
                return true;
            }
        } else if (this.proxyBlockAccess.hasTileEntity(pos, newTile)) {
            if (this.proxyBlockAccess.succeededInAdding(pos, newTile)) {
                this.func_175700_a(newTile);
            }
            return true;
        }
        if (!(ShouldFire.CHANGE_BLOCK_EVENT && currentState.doesBulkBlockCapture(currentContext) && currentState.tracksTileEntityChanges(currentContext))) {
            return newTile.func_145837_r();
        }
        if (!mixinTile.bridge$isCaptured()) {
            mixinTile.bridge$setCaptured(true);
        }
        if ((currentTile = this.getProcessingTileFromProxy(pos)) == null && !this.proxyBlockAccess.isTileEntityRemoved(pos)) {
            currentTile = this.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        newTile.func_174878_a(pos);
        if (newTile.func_145831_w() != (WorldServer)this) {
            newTile.func_145834_a((net.minecraft.world.World)((WorldServer)this));
        }
        currentContext.getCapturedBlockSupplier().logTileChange(this, pos, currentTile, newTile);
        return true;
    }

    @Override
    protected boolean isTileMarkedForRemoval(BlockPos pos) {
        return this.proxyBlockAccess.isTileEntityRemoved(pos);
    }

    @Override
    TileEntity impl$getTileOrNullIfMarkedForRemoval(Chunk chunk, BlockPos pos, Chunk.EnumCreateEntityType creationMode) {
        if (this.bridge$isFake()) {
            return super.impl$getTileOrNullIfMarkedForRemoval(chunk, pos, creationMode);
        }
        if (this.proxyBlockAccess.hasTileEntity(pos)) {
            return this.proxyBlockAccess.func_175625_s(pos);
        }
        return super.impl$getTileOrNullIfMarkedForRemoval(chunk, pos, creationMode);
    }

    @Override
    @Nullable
    protected TileEntity getProcessingTileFromProxy(BlockPos pos) {
        return this.proxyBlockAccess.func_175625_s(pos);
    }

    @Override
    @Nullable
    protected TileEntity getQueuedRemovedTileFromProxy(BlockPos pos) {
        return this.proxyBlockAccess.getQueuedTileForRemoval(pos);
    }

    @Override
    public void bridge$doChunkGC() {
        ++this.impl$chunkGCTickCount;
        if (this.impl$chunkLoadCount >= this.impl$chunkGCLoadThreshold && this.impl$chunkGCLoadThreshold > 0) {
            this.impl$chunkLoadCount = 0;
        } else if (this.impl$chunkGCTickCount >= this.impl$chunkGCTickInterval && this.impl$chunkGCTickInterval > 0) {
            this.impl$chunkGCTickCount = 0;
        } else {
            return;
        }
        ChunkProviderServer chunkProviderServer = this.func_72863_F();
        for (Chunk chunk : chunkProviderServer.func_189548_a()) {
            ChunkBridge spongeChunk = (ChunkBridge)chunk;
            if (chunk.field_189550_d || spongeChunk.bridge$isPersistedChunk() || !this.field_73011_w.func_186056_c(chunk.field_76635_g, chunk.field_76647_h) || ((PlayerChunkMapBridge)this.func_184164_w()).bridge$isChunkInUse(chunk.field_76635_g, chunk.field_76647_h)) continue;
            chunkProviderServer.func_189549_a(chunk);
            SpongeHooks.logChunkGCQueueUnload((WorldServer)this, chunk);
        }
    }

    @Inject(method={"saveLevel"}, at={@At(value="HEAD")})
    private void onSaveLevel(CallbackInfo ci) {
        for (WorldServer worldServer : this.field_73061_a.field_71305_c) {
            worldServer.field_73011_w.func_186057_q();
        }
    }

    @Overwrite
    public void func_73044_a(boolean all, @Nullable IProgressUpdate progressCallback) throws MinecraftException {
        ChunkProviderServer chunkproviderserver = this.func_72863_F();
        if (chunkproviderserver.func_73157_c()) {
            Cause currentCause = Sponge.getCauseStackManager().getCurrentCause();
            Sponge.getEventManager().post(SpongeEventFactory.createSaveWorldEventPre(currentCause, (World)((Object)this)));
            if (progressCallback != null) {
                progressCallback.func_73720_a("Saving level");
            }
            this.func_73042_a();
            if (progressCallback != null) {
                progressCallback.func_73719_c("Saving chunks");
            }
            chunkproviderserver.func_186027_a(all);
            Sponge.getEventManager().post(SpongeEventFactory.createSaveWorldEventPost(currentCause, (World)((Object)this)));
            if (this.impl$chunkGCTickInterval > 0) {
                return;
            }
            for (Chunk chunk : Lists.newArrayList((Iterable)chunkproviderserver.func_189548_a())) {
                if (chunk == null || this.field_73063_M.func_152621_a(chunk.field_76635_g, chunk.field_76647_h)) continue;
                chunkproviderserver.func_189549_a(chunk);
            }
        }
    }

    @Redirect(method={"sendQueuedBlockEvents"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"), expect=0, require=0)
    private int onGetDimensionIdForBlockEvents(DimensionType dimensionType) {
        return this.bridge$getDimensionId();
    }

    @Redirect(method={"updateAllPlayersSleepingFlag()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isSpectator()Z"))
    private boolean isSpectatorOrIgnored(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return ignore || entityPlayer.func_175149_v();
    }

    @Redirect(method={"areAllPlayersAsleep()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isPlayerFullyAsleep()Z"))
    private boolean isPlayerFullyAsleep(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return ignore || entityPlayer.func_71026_bH();
    }

    @Redirect(method={"areAllPlayersAsleep()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;isSpectator()Z"))
    private boolean isSpectatorAndNotIgnored(EntityPlayer entityPlayer) {
        boolean ignore = entityPlayer instanceof Player && ((Player)entityPlayer).isSleepingIgnored();
        return !ignore && entityPlayer.func_175149_v();
    }

    @Redirect(method={"addWeatherEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"), expect=0, require=0)
    private int getDimensionIdForWeatherEffect(DimensionType id) {
        return this.bridge$getDimensionId();
    }

    @Final
    @Inject(method={"loadEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void spongeLoadEntities(Collection<? extends net.minecraft.entity.Entity> entities, CallbackInfo callbackInfo) {
        if (entities.isEmpty()) {
            callbackInfo.cancel();
            return;
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (net.minecraft.entity.Entity entity : entities) {
            if (!((BlockPosBridge)entity.func_180425_c()).bridge$isValidXZPosition() || entity.field_70163_u < 0.0) {
                entity.func_70106_y();
                continue;
            }
            if (!this.func_184165_i(entity)) continue;
            entityList.add((Entity)entity);
        }
        Throwable throwable = null;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CHUNK_LOAD);
            frame.pushCause(this);
            SpawnEntityEvent.ChunkLoad chunkLoad = SpongeEventFactory.createSpawnEntityEventChunkLoad(Sponge.getCauseStackManager().getCurrentCause(), Lists.newArrayList(entityList));
            SpongeImpl.postEvent(chunkLoad);
            if (!chunkLoad.isCancelled() && !chunkLoad.getEntities().isEmpty()) {
                for (Entity successful : chunkLoad.getEntities()) {
                    this.field_72996_f.add((net.minecraft.entity.Entity)successful);
                    this.func_72923_a((net.minecraft.entity.Entity)successful);
                }
            }
            for (Entity entity : entityList) {
                if (chunkLoad.getEntities().contains(entity)) continue;
                ((net.minecraft.world.World)this).func_72973_f((net.minecraft.entity.Entity)entity);
            }
            callbackInfo.cancel();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    @Override
    public Explosion bridge$triggerInternalExplosion(org.spongepowered.api.world.explosion.Explosion explosion, Function<? super Explosion, ? extends PhaseContext<?>> contextCreator) {
        Explosion mcExplosion;
        Explosion originalExplosion = (Explosion)explosion;
        ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(Sponge.getCauseStackManager().getCurrentCause(), explosion, (World)((Object)this));
        if (SpongeImpl.postEvent(event)) {
            return (Explosion)explosion;
        }
        explosion = event.getExplosion();
        try {
            mcExplosion = (Explosion)explosion;
        }
        catch (Exception e) {
            new PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add(e).trace();
            return originalExplosion;
        }
        try (Object ignored = contextCreator.apply((Explosion)mcExplosion).source(explosion.getSourceExplosive().orElse((Explosive)((Object)this)));){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean damagesTerrain = explosion.shouldBreakBlocks();
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(false);
            if (!damagesTerrain) {
                mcExplosion.func_180342_d();
            }
            for (EntityPlayer playerEntity : this.field_73010_i) {
                Vec3d knockback = (Vec3d)mcExplosion.func_77277_b().get(playerEntity);
                if (knockback == null) continue;
                ((EntityPlayerMP)playerEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(playerEntity.func_145782_y(), knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c));
            }
        }
        return mcExplosion;
    }

    @Override
    public boolean func_72838_d(net.minecraft.entity.Entity entity) {
        if (PhaseTracker.isEntitySpawnInvalid((Entity)entity)) {
            return true;
        }
        return this.func_184165_i(entity) && PhaseTracker.getInstance().spawnEntity((WorldServer)this, entity);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (!this.func_175701_a(pos)) {
            return false;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        return PhaseTracker.getInstance().setBlockState(this, pos.func_185334_h(), newState, BlockChangeFlagRegistryModule.fromNativeInt(flags));
    }

    @Override
    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        IBlockState iblockstate = this.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre(this, pos).isCancelled()) {
            return false;
        }
        this.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        if (dropBlock) {
            BlockPos previousPos;
            PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
            IPhaseState<?> state = PhaseTracker.getInstance().getCurrentState();
            boolean isCapturingBlockDrops = state.alreadyProcessingBlockItemDrops();
            if (isCapturingBlockDrops) {
                previousPos = context.getCaptureBlockPos().getPos().orElse(null);
                context.getCaptureBlockPos().setPos(pos);
            } else {
                previousPos = null;
            }
            block.func_176226_b((net.minecraft.world.World)((WorldServer)this), pos, iblockstate, 0);
            if (isCapturingBlockDrops) {
                context.getCaptureBlockPos().setPos(previousPos);
            }
        }
        if (!this.func_175701_a(pos)) {
            return false;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        return PhaseTracker.getInstance().setBlockState(this, pos.func_185334_h(), Blocks.field_150350_a.func_176223_P(), BlockChangeFlags.ALL);
    }

    @Override
    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos otherPos) {
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(otherPos.func_177958_n() >> 4, otherPos.func_177952_p() >> 4);
        if (chunk == null) {
            return;
        }
        Block used = PhaseTracker.validateBlockForNeighborNotification((WorldServer)this, pos, blockIn, otherPos, chunk);
        PhaseTracker.getInstance().notifyBlockOfStateChange(this, this.func_180495_p(pos), pos, used, otherPos);
    }

    @Override
    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        if (this.isChunkAvailable(pos)) {
            return;
        }
        if (ShouldFire.NOTIFY_NEIGHBOR_BLOCK_EVENT) {
            EnumSet<EnumFacing[]> directions = EnumSet.of(EnumFacing.WEST, new EnumFacing[]{EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH});
            directions.remove(skipSide);
            this.throwNotifyNeighborAndCall(pos, blockType, directions);
            return;
        }
        for (EnumFacing direction : Constants.World.NOTIFY_DIRECTIONS) {
            if (direction == skipSide) continue;
            BlockPos offset = pos.func_177972_a(direction);
            Chunk chunk = this.func_175726_f(pos);
            Block used = PhaseTracker.validateBlockForNeighborNotification((WorldServer)this, pos, blockType, offset, chunk);
            PhaseTracker.getInstance().notifyBlockOfStateChange(this, this.func_180495_p(offset), offset, used, pos);
        }
    }

    @Override
    public void func_175685_c(BlockPos sourcePos, Block sourceBlock, boolean updateObserverBlocks) {
        if (this.isChunkAvailable(sourcePos)) {
            return;
        }
        if (ShouldFire.NOTIFY_NEIGHBOR_BLOCK_EVENT) {
            this.throwNotifyNeighborAndCall(sourcePos, sourceBlock, Constants.World.NOTIFY_DIRECTION_SET);
        } else {
            for (EnumFacing direction : Constants.World.NOTIFY_DIRECTIONS) {
                BlockPos notifyPos = sourcePos.func_177972_a(direction);
                Chunk chunk = this.func_175726_f(sourcePos);
                Block used = PhaseTracker.validateBlockForNeighborNotification((WorldServer)this, sourcePos, sourceBlock, notifyPos, chunk);
                PhaseTracker.getInstance().notifyBlockOfStateChange(this, this.func_180495_p(notifyPos), notifyPos, used, sourcePos);
            }
        }
        if (updateObserverBlocks) {
            this.func_190522_c(sourcePos, sourceBlock);
        }
    }

    private void throwNotifyNeighborAndCall(BlockPos sourcePos, Block sourceBlock, EnumSet<EnumFacing> notifyDirectionSet) {
        NotifyNeighborBlockEvent event = SpongeCommonEventFactory.callNotifyNeighborEvent((World)((Object)this), sourcePos, notifyDirectionSet);
        if (event == null || !event.isCancelled()) {
            for (EnumFacing facing : Constants.World.NOTIFY_DIRECTIONS) {
                if (event != null) {
                    Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
                    if (!event.getNeighbors().keySet().contains((Object)direction)) continue;
                }
                BlockPos notifyPos = sourcePos.func_177972_a(facing);
                Chunk chunk = this.func_175726_f(sourcePos);
                Block used = PhaseTracker.validateBlockForNeighborNotification((WorldServer)this, sourcePos, sourceBlock, notifyPos, chunk);
                PhaseTracker.getInstance().notifyBlockOfStateChange(this, this.func_180495_p(notifyPos), notifyPos, used, sourcePos);
            }
        }
    }

    private boolean isChunkAvailable(BlockPos sourcePos) {
        if (!this.func_175701_a(sourcePos)) {
            return true;
        }
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(sourcePos.func_177958_n() >> 4, sourcePos.func_177952_p() >> 4);
        return chunk == null;
    }

    @Override
    public void onDestroyBlock(BlockPos pos, boolean dropBlock, CallbackInfoReturnable<Boolean> cir) {
        if (SpongeCommonEventFactory.callChangeBlockEventPre(this, pos).isCancelled()) {
            cir.setReturnValue(false);
        }
    }

    @Override
    protected void onUpdateWeatherEffect(net.minecraft.entity.Entity entityIn) {
        this.onCallEntityUpdate(entityIn);
    }

    @Override
    protected void onUpdateTileEntities(ITickable tile) {
        this.updateTileEntity(tile);
    }

    private void updateTileEntity(ITickable tile) {
        if (!SpongeImplHooks.shouldTickTile(tile)) {
            return;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingTileTicks()) {
            tile.func_73660_a();
            return;
        }
        TrackingUtil.tickTileEntity(this, tile);
    }

    @Override
    protected void onCallEntityUpdate(net.minecraft.entity.Entity entity) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingEntityTicks()) {
            entity.func_70071_h_();
            return;
        }
        TrackingUtil.tickEntity(entity);
        this.bridge$updateRotation(entity);
    }

    @Override
    protected void onCallEntityRidingUpdate(net.minecraft.entity.Entity entity) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> state = phaseTracker.getCurrentState();
        if (state.alreadyCapturingEntityTicks()) {
            entity.func_70098_U();
            return;
        }
        TrackingUtil.tickRidingEntity(entity);
        this.bridge$updateRotation(entity);
    }

    @Override
    public <T extends net.minecraft.entity.Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        PhaseContext<?> context;
        boolean isMainThread;
        double maxEntityRadius = SpongeImplHooks.getWorldMaxEntityRadius((WorldServer)this);
        int minChunkX = MathHelper.func_76128_c((double)((aabb.field_72340_a - maxEntityRadius) / 16.0));
        int maxChunkX = MathHelper.func_76143_f((double)((aabb.field_72336_d + maxEntityRadius) / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)((aabb.field_72339_c - maxEntityRadius) / 16.0));
        int maxChunkZ = MathHelper.func_76143_f((double)((aabb.field_72334_f + maxEntityRadius) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int currentX = minChunkX; currentX < maxChunkX; ++currentX) {
            for (int currentZ = minChunkZ; currentZ < maxChunkZ; ++currentZ) {
                if (!this.func_175680_a(currentX, currentZ, true)) continue;
                this.func_72964_e(currentX, currentZ).func_177430_a(clazz, aabb, (List)list, filter);
            }
        }
        boolean bl = isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (!isMainThread) {
            return list;
        }
        IPhaseState state = context.state;
        context = PhaseTracker.getInstance().getCurrentContext();
        if (state.doesCaptureEntityDrops(context) || state.doesAllowEntitySpawns()) {
            if (state.doesCaptureEntityDrops(context)) {
                for (EntityItem entityItem : context.getCapturedItems()) {
                    if (!clazz.isInstance(entityItem) || !entityItem.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)entityItem)) continue;
                    list.add(entityItem);
                }
            }
            if (state.doesCaptureEntitySpawns()) {
                for (Entity entity : context.getCapturedEntities()) {
                    if (!clazz.isInstance(entity) || !((net.minecraft.entity.Entity)entity).func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)((net.minecraft.entity.Entity)entity))) continue;
                    list.add((net.minecraft.entity.Entity)entity);
                }
                if (state.doesBulkBlockCapture(context)) {
                    for (net.minecraft.entity.Entity entity : context.getPerBlockEntitySpawnSuppplier().get().values()) {
                        if (!clazz.isInstance(entity) || !entity.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)entity)) continue;
                        list.add(entity);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public void bridge$addEntityRotationUpdate(net.minecraft.entity.Entity entity, Vector3d rotation) {
        this.impl$rotationUpdates.put(entity, rotation);
    }

    @Override
    public void bridge$updateRotation(net.minecraft.entity.Entity entityIn) {
        Vector3d rotationUpdate = this.impl$rotationUpdates.get(entityIn);
        if (rotationUpdate != null) {
            entityIn.field_70125_A = (float)rotationUpdate.getX();
            entityIn.field_70177_z = (float)rotationUpdate.getY();
        }
        this.impl$rotationUpdates.remove(entityIn);
    }

    @Inject(method={"onEntityAdded"}, at={@At(value="RETURN")})
    private void impl$entityAddedCallBridgeJoinWorld(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$onJoinWorld();
    }

    @Override
    public boolean bridge$forceSpawnEntity(net.minecraft.entity.Entity entity) {
        int x = entity.func_180425_c().func_177958_n();
        int z = entity.func_180425_c().func_177952_p();
        return this.impl$forceSpawnEntity(entity, x >> 4, z >> 4);
    }

    private boolean impl$forceSpawnEntity(net.minecraft.entity.Entity entity, int chunkX, int chunkZ) {
        if (!this.bridge$isFake() && SpongeImplHooks.isMainThread()) {
            SpongeHooks.logEntitySpawn(entity);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.field_73010_i.add(entityplayer);
            this.func_72854_c();
        }
        if (entity instanceof EntityLightningBolt) {
            this.func_72942_c(entity);
            return true;
        }
        this.func_72964_e(chunkX, chunkZ).func_76612_a(entity);
        this.field_72996_f.add(entity);
        this.func_72923_a(entity);
        return true;
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(BlockPos pos, BlockChangeFlag flag) {
        if (!this.func_175667_e(pos)) {
            return (SpongeBlockSnapshot)BlockSnapshot.NONE;
        }
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(chunkX, chunkZ);
        if (chunk == null) {
            return (SpongeBlockSnapshot)BlockSnapshot.NONE;
        }
        IBlockState blockState = chunk.func_177435_g(pos);
        builder.worldId(((World)((Object)this)).getUniqueId());
        builder.position(new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        builder.blockState(blockState);
        try {
            builder.extendedState(blockState.func_185899_b((IBlockAccess)((WorldServer)this), pos));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TileEntity existing = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (existing != null) {
            try {
                NBTTagCompound tileData = new NBTTagCompound();
                existing.func_189515_b(tileData);
                builder.unsafeNbt(tileData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((ChunkBridge)chunk).bridge$getBlockNotifier(pos).map(Identifiable::getUniqueId).ifPresent(builder::notifier);
        ((ChunkBridge)chunk).bridge$getBlockOwner(pos).map(Identifiable::getUniqueId).ifPresent(builder::creator);
        return builder.build();
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(IBlockState state, IBlockState extended, BlockPos pos, BlockChangeFlag updateFlag) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.reset();
        builder.blockState(state).extendedState(extended).worldId(((World)((Object)this)).getUniqueId()).position(VecHelper.toVector3i(pos));
        Chunk chunk = this.func_175726_f(pos);
        if (chunk == null) {
            SpongeBlockSnapshot build = builder.flag(updateFlag).build();
            builder.reset();
            return build;
        }
        Optional<UUID> creator = ((ChunkBridge)chunk).bridge$getBlockOwnerUUID(pos);
        Optional<UUID> notifier = ((ChunkBridge)chunk).bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        boolean hasTileEntity = SpongeImplHooks.hasBlockTileEntity(state.func_177230_c(), state);
        TileEntity tileEntity = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if ((hasTileEntity || tileEntity != null) && tileEntity != null) {
            for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)tileEntity).bridge$getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                tileEntity.func_189515_b(nbt);
                builder.unsafeNbt(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshotWithEntity(IBlockState state, BlockPos pos, BlockChangeFlag updateFlag, @Nullable TileEntity tileEntity) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.reset();
        builder.blockState(state).extendedState(state).worldId(((World)((Object)this)).getUniqueId()).position(VecHelper.toVector3i(pos));
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                tileEntity.func_189515_b(nbt);
                builder.unsafeNbt(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Overwrite
    public Explosion func_72885_a(@Nullable net.minecraft.entity.Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        Explosion explosion = new Explosion((net.minecraft.world.World)((WorldServer)this), entityIn, x, y, z, strength, isFlaming, isSmoking);
        explosion = this.bridge$triggerInternalExplosion((org.spongepowered.api.world.explosion.Explosion)explosion, e -> GeneralPhase.State.EXPLOSION.createPhaseContext().explosion((Explosion)e).potentialExplosionSource((WorldServer)this, entityIn));
        return explosion;
    }

    @Override
    public SpongeProxyBlockAccess bridge$getProxyAccess() {
        return this.proxyBlockAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBlockState func_180495_p(BlockPos pos) {
        boolean entered;
        if (((BlockPosBridge)pos).bridge$isInvalidYPosition()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        boolean forceChunkRequests = ((ChunkProviderServerBridge)this.func_72863_F()).bridge$getForceChunkRequests();
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        boolean bl = entered = currentState == TickPhase.Tick.TILE_ENTITY;
        if (entered) {
            ((ChunkProviderServerBridge)this.func_72863_F()).bridge$setForceChunkRequests(true);
        }
        try {
            IBlockState blockState = this.proxyBlockAccess.func_180495_p(pos);
            if (blockState != null) {
                IBlockState iBlockState = blockState;
                return iBlockState;
            }
            Chunk chunk = this.func_175726_f(pos);
            IBlockState iBlockState = chunk.func_177435_g(pos);
            return iBlockState;
        }
        finally {
            if (entered) {
                ((ChunkProviderServerBridge)this.func_72863_F()).bridge$setForceChunkRequests(forceChunkRequests);
            }
        }
    }

    @Override
    public boolean spongeIsAreaLoadedForCheckingLight(net.minecraft.world.World thisWorld, BlockPos pos, int radius, boolean allowEmtpy, EnumSkyBlock lightType, BlockPos samePosition) {
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return chunk != null && ((ChunkBridge)chunk).bridge$areNeighborsLoaded();
    }

    @Override
    public int func_175699_k(BlockPos pos) {
        Chunk chunk;
        if (pos.func_177956_o() < 0) {
            return 0;
        }
        if (pos.func_177956_o() >= 256) {
            pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
        }
        return (chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) == null ? 0 : chunk.func_177443_a(pos, 0);
    }

    @Override
    public int func_175721_c(BlockPos pos, boolean checkNeighbors) {
        if (((BlockPosBridge)pos).bridge$isValidXZPosition()) {
            Chunk chunk;
            if (checkNeighbors && this.func_180495_p(pos).func_185916_f()) {
                int i1 = this.func_175721_c(pos.func_177984_a(), false);
                int i = this.func_175721_c(pos.func_177974_f(), false);
                int j = this.func_175721_c(pos.func_177976_e(), false);
                int k = this.func_175721_c(pos.func_177968_d(), false);
                int l = this.func_175721_c(pos.func_177978_c(), false);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return (chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) == null ? 0 : chunk.func_177443_a(pos, this.func_175657_ab());
        }
        return 15;
    }

    @Override
    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((BlockPosBridge)pos).bridge$isValidPosition()) {
            return type.field_77198_c;
        }
        Chunk chunk = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null) {
            return type.field_77198_c;
        }
        return chunk.func_177413_a(type, pos);
    }

    @Override
    public boolean bridge$isLightLevel(Chunk chunk, BlockPos pos, int level) {
        if (((BlockPosBridge)pos).bridge$isValidPosition()) {
            if (this.func_180495_p(pos).func_185916_f()) {
                if (this.func_175721_c(pos.func_177984_a(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177974_f(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177976_e(), false) >= level) {
                    return true;
                }
                if (this.func_175721_c(pos.func_177968_d(), false) >= level) {
                    return true;
                }
                return this.func_175721_c(pos.func_177978_c(), false) >= level;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return chunk.func_177443_a(pos, this.func_175657_ab()) >= level;
        }
        return true;
    }

    @Override
    protected void impl$useWorldServerMethodForAvoidingLookups(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty, CallbackInfoReturnable<Boolean> cir) {
        if (yEnd < 0 || yStart > 255) {
            cir.setReturnValue(false);
            return;
        }
        xEnd >>= 4;
        zEnd >>= 4;
        Chunk base = ((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(xStart >>= 4, zStart >>= 4);
        if (base == null) {
            cir.setReturnValue(false);
            return;
        }
        ChunkBridge currentColumn = (ChunkBridge)base;
        for (int i = xStart; i <= xEnd; ++i) {
            if (currentColumn == null) {
                cir.setReturnValue(false);
                return;
            }
            ChunkBridge currentRow = currentColumn;
            for (int j = zStart; j <= zEnd; ++j) {
                if (currentRow == null) {
                    cir.setReturnValue(false);
                    return;
                }
                if (!allowEmpty && ((Chunk)currentRow).func_76621_g()) {
                    cir.setReturnValue(false);
                    return;
                }
                currentRow = (ChunkBridge)currentRow.bridge$getNeighborChunk(1);
            }
            currentColumn = (ChunkBridge)currentColumn.bridge$getNeighborChunk(2);
        }
        cir.setReturnValue(true);
    }

    @Redirect(method={"canAddEntity"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void onCanAddEntityLogWarn(Logger logger, String message, Object param1, Object param2) {
    }

    @Overwrite
    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        ChunkBridge spongeChunk = (ChunkBridge)((ChunkProviderBridge)this.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(x, z);
        return spongeChunk != null && (!spongeChunk.bridge$isQueuedForUnload() || spongeChunk.bridge$isPersistedChunk());
    }

    @Override
    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        if (unusedTileEntity == null) {
            super.func_175646_b(pos, unusedTileEntity);
            return;
        }
        ChunkBridge chunk = ((ActiveChunkReferantBridge)unusedTileEntity).bridge$getActiveChunk();
        if (chunk != null) {
            chunk.bridge$markChunkDirty();
        }
    }

    @Override
    void impl$startEntityGlobalTimings(CallbackInfo ci) {
        this.impl$timings.entityTick.startTiming();
        TimingHistory.entityTicks += (long)this.field_72996_f.size();
    }

    @Override
    void impl$stopTimingForWeatherEntityTickCrash(CallbackInfo ci, int index, net.minecraft.entity.Entity entity, Throwable throwable) {
        ((TimingBridge)entity).bridge$getTimingsHandler().stopTiming();
    }

    @Override
    void impl$stopEntityTickTiming(CallbackInfo ci) {
        this.impl$timings.entityTick.stopTiming();
        this.impl$timings.entityRemoval.startTiming();
    }

    @Override
    void impl$stopEntityRemovalTiming(CallbackInfo ci) {
        this.impl$timings.entityRemoval.stopTiming();
    }

    @Override
    void impl$stopRemovalTimingAfterentityRemovals(CallbackInfo ci) {
        this.impl$timings.entityRemoval.stopTiming();
    }

    @Override
    void impl$startEntityTickingForTick(CallbackInfo ci) {
        this.impl$timings.entityTick.startTiming();
    }

    @Override
    void impl$stopEntityAndThrowInfo(CallbackInfo ci, int index, net.minecraft.entity.Entity ticking, @Nullable net.minecraft.entity.Entity riding, Throwable throwable) {
        ((TimingBridge)ticking).bridge$getTimingsHandler().stopTiming();
    }

    @Override
    void impl$startEntityRemovalTiming(CallbackInfo callbackInfo) {
        this.impl$timings.entityTick.stopTiming();
        this.impl$timings.entityRemoval.startTiming();
    }

    @Override
    void impl$startTileTickTimer(CallbackInfo ci) {
        this.impl$timings.tileEntityTick.startTiming();
    }

    @Override
    void impl$stopTileTickCrash(CallbackInfo ci, Iterator<TileEntity> iterator, TileEntity tickingTile, BlockPos pos, Throwable throwable) {
        ((TimingBridge)tickingTile).bridge$getTimingsHandler().stopTiming();
    }

    @Override
    void impl$stopTileTickCrash(CallbackInfo ci, Iterator<TileEntity> iterator, TileEntity tickingTile, Throwable throwable) {
        ((TimingBridge)tickingTile).bridge$getTimingsHandler().stopTiming();
    }

    @Override
    void impl$stopTileTickAndStartRemoval(CallbackInfo callbackInfo) {
        this.impl$timings.tileEntityTick.stopTiming();
        this.impl$timings.tileEntityRemoval.startTiming();
    }

    @Override
    boolean impl$stopTileRemovalTimingIfHasNext(Iterator<TileEntity> iterator) {
        this.impl$timings.tileEntityRemoval.stopTiming();
        return iterator.hasNext();
    }

    @Override
    void impl$startPendingBlockEntities(CallbackInfo callbackInfo) {
        this.impl$timings.tileEntityPending.startTiming();
    }

    @Override
    void impl$endPendingTileEntities(CallbackInfo ci) {
        this.impl$timings.tileEntityPending.stopTiming();
        TimingHistory.tileEntityTicks += (long)this.field_147482_g.size();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=tickPending"}, shift=At.Shift.AFTER)})
    private void onBeginTickBlockUpdate(CallbackInfo ci) {
        this.impl$timings.scheduledBlocks.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=tickBlocks"}, shift=At.Shift.AFTER)})
    private void onAfterTickBlockUpdate(CallbackInfo ci) {
        this.impl$timings.scheduledBlocks.stopTiming();
        this.impl$timings.updateBlocks.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=chunkMap"}, shift=At.Shift.AFTER)})
    private void onBeginUpdateBlocks(CallbackInfo ci) {
        this.impl$timings.updateBlocks.stopTiming();
        this.impl$timings.doChunkMap.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=village"}, shift=At.Shift.AFTER)})
    private void onBeginUpdateVillage(CallbackInfo ci) {
        this.impl$timings.doChunkMap.stopTiming();
        this.impl$timings.doVillages.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=portalForcer"}, shift=At.Shift.AFTER)})
    private void onBeginUpdatePortal(CallbackInfo ci) {
        this.impl$timings.doVillages.stopTiming();
        this.impl$timings.doPortalForcer.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endSection()V", shift=At.Shift.AFTER)})
    private void onEndUpdatePortal(CallbackInfo ci) {
        this.impl$timings.doPortalForcer.stopTiming();
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;add(III)Lnet/minecraft/util/math/BlockPos;"))
    private BlockPos redirectNeedlessBlockPosObjectCreation(BlockPos pos, int x, int y, int z) {
        return pos;
    }

    @Redirect(method={"tickUpdates"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;scheduleUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;I)V"))
    private void redirectDontRescheduleBlockUpdates(WorldServer worldServer, BlockPos pos, Block blockIn, int delay) {
    }

    @Inject(method={"tickUpdates"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", args={"ldc=cleaning"}, shift=At.Shift.AFTER)})
    private void onTickUpdatesCleanup(boolean flag, CallbackInfoReturnable<Boolean> cir) {
        this.impl$timings.scheduledBlocksCleanup.startTiming();
    }

    @Inject(method={"tickUpdates"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", args={"ldc=ticking"}, shift=At.Shift.BEFORE, by=2)})
    private void onTickUpdatesTickingStart(boolean flag, CallbackInfoReturnable<Boolean> cir) {
        this.impl$timings.scheduledBlocksCleanup.stopTiming();
        this.impl$timings.scheduledBlocksTicking.startTiming();
    }

    @Inject(method={"tickUpdates"}, at={@At(value="RETURN")})
    private void onTickUpdatesTickingEnd(CallbackInfoReturnable<Boolean> cir) {
        this.impl$timings.scheduledBlocksTicking.stopTiming();
    }

    @Override
    public WorldTimingsHandler bridge$getTimingsHandler() {
        return this.impl$timings;
    }

    @Inject(method={"updateWeather"}, at={@At(value="FIELD", target="Lnet/minecraft/world/WorldServer;prevRainingStrength:F")}, cancellable=true)
    private void onAccessPreviousRain(CallbackInfo ci) {
        Weather weather = ((World)((Object)this)).getWeather();
        int duration = (int)((World)((Object)this)).getRemainingDuration();
        if (!weather.equals(this.prevWeather) && duration > 0) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                ChangeWorldWeatherEvent event = SpongeEventFactory.createChangeWorldWeatherEvent(frame.getCurrentCause(), duration, duration, weather, weather, this.prevWeather, (World)((Object)this));
                if (Sponge.getEventManager().post(event)) {
                    ((World)((Object)this)).setWeather(this.prevWeather);
                    this.prevWeather = ((World)((Object)this)).getWeather();
                    ci.cancel();
                } else if (!weather.equals(event.getWeather()) || duration != event.getDuration()) {
                    ((World)((Object)this)).setWeather(event.getWeather(), event.getDuration());
                } else {
                    this.prevWeather = event.getWeather();
                }
            }
        }
    }

    @Override
    public void bridge$setPreviousWeather(Weather weather) {
        this.prevWeather = weather;
    }

    @Override
    public SpongeChunkGenerator bridge$getSpongeGenerator() {
        if (this.impl$spongegen == null) {
            this.impl$updateWorldGenerator();
        }
        return this.impl$spongegen;
    }

    @Override
    @Nullable
    public ScheduledBlockUpdate bridge$getScheduledBlockUpdate() {
        return (ScheduledBlockUpdate)this.impl$tmpScheduledObj;
    }

    @Override
    public void bridge$setScheduledBlockUpdate(@Nullable ScheduledBlockUpdate sbu) {
        this.impl$tmpScheduledObj = (NextTickListEntry)sbu;
    }

    @Override
    public int bridge$getChunkGCTickInterval() {
        return this.impl$chunkGCTickInterval;
    }

    @Override
    public long bridge$getChunkUnloadDelay() {
        return this.impl$chunkUnloadDelay;
    }

    private void setMemoryViewDistance(int viewDistance) {
        this.field_73063_M.func_152622_a(viewDistance);
    }

    private int chooseViewDistanceValue(int value) {
        if (value == -1) {
            return this.field_73061_a.func_184103_al().func_72395_o();
        }
        return value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Name", (Object)this.field_72986_A.func_76065_j()).add("DimensionId", this.bridge$getDimensionId()).add("DimensionType", (Object)((org.spongepowered.api.world.DimensionType)this.field_73011_w.func_186058_p()).getId()).toString();
    }

    @Override
    public long bridge$getWeatherStartTime() {
        return this.impl$weatherStartTime;
    }

    @Override
    public void bridge$setWeatherStartTime(long start) {
        this.impl$weatherStartTime = start;
    }
}

