/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.handler;

import java.io.IOException;
import java.lang.reflect.Constructor;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.common.mixin.handler.IExitHandler;

public final class TerminateVM
implements IExitHandler {
    public static void terminate(String masqueradePackage, int status) {
        Logger log = LogManager.getLogger((String)"Sponge");
        IExitHandler handler = null;
        try {
            MasqueradeClassLoader cl = new MasqueradeClassLoader(Launch.classLoader, masqueradePackage);
            Constructor<?> ctor = Class.forName(cl.getClassName(), true, cl).getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            handler = (IExitHandler)ctor.newInstance(new Object[0]);
        }
        catch (Throwable th) {
            log.catching(th);
            handler = new TerminateVM();
        }
        handler.exit(status);
    }

    @Override
    public void exit(int status) {
        TerminateVM.systemExit(status);
    }

    private static void systemExit(int status) {
        throw new IllegalStateException("Not transformed");
    }

    static class MasqueradeClassLoader
    extends ClassLoader {
        final LaunchClassLoader parent;
        final String className;
        final String classRef;

        MasqueradeClassLoader(LaunchClassLoader parent, String masqueradePackage) {
            super((ClassLoader)parent);
            this.parent = parent;
            this.className = masqueradePackage + ".TerminateVM";
            this.classRef = this.className.replace('.', '/');
        }

        String getClassName() {
            return this.className;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                if (this.className.equals(name)) {
                    ClassWriter cw = new ClassWriter(0);
                    ClassVisitor cv = new ClassVisitor(327680, cw){

                        @Override
                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            super.visit(version, access | 1, classRef, signature, superName, interfaces);
                        }

                        @Override
                        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                            if ("terminate".equals(name)) {
                                return null;
                            }
                            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
                            return new MethodVisitor(327680, mv){

                                @Override
                                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                                    if (owner.endsWith("TerminateVM")) {
                                        owner = classRef;
                                        if ("systemExit".equals(name)) {
                                            owner = System.class.getName().replace('.', '/');
                                            name = "exit";
                                        }
                                    }
                                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                                }
                            };
                        }
                    };
                    new ClassReader(this.parent.getClassBytes(TerminateVM.class.getName())).accept(cv, 0);
                    byte[] classBytes = cw.toByteArray();
                    return this.defineClass(this.className, classBytes, 0, classBytes.length, null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.parent.findClass(name);
        }
    }
}

