/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.mixin.handler.TerminateVM;

public class CorePlugin
implements IMixinConfigPlugin {
    private static final List<String> MUTABLE_BLOCK_POS_FIELDS = ImmutableList.builder().add((Object)"x:field_177997_b").add((Object)"y:field_177998_c").add((Object)"z:field_177996_d").build();
    private static final Map<String, Consumer<ClassNode>> INCOMPATIBILITY_DETECTION_ERRORS = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.core.util.math.BlockPos_MutableBlockPosMixin_Optional", targetClass -> {
        ArrayList<String> foundFields = new ArrayList<String>();
        block0: for (FieldNode field : targetClass.fields) {
            for (String fieldName : MUTABLE_BLOCK_POS_FIELDS) {
                for (String option : fieldName.split(":")) {
                    if (!field.name.equals(option)) continue;
                    foundFields.add(field.name);
                    continue block0;
                }
            }
        }
        if (foundFields.size() != MUTABLE_BLOCK_POS_FIELDS.size()) {
            CorePlugin.printFoamFixAndShutDown();
        }
    }).put((Object)"org.spongepowered.common.mixin.core.world.chunk.BlockStateContainerMixin", targetClass -> {
        boolean foundSize = false;
        block0: for (MethodNode method : targetClass.methods) {
            if (!"func_186018_a".equals(method.name) && !"getSerializedSize".equals(method.name)) continue;
            ListIterator<AbstractInsnNode> iterator = method.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = iterator.next();
                if (insnNode.getType() != 5) continue;
                MethodInsnNode methodInvoke = (MethodInsnNode)insnNode;
                if (!"net/minecraft/util/BitArray".equals(methodInvoke.owner) || !"func_188144_b".equals(methodInvoke.name) && !"size".equals(methodInvoke.name)) continue;
                foundSize = true;
                break block0;
            }
        }
        if (!foundSize) {
            CorePlugin.printFoamFixAndShutDown();
        }
    }).build();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Consumer<ClassNode> classNodeConsumer = INCOMPATIBILITY_DETECTION_ERRORS.get(mixinClassName);
        if (classNodeConsumer != null) {
            classNodeConsumer.accept(targetClass);
        }
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static void printFoamFixAndShutDown() {
        new PrettyPrinter(60).add("!!! FoamFix Incompatibility !!!").centre().hr().addWrapped("Hello! You are running SpongeForge and \"likely\" FoamFix on the same server, and we've discoverd a missing field that would otherwise cause some of Sponge not to work, because foamfix removes that field. As the issue stands, it's not possible to \"patch fix\", but we can suggest the configuration option change in foamfix's config to allow your game to start! Please change the following options in foamfix'es config.", new Object[0]).add().add("In config/foamfix.cfg, change these values: ").add("B:optimizedBlockPos=false").add("B:patchChunkSerialization=false").add().addWrapped("We at Sponge appreciate your patience as this can be frustrating when the game doesn't start right away, or that SpongeForge isn't an easy drop-in-and-get-running sometimes. Thank you for your consideration, and have a nice day!", new Object[0]).add().add(new IncompatibleClassChangeError("FoamFix Incompatibility Detected")).log(SpongeImpl.getLogger(), Level.FATAL);
        TerminateVM.terminate("net.minecraftforge.fml", 1);
    }
}

