/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.category.OptimizationCategory;
import org.spongepowered.common.config.type.GlobalConfig;

public class OptimizationPlugin
implements IMixinConfigPlugin {
    public static final Function<OptimizationCategory, Boolean> EIGEN_ONLY = optimization -> {
        if (optimization.usePandaRedstone() && optimization.useEigenRedstone()) {
            optimization.setPandaRedstone(false);
        }
        return optimization.useEigenRedstone() && !optimization.usePandaRedstone();
    };
    public static final Function<OptimizationCategory, Boolean> PANDA_ONLY = optimization -> {
        if (optimization.usePandaRedstone() && optimization.useEigenRedstone()) {
            SpongeImpl.getLogger().warn("Cannot enable both Panda Redstone and Eigen Redstone, use one or the other! Change optimizations.panda=true");
            optimization.setPandaRedstone(false);
        }
        return optimization.usePandaRedstone() && !optimization.useEigenRedstone();
    };
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.common.mixin.optimization.SpongeImplHooksMixin_Item_Pre_Merge", OptimizationCategory::doDropsPreMergeItemDrops).put((Object)"org.spongepowered.common.mixin.optimization.enchantment.EnchantmentHelperMixin_No_Source_Leak", OptimizationCategory::useEnchantmentHelperFix).put((Object)"org.spongepowered.common.mixin.optimization.block.BlockRedstoneWireMixin_Eigen", EIGEN_ONLY).put((Object)"org.spongepowered.common.mixin.optimization.block.BlockRedstoneWireAccessor_Eigen", EIGEN_ONLY).put((Object)"org.spongepowered.common.mixin.optimization.block.BlockRedstoneWireMixin_Panda", PANDA_ONLY).put((Object)"org.spongepowered.common.mixin.optimization.entity.EntityMixinTameable_Cached_Owner", OptimizationCategory::useCacheTameableOwners).put((Object)"org.spongepowered.common.mixin.optimization.network.play.server.SPacketChunkDataMixin_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.chunk.ChunkMixin_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.WorldServerMixin_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.gen.ChunkProviderServerMixin_Async_Lighting", OptimizationCategory::useAsyncLighting).put((Object)"org.spongepowered.common.mixin.optimization.world.gen.structure.MapGenStructureMixin_Structure_Saving", OptimizationCategory::useStructureSave).put((Object)"org.spongepowered.common.mixin.optimization.entity.item.EntityItemFrameMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.entity.EntityTrackerEntryMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.item.ItemMapMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.world.storage.MapDataMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.world.storage.MapInfoMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.server.MinecraftServerMixin_MapOptimization", OptimizationCategory::useMapOptimization).put((Object)"org.spongepowered.common.mixin.optimization.tileentity.TileEntityMixin_HopperOptimization", OptimizationCategory::isOptimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.tileentity.TileEntityHopperMixin_HopperOptimization", OptimizationCategory::isOptimizeHoppers).put((Object)"org.spongepowered.common.mixin.optimization.entity.EntityMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.world.WorldMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).put((Object)"org.spongepowered.common.mixin.optimization.world.WorldServerMixin_UseActiveChunkForCollisions", OptimizationCategory::isUseActiveChunkForCollisions).build();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        GlobalConfig globalConfig = SpongeImpl.getGlobalConfigAdapter().getConfig();
        if (globalConfig.getModules().useOptimizations()) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.getOptimizations());
        }
        return false;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

