/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.tileentityactivation;

import com.flowpowered.math.vector.Vector3i;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.TileEntityActivationCategory;
import org.spongepowered.common.config.category.TileEntityActivationModCategory;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.mixin.core.server.management.PlayerChunkMapAccessor;
import org.spongepowered.common.mixin.core.server.management.PlayerchunkMapEntryAccessor;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.ActivationCapability;
import org.spongepowered.common.util.VecHelper;

public class TileEntityActivation {
    public static void initializeTileEntityActivationState(TileEntity tileEntity) {
        if (tileEntity.func_145831_w() == null || tileEntity.func_145831_w().field_72995_K || !(tileEntity instanceof ITickable)) {
            return;
        }
        TileEntityActivationCategory tileEntityActCat = ((WorldInfoBridge)tileEntity.func_145831_w().func_72912_H()).bridge$getConfigAdapter().getConfig().getTileEntityActivationRange();
        TileEntityType type = ((org.spongepowered.api.block.tileentity.TileEntity)tileEntity).getType();
        ActivationCapability spongeTileEntity = (ActivationCapability)tileEntity;
        SpongeTileEntityType spongeType = (SpongeTileEntityType)type;
        if (spongeType == null || spongeType.getModId() == null) {
            return;
        }
        TileEntityActivationModCategory tileEntityActModCat = tileEntityActCat.getModList().get(spongeType.getModId().toLowerCase());
        int defaultActivationRange = tileEntityActCat.getDefaultBlockRange();
        int defaultTickRate = tileEntityActCat.getDefaultTickRate();
        if (tileEntityActModCat == null) {
            spongeTileEntity.activation$setActivationRange(defaultActivationRange);
            spongeTileEntity.activation$setSpongeTickRate(defaultTickRate);
            if (defaultTickRate <= 0) {
                spongeTileEntity.activation$setDefaultActivationState(false);
            }
            if (defaultActivationRange > 0) {
                spongeTileEntity.activation$setDefaultActivationState(false);
            }
        } else {
            if (!tileEntityActModCat.isEnabled()) {
                spongeTileEntity.activation$setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = tileEntityActModCat.getDefaultBlockRange();
            Integer tileEntityActivationRange = tileEntityActModCat.getTileEntityRangeList().get(type.getName().toLowerCase());
            if (defaultModActivationRange != null && tileEntityActivationRange == null) {
                spongeTileEntity.activation$setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeTileEntity.activation$setDefaultActivationState(false);
                }
            } else if (tileEntityActivationRange != null) {
                spongeTileEntity.activation$setActivationRange(tileEntityActivationRange);
                if (tileEntityActivationRange > 0) {
                    spongeTileEntity.activation$setDefaultActivationState(false);
                }
            }
            Integer defaultModTickRate = tileEntityActModCat.getDefaultTickRate();
            Integer tileEntityTickRate = tileEntityActModCat.getTileEntityTickRateList().get(type.getName().toLowerCase());
            if (defaultModTickRate != null && tileEntityTickRate == null) {
                spongeTileEntity.activation$setSpongeTickRate(defaultModTickRate);
                if (defaultModTickRate <= 0) {
                    spongeTileEntity.activation$setDefaultActivationState(false);
                }
            } else if (tileEntityTickRate != null) {
                spongeTileEntity.activation$setSpongeTickRate(tileEntityTickRate);
                if (tileEntityTickRate <= 0) {
                    spongeTileEntity.activation$setDefaultActivationState(false);
                }
            }
        }
    }

    public static void activateTileEntities(WorldServer world) {
        PlayerChunkMap playerChunkMap = world.func_184164_w();
        for (PlayerChunkMapEntry playerChunkMapEntry : ((PlayerChunkMapAccessor)playerChunkMap).accessor$getEntries()) {
            for (EntityPlayer entityPlayer : ((PlayerchunkMapEntryAccessor)playerChunkMapEntry).accessor$getPlayers()) {
                Chunk chunk = ((PlayerchunkMapEntryAccessor)playerChunkMapEntry).accessor$getChunk();
                if (chunk == null || chunk.field_189550_d || ((ChunkBridge)chunk).bridge$isPersistedChunk()) continue;
                TileEntityActivation.activateChunkTileEntities(entityPlayer, chunk);
            }
        }
    }

    private static void activateChunkTileEntities(EntityPlayer player, Chunk chunk) {
        Vector3i playerPos = VecHelper.toVector3i(player.func_180425_c());
        long currentTick = SpongeImpl.getServer().func_71259_af();
        for (Map.Entry mapEntry : chunk.func_177434_r().entrySet()) {
            TileEntity tileEntity = (TileEntity)mapEntry.getValue();
            ActivationCapability spongeTileEntity = (ActivationCapability)tileEntity;
            if (spongeTileEntity.activation$getSpongeTickRate() <= 0 || !((TileEntityBridge)tileEntity).bridge$shouldTick() || !(tileEntity instanceof ITickable) || spongeTileEntity.activation$getActivatedTick() == currentTick) continue;
            Vector3i tilePos = VecHelper.toVector3i(tileEntity.func_174877_v());
            if (currentTick <= ((ActivationCapability)tileEntity).activation$getActivatedTick()) continue;
            if (spongeTileEntity.activation$getDefaultActivationState()) {
                ((ActivationCapability)tileEntity).activation$setActivatedTick(currentTick);
                continue;
            }
            if (spongeTileEntity.activation$requiresActivationCacheRefresh()) {
                TileEntityActivation.initializeTileEntityActivationState(tileEntity);
                spongeTileEntity.activation$requiresActivationCacheRefresh(false);
            }
            int bbActivationRange = ((ActivationCapability)tileEntity).activation$getActivationRange();
            int blockDistance = Math.round(tilePos.distance(playerPos));
            if (blockDistance > bbActivationRange) continue;
            ((ActivationCapability)tileEntity).activation$setActivatedTick(currentTick);
        }
    }

    public static boolean checkIfActive(TileEntity tileEntity) {
        boolean isActive;
        if (tileEntity.func_145831_w() == null || tileEntity.func_145831_w().field_72995_K || !(tileEntity instanceof ITickable)) {
            return true;
        }
        World world = tileEntity.func_145831_w();
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)tileEntity).bridge$getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.bridge$isActive()) {
            return false;
        }
        long currentTick = SpongeImpl.getServer().func_71259_af();
        ActivationCapability spongeTileEntity = (ActivationCapability)tileEntity;
        boolean bl = isActive = activeChunk.bridge$isPersistedChunk() || spongeTileEntity.activation$getActivatedTick() >= currentTick || spongeTileEntity.activation$getDefaultActivationState();
        if (!isActive && spongeTileEntity.activation$getActivatedTick() == Integer.MIN_VALUE) {
            return false;
        }
        if (isActive && world.func_72912_H().func_82573_f() % (long)spongeTileEntity.activation$getSpongeTickRate() != 0L) {
            isActive = false;
        }
        return isActive;
    }

    public static void addTileEntityToConfig(World world, SpongeTileEntityType type) {
        SpongeConfig<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        if (!worldConfigAdapter.getConfig().getTileEntityActivationRange().autoPopulateData()) {
            return;
        }
        boolean requiresSave = false;
        String tileModId = type.getModId().toLowerCase();
        TileEntityActivationCategory activationCategory = globalConfigAdapter.getConfig().getTileEntityActivationRange();
        TileEntityActivationModCategory tileEntityMod = activationCategory.getModList().get(tileModId);
        int defaultRange = activationCategory.getDefaultBlockRange();
        int defaultTickRate = activationCategory.getDefaultTickRate();
        if (tileEntityMod == null) {
            tileEntityMod = new TileEntityActivationModCategory(tileModId);
            activationCategory.getModList().put(tileModId, tileEntityMod);
            requiresSave = true;
        }
        if (tileEntityMod != null) {
            Integer tileEntityActivationTickRate;
            Integer modDefaultTickRate;
            String tileId = type.getName().toLowerCase();
            Integer tileEntityActivationRange = tileEntityMod.getTileEntityRangeList().get(tileId);
            Integer modDefaultRange = tileEntityMod.getDefaultBlockRange();
            if (modDefaultRange == null) {
                modDefaultRange = defaultRange;
            }
            if (tileEntityActivationRange == null) {
                tileEntityMod.getTileEntityRangeList().put(tileId, modDefaultRange);
                requiresSave = true;
            }
            if ((modDefaultTickRate = tileEntityMod.getDefaultTickRate()) == null) {
                modDefaultTickRate = defaultTickRate;
            }
            if ((tileEntityActivationTickRate = tileEntityMod.getTileEntityTickRateList().get(tileId)) == null) {
                tileEntityMod.getTileEntityTickRateList().put(tileId, modDefaultTickRate);
                requiresSave = true;
            }
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }
}

