/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.EntityEquipmentSlot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeEquipmentType;
import org.spongepowered.common.data.type.SpongeHeldEquipmentType;
import org.spongepowered.common.data.type.SpongeWornEquipmentType;

public class EquipmentTypeRegistryModule
implements CatalogRegistryModule<EquipmentType> {
    @RegisterCatalog(value=EquipmentTypes.class)
    private final Map<String, EquipmentType> equipmentTypeMap = new HashMap<String, EquipmentType>();

    @Override
    public Optional<EquipmentType> getById(String id) {
        return Optional.ofNullable(this.equipmentTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<EquipmentType> getAll() {
        return ImmutableList.copyOf(this.equipmentTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.registerType("any");
        this.registerType("equipped");
        SpongeWornEquipmentType head = this.registerWornType("head", EntityEquipmentSlot.HEAD);
        this.equipmentTypeMap.put("headwear", head);
        this.registerWornType("chestplate", EntityEquipmentSlot.CHEST);
        this.registerWornType("leggings", EntityEquipmentSlot.LEGS);
        this.registerWornType("boots", EntityEquipmentSlot.FEET);
        this.registerWornType("worn", EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET);
        this.registerHeldType("main_hand", EntityEquipmentSlot.MAINHAND);
        this.registerHeldType("off_hand", EntityEquipmentSlot.OFFHAND);
        this.registerHeldType("held", EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND);
    }

    private void registerType(String id) {
        this.equipmentTypeMap.put(id, new SpongeEquipmentType(id, new EntityEquipmentSlot[0]));
    }

    private SpongeWornEquipmentType registerWornType(String id, EntityEquipmentSlot ... types) {
        SpongeWornEquipmentType newType = new SpongeWornEquipmentType(id, types);
        this.equipmentTypeMap.put(id, newType);
        return newType;
    }

    private void registerHeldType(String id, EntityEquipmentSlot ... types) {
        this.equipmentTypeMap.put(id, new SpongeHeldEquipmentType(id, types));
    }
}

