/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.common.bridge.world.WorldTypeBridge;
import org.spongepowered.common.mixin.core.world.WorldTypeAccessor;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=GeneratorTypes.class)
public final class GeneratorTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<GeneratorType>
implements SpongeAdditionalCatalogRegistryModule<GeneratorType>,
AlternateCatalogRegistryModule<GeneratorType> {
    public static GeneratorTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        for (WorldType worldType : WorldTypeAccessor.accessor$getWorldTypes()) {
            this.registerAdditionalCatalog((GeneratorType)worldType);
        }
        WorldType the_end = new WorldType(GeneratorTypeRegistryModule.getNextID(), "the_end");
        ((WorldTypeBridge)the_end).bridge$setChunkGenerator((world, options) -> new ChunkGeneratorEnd(world, true, world.func_72905_C(), new BlockPos(100, 50, 0)));
        ((WorldTypeBridge)the_end).bridge$setBiomeProvider(world -> new BiomeProviderSingle(Biomes.field_76779_k));
        ((WorldTypeAccessor)the_end).accessor$setHasInfoNotice(true);
        this.registerAdditionalCatalog((GeneratorType)the_end);
        WorldType nether = new WorldType(GeneratorTypeRegistryModule.getNextID(), "nether");
        ((WorldTypeAccessor)nether).accessor$setHasInfoNotice(true);
        ((WorldTypeBridge)nether).bridge$setBiomeProvider(world -> new BiomeProviderSingle(Biomes.field_76778_j));
        ((WorldTypeBridge)nether).bridge$setChunkGenerator((world, s) -> new ChunkGeneratorHell(world, world.func_72912_H().func_76089_r(), world.func_72905_C()));
        this.registerAdditionalCatalog((GeneratorType)nether);
        WorldType overworld = new WorldType(GeneratorTypeRegistryModule.getNextID(), "overworld");
        ((WorldTypeAccessor)overworld).accessor$setCanBeCreated(false);
        ((WorldTypeBridge)overworld).bridge$setBiomeProvider(world -> new BiomeProvider(world.func_72912_H()));
        ((WorldTypeBridge)overworld).bridge$setChunkGenerator((world, s) -> new ChunkGeneratorOverworld(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), s));
        this.registerAdditionalCatalog((GeneratorType)overworld);
    }

    @AdditionalRegistration(value=RegistrationPhase.PRE_REGISTRY)
    public void registerAdditional() {
        for (WorldType worldType : WorldTypeAccessor.accessor$getWorldTypes()) {
            if (worldType == null || this.catalogTypeMap.values().contains(worldType)) continue;
            this.catalogTypeMap.put(worldType.func_77127_a().toLowerCase(Locale.ENGLISH), (GeneratorType)worldType);
        }
        RegistryHelper.mapFields(GeneratorTypes.class, this.provideCatalogMap());
    }

    @Override
    public Map<String, GeneratorType> provideCatalogMap() {
        HashMap<String, GeneratorType> map = new HashMap<String, GeneratorType>();
        for (Map.Entry entry : this.catalogTypeMap.entrySet()) {
            String replace = ((String)entry.getKey()).replace("minecraft:", "").replace("sponge:", "").replace("debug_all_block_states", "debug");
            map.put(replace, (GeneratorType)entry.getValue());
        }
        return map;
    }

    private GeneratorTypeRegistryModule() {
        super("minecraft", new String[]{"minecraft", "sponge"}, id -> id.replace("debug_all_block_states", "debug"));
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(GeneratorType extraCatalog) {
        if (extraCatalog != null) {
            this.catalogTypeMap.put(extraCatalog.getId(), extraCatalog);
        }
    }

    private static int getNextID() {
        for (int x = 0; x < WorldTypeAccessor.accessor$getWorldTypes().length; ++x) {
            if (WorldTypeAccessor.accessor$getWorldTypes()[x] != null) continue;
            return x;
        }
        int oldLen = WorldTypeAccessor.accessor$getWorldTypes().length;
        WorldTypeAccessor.accessor$setWorldTypes(Arrays.copyOf(WorldTypeAccessor.accessor$getWorldTypes(), oldLen + 16));
        return oldLen;
    }

    private static final class Holder {
        static final GeneratorTypeRegistryModule INSTANCE = new GeneratorTypeRegistryModule();

        private Holder() {
        }

        static {
            try {
                Class.forName("net.minecraft.world.WorldType");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

