/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.serializer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.common.bridge.util.text.TextFormattingBridge;
import org.spongepowered.common.mixin.core.util.text.StyleAccessor;
import org.spongepowered.common.mixin.core.util.text.TextComponentStringAccessor;
import org.spongepowered.common.text.format.SpongeTextColor;

public final class LegacyTexts {
    private static final int FORMATTING_CODE_LENGTH = 2;
    private static final TextFormatting[] formatting = TextFormatting.values();
    private static final String LOOKUP;

    private LegacyTexts() {
    }

    public static int getFormattingCount() {
        return formatting.length;
    }

    public static int findFormat(char format) {
        int pos = LOOKUP.indexOf(format);
        if (pos == -1) {
            pos = LOOKUP.indexOf(Character.toLowerCase(format));
        }
        return pos;
    }

    public static boolean isFormat(char format) {
        return LegacyTexts.findFormat(format) != -1;
    }

    @Nullable
    public static TextFormatting parseFormat(char format) {
        int pos = LegacyTexts.findFormat(format);
        return pos != -1 ? formatting[pos] : null;
    }

    public static Text parse(String input, char code) {
        int pos = input.length();
        if (pos < 2) {
            return Text.of(input);
        }
        int next = input.lastIndexOf(code, pos - 2);
        if (next == -1) {
            return Text.of(input);
        }
        LiteralText.Builder current = null;
        boolean reset = false;
        ArrayList parts = Lists.newArrayList();
        do {
            TextFormatting format;
            if ((format = LegacyTexts.parseFormat(input.charAt(next + 1))) == null) continue;
            int from = next + 2;
            if (from != pos) {
                String content = input.substring(from, pos);
                if (current != null) {
                    if (reset) {
                        parts.add(current.build());
                        reset = false;
                        current = Text.builder(content);
                    } else {
                        current = Text.builder(content).append(current.build());
                    }
                } else {
                    current = Text.builder(content);
                }
            }
            if (current != null) {
                reset |= LegacyTexts.applyStyle(current, format);
            }
            pos = next;
        } while ((next = input.lastIndexOf(code, next - 1)) != -1);
        if (current == null) {
            if (pos == 0) {
                return Text.EMPTY;
            }
            return Text.of(input);
        }
        if (pos == 0 && parts.isEmpty()) {
            return current.build();
        }
        parts.add(current.build());
        Collections.reverse(parts);
        return ((LiteralText.Builder)Text.builder(pos > 0 ? input.substring(0, pos) : "").append((Collection)parts)).build();
    }

    private static boolean applyStyle(Text.Builder builder, TextFormatting formatting) {
        switch (formatting) {
            case BOLD: {
                builder.style(TextStyles.BOLD);
                break;
            }
            case ITALIC: {
                builder.style(TextStyles.ITALIC);
                break;
            }
            case UNDERLINE: {
                builder.style(TextStyles.UNDERLINE);
                break;
            }
            case STRIKETHROUGH: {
                builder.style(TextStyles.STRIKETHROUGH);
                break;
            }
            case OBFUSCATED: {
                builder.style(TextStyles.OBFUSCATED);
                break;
            }
            default: {
                if (builder.getColor() == TextColors.NONE) {
                    builder.color(SpongeTextColor.of(formatting));
                }
                return true;
            }
        }
        return false;
    }

    public static TextComponentString parseComponent(TextComponentString component, char code) {
        String text = component.func_150265_g();
        int next = text.lastIndexOf(code, text.length() - 2);
        ArrayList<TextComponentString> parsed = null;
        if (next >= 0) {
            parsed = new ArrayList<TextComponentString>();
            TextComponentString current = null;
            boolean reset = false;
            int pos = text.length();
            do {
                TextFormatting format;
                if ((format = LegacyTexts.parseFormat(text.charAt(next + 1))) == null) continue;
                int from = next + 2;
                if (from != pos) {
                    if (current != null) {
                        if (reset) {
                            parsed.add(current);
                            current.func_150256_b().func_150221_a(component.func_150256_b());
                            reset = false;
                            current = new TextComponentString("");
                        } else {
                            TextComponentString old = current;
                            current = new TextComponentString("");
                            current.func_150257_a((ITextComponent)old);
                        }
                    } else {
                        current = new TextComponentString("");
                    }
                    ((TextComponentStringAccessor)current).accessor$setText(text.substring(from, pos));
                } else if (current == null) {
                    current = new TextComponentString("");
                }
                reset |= LegacyTexts.applyStyle(current.func_150256_b(), format);
                pos = next;
            } while ((next = text.lastIndexOf(code, next - 1)) != -1);
            if (current != null) {
                parsed.add(current);
                current.func_150256_b().func_150221_a(component.func_150256_b());
            }
            Collections.reverse(parsed);
            String string = text = pos > 0 ? text.substring(0, pos) : "";
            if (component.func_150253_a().isEmpty()) {
                TextComponentString newComponent = new TextComponentString(text);
                newComponent.func_150253_a().addAll(parsed);
                newComponent.func_150255_a(component.func_150256_b());
                return newComponent;
            }
        } else if (component.func_150253_a().isEmpty()) {
            return component;
        }
        TextComponentString newComponent = new TextComponentString(text);
        if (parsed != null) {
            newComponent.func_150253_a().addAll(parsed);
        }
        newComponent.func_150255_a(component.func_150256_b());
        for (Object child : component.func_150253_a()) {
            child = child instanceof TextComponentString ? LegacyTexts.parseComponent((TextComponentString)child, code) : child.func_150259_f();
            newComponent.func_150257_a(child);
        }
        return newComponent;
    }

    private static boolean applyStyle(Style style, TextFormatting formatting) {
        switch (formatting) {
            case BOLD: {
                ((StyleAccessor)style).accessor$setBold(true);
                break;
            }
            case ITALIC: {
                ((StyleAccessor)style).accessor$setItalic(true);
                break;
            }
            case UNDERLINE: {
                ((StyleAccessor)style).accessor$setUnderlined(true);
                break;
            }
            case STRIKETHROUGH: {
                ((StyleAccessor)style).accessor$setStrikethrough(true);
                break;
            }
            case OBFUSCATED: {
                ((StyleAccessor)style).accessor$setObfuscated(true);
                break;
            }
            default: {
                if (((StyleAccessor)style).accessor$getColor() == null) {
                    ((StyleAccessor)style).accessor$setColor(formatting);
                }
                return true;
            }
        }
        return false;
    }

    public static String replace(String text, char from, char to) {
        int pos;
        int last = text.length() - 1;
        if (pos == -1 || pos == last) {
            return text;
        }
        char[] result = text.toCharArray();
        for (pos = text.indexOf(from); pos < last; ++pos) {
            if (result[pos] != from || !LegacyTexts.isFormat(result[pos + 1])) continue;
            result[pos] = to;
        }
        return new String(result);
    }

    public static String strip(String text, char code) {
        return LegacyTexts.strip(text, code, false, false);
    }

    public static String stripAll(String text, char code) {
        return LegacyTexts.strip(text, code, true, false);
    }

    public static String stripChars(String text, char code) {
        return LegacyTexts.strip(text, code, false, true);
    }

    private static String strip(String text, char code, boolean all, boolean keepFormat) {
        int next = text.indexOf(code);
        int last = text.length() - 1;
        if (next == -1 || next == last) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length());
        int pos = 0;
        do {
            if (pos != next) {
                result.append(text, pos, next);
            }
            pos = next;
            if (LegacyTexts.isFormat(text.charAt(next + 1))) {
                pos = next += keepFormat ? 1 : 2;
                continue;
            }
            if (all) {
                pos = ++next;
                continue;
            }
            ++next;
        } while ((next = text.indexOf(code, next)) != -1 && next < last);
        return result.append(text, pos, text.length()).toString();
    }

    static {
        char[] lookup = new char[formatting.length];
        for (int i = 0; i < formatting.length; ++i) {
            lookup[i] = ((TextFormattingBridge)formatting[i]).bridge$getFormattingCode();
        }
        LOOKUP = new String(lookup);
    }
}

