/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.common.block.SpongeTileEntityArchetype;
import org.spongepowered.common.entity.SpongeEntityArchetype;
import org.spongepowered.common.util.gen.ArrayImmutableBlockBuffer;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.util.gen.ByteArrayImmutableBiomeBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.extent.ExtentBufferUtil;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeArchetypeVolume;

public interface DefaultedExtent
extends Extent {
    @Override
    default public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        if (!this.containsBiome(newMin.getX(), newMin.getY(), newMin.getZ())) {
            throw new PositionOutOfBoundsException(newMin, this.getBiomeMin(), this.getBiomeMax());
        }
        if (!this.containsBiome(newMax.getX(), newMin.getY(), newMax.getZ())) {
            throw new PositionOutOfBoundsException(newMax, this.getBiomeMin(), this.getBiomeMax());
        }
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    default public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    default public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    default public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBiomeBuffer(GlobalPalette.getBiomePalette(), ExtentBufferUtil.copyToArray(this, this.getBiomeMin(), this.getBiomeMax(), this.getBiomeSize()), this.getBiomeMin(), this.getBiomeSize());
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    default public ImmutableBiomeVolume getImmutableBiomeCopy() {
        return ByteArrayImmutableBiomeBuffer.newWithoutArrayClone(ExtentBufferUtil.copyToArray(this, this.getBiomeMin(), this.getBiomeMax(), this.getBiomeSize()), this.getBiomeMin(), this.getBiomeSize());
    }

    @Override
    default public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        if (!this.containsBlock(newMin.getX(), newMin.getY(), newMin.getZ())) {
            throw new PositionOutOfBoundsException(newMin, this.getBlockMin(), this.getBlockMax());
        }
        if (!this.containsBlock(newMax.getX(), newMax.getY(), newMax.getZ())) {
            throw new PositionOutOfBoundsException(newMax, this.getBlockMin(), this.getBlockMax());
        }
        return new MutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    default public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform(this, transform);
    }

    @Override
    default public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper(this);
    }

    @Override
    default public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer(GlobalPalette.getBlockPalette(), this.getBlockMin(), this.getBlockSize(), ExtentBufferUtil.copyToArray(this, this.getBlockMin(), this.getBlockMax(), this.getBlockSize()));
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    default public ImmutableBlockVolume getImmutableBlockCopy() {
        char[] data = ExtentBufferUtil.copyToArray(this, this.getBlockMin(), this.getBlockMax(), this.getBlockSize());
        return ArrayImmutableBlockBuffer.newWithoutArrayClone(GlobalPalette.getBlockPalette(), this.getBlockMin(), this.getBlockSize(), data);
    }

    @Override
    default public MutableBiomeVolumeWorker<? extends Extent> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<DefaultedExtent>(this);
    }

    @Override
    default public MutableBlockVolumeWorker<? extends Extent> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<DefaultedExtent>(this);
    }

    @Override
    default public ArchetypeVolume createArchetypeVolume(Vector3i min, Vector3i max, Vector3i origin) {
        Vector3i tmin = min.min(max);
        Vector3i tmax = max.max(min);
        min = tmin;
        max = tmax;
        Extent volume = this.getExtentView(min, max);
        int ox = origin.getX();
        int oy = origin.getY();
        int oz = origin.getZ();
        ArrayMutableBlockBuffer backing = new ArrayMutableBlockBuffer(min.sub(origin), max.sub(min).add(1, 1, 1));
        HashMap tiles = Maps.newHashMap();
        volume.getBlockWorker().iterate((extent, x, y, z) -> {
            BlockState state = extent.getBlock(x, y, z);
            backing.setBlock(x - ox, y - oy, z - oz, state);
            Optional<TileEntity> tile = extent.getTileEntity(x, y, z);
            if (tile.isPresent()) {
                TileEntityArchetype archetype = tile.get().createArchetype();
                if (archetype instanceof SpongeTileEntityArchetype) {
                    int[] apos = new int[]{x - ox - tmin.getX(), y - tmin.getY(), z - oz - tmin.getZ()};
                    SpongeTileEntityArchetype sponge = (SpongeTileEntityArchetype)archetype;
                    sponge.getCompound().func_74783_a("Pos", apos);
                }
                tiles.put(new Vector3i(x - ox, y - oy, z - oz), archetype);
            }
        });
        if (backing.getBlockSize().equals(Vector3i.ONE)) {
            return new SpongeArchetypeVolume(backing, tiles, Collections.emptyList());
        }
        Set<Entity> intersectingEntities = volume.getIntersectingEntities(new AABB(min, max), (Entity entity) -> !(entity instanceof Player));
        if (intersectingEntities.isEmpty()) {
            return new SpongeArchetypeVolume(backing, tiles, Collections.emptyList());
        }
        ArrayList<EntityArchetype> entities = new ArrayList<EntityArchetype>();
        for (Entity hit : intersectingEntities) {
            net.minecraft.entity.Entity nms = (net.minecraft.entity.Entity)hit;
            SpongeEntityArchetype archetype = (SpongeEntityArchetype)hit.createArchetype();
            NBTTagList tagList = archetype.getData().func_150295_c("Pos", 6);
            if (tagList.func_82582_d()) {
                tagList.func_74742_a((NBTBase)new NBTTagDouble(nms.field_70165_t - (double)ox));
                tagList.func_74742_a((NBTBase)new NBTTagDouble(nms.field_70163_u - (double)oy));
                tagList.func_74742_a((NBTBase)new NBTTagDouble(nms.field_70161_v - (double)oz));
            } else {
                tagList.func_150304_a(0, (NBTBase)new NBTTagDouble(nms.field_70165_t - (double)ox));
                tagList.func_150304_a(1, (NBTBase)new NBTTagDouble(nms.field_70163_u - (double)oy));
                tagList.func_150304_a(2, (NBTBase)new NBTTagDouble(nms.field_70161_v - (double)oz));
            }
            entities.add(archetype);
        }
        return new SpongeArchetypeVolume(backing, tiles, entities);
    }
}

