/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.fluids;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.mod.mixin.core.forge.fluids.BlockFluidBaseMixin_Forge;

@Mixin(value={BlockFluidFinite.class})
public abstract class BlockFluidFiniteMixin_Forge
extends BlockFluidBaseMixin_Forge {
    @Override
    public BiConsumer<CauseStackManager.StackFrame, WorldServerBridge> bridge$getTickFrameModifier() {
        return (frame, world) -> frame.addContext(EventContextKeys.LIQUID_FLOW, (org.spongepowered.api.world.World)((Object)world));
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkBeforeTick(World world, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        if (!((WorldBridge)world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"tryToFlowVerticallyInto"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/World;getHeight()I"), to=@At(value="INVOKE", target="Lnet/minecraftforge/fluids/BlockFluidFinite;getQuantaValueBelow(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)I", remap=false))}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void setBlockToAirDueToWorldHeight(World world, BlockPos pos, int amtToInput, CallbackInfoReturnable<Integer> cir, IBlockState myState, BlockPos targetFlow) {
        if (!((WorldBridge)world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(world, pos, myState, Blocks.field_150350_a.func_176223_P()).isCancelled()) {
            cir.setReturnValue(0);
        }
    }

    @Inject(method={"tryToFlowVerticallyInto"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", remap=true)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraftforge/fluids/BlockFluidFinite;getQuantaValueBelow(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)I", remap=false), to=@At(value="INVOKE", target="Lnet/minecraftforge/fluids/BlockFluidFinite;getDensity(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", remap=false))}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true, constraints="FORGE(2821+)")
    private void setNewStateWithMaximumQuantaWhileFlowing(World world, BlockPos pos, int amtToInput, CallbackInfoReturnable<Integer> cir, IBlockState myState, BlockPos other, int newAmount) {
        if (((WorldBridge)world).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_PLACE) {
            return;
        }
        if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, other).isCancelled()) {
            cir.setReturnValue(0);
        }
    }

    @Inject(method={"tryToFlowVerticallyInto"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", shift=At.Shift.BY, by=2, slice="groupA"), @At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z", ordinal=0, slice="groupB")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, slice={@Slice(id="gropuB", from=@At(value="FIELD", target="Lnet/minecraftforge/fluids/BlockFluidFinite;density:I", ordinal=1, remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/block/Block;tickRate(Lnet/minecraft/world/World;)I", ordinal=1)), @Slice(id="groupA", from=@At(value="FIELD", target="Lnet/minecraftforge/fluids/BlockFluidFinite;density:I", ordinal=0, remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/block/Block;tickRate(Lnet/minecraft/world/World;)I", ordinal=0))}, constraints="FORGE(2821+)")
    private void onSetBlockForSwapping(World world, BlockPos myPos, int amtToInput, CallbackInfoReturnable<Integer> cir, IBlockState myState, BlockPos other, int amt, int density_other, IBlockState otherState) {
        if (((WorldBridge)world).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_MODIFY) {
            return;
        }
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        UUID worldId = ((org.spongepowered.api.world.World)world).getUniqueId();
        Vector3i myPosition = new Vector3i(myPos.func_177958_n(), myPos.func_177956_o(), myPos.func_177952_p());
        SpongeBlockSnapshot mySnapshot = builder.blockState(myState).worldId(worldId).position(myPosition).build();
        Vector3i otherPosition = new Vector3i(other.func_177958_n(), other.func_177956_o(), other.func_177952_p());
        SpongeBlockSnapshot otherSnapshot = builder.reset().blockState(otherState).worldId(worldId).position(otherPosition).build();
        IBlockState myNewState = myState.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(amtToInput - 1));
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
        currentContext.state.associateBlockChangeWithSnapshot(currentContext, myNewState, (Block)((BlockFluidFinite)this), otherState, otherSnapshot, otherState.func_177230_c());
        currentContext.state.associateBlockChangeWithSnapshot(currentContext, otherState, otherState.func_177230_c(), myState, mySnapshot, (Block)((BlockFluidFinite)this));
        Object source = currentContext.getSource();
        boolean pushSource = false;
        if (source == null) {
            pushSource = true;
            source = mySnapshot;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (!pushSource) {
                frame.pushCause(source);
            }
            frame.addContext(EventContextKeys.LIQUID_MIX, (org.spongepowered.api.world.World)world);
            SpongeBlockSnapshot otherReplacementSnapshot = builder.blockState(myNewState).build();
            SpongeBlockSnapshot ourReplacementSnapshot = builder.reset().blockState(otherState).worldId(worldId).position(myPosition).build();
            Transaction<SpongeBlockSnapshot> otherReplacement = new Transaction<SpongeBlockSnapshot>(otherSnapshot, otherReplacementSnapshot);
            Transaction<SpongeBlockSnapshot> ourReplacement = new Transaction<SpongeBlockSnapshot>(mySnapshot, ourReplacementSnapshot);
            ImmutableList transactions = ImmutableList.of(otherReplacement, ourReplacement);
            ChangeBlockEvent.Modify event = SpongeEventFactory.createChangeBlockEventModify(frame.getCurrentCause(), (List)transactions);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue(0);
            }
            if (otherReplacement.getCustom().isPresent() || ourReplacement.getCustom().isPresent()) {
                IBlockState otherReplacementState = (IBlockState)((BlockSnapshot)otherReplacement.getFinal()).getState();
                IBlockState myReplacementState = (IBlockState)((BlockSnapshot)ourReplacement.getFinal()).getState();
                world.func_175656_a(other, otherReplacementState);
                world.func_175656_a(myPos, myReplacementState);
                if (otherReplacementState == myNewState) {
                    world.func_175684_a(other, (Block)((BlockFluidFinite)this), this.tickRate);
                } else {
                    world.func_175684_a(other, otherReplacementState.func_177230_c(), otherReplacementState.func_177230_c().func_149738_a(world));
                }
                if (myReplacementState == otherState) {
                    world.func_175684_a(myPos, otherState.func_177230_c(), otherState.func_177230_c().func_149738_a(world));
                } else {
                    world.func_175684_a(myPos, myReplacementState.func_177230_c(), myReplacementState.func_177230_c().func_149738_a(world));
                }
                cir.setReturnValue(0);
            }
        }
    }
}

