/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.Locale;
import java.util.Random;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockEnderInhibitorOff;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderInhibitorOn
extends Block {
    public static final PropertyEnum<EnumGemDirection> TYPE = PropertyEnum.func_177709_a((String)"type", EnumGemDirection.class);

    public BlockEnderInhibitorOn() {
        super(Material.field_151594_q);
        this.func_149711_c(0.2f);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumGemDirection.DOWN_NORTH)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !(entity instanceof EntityWither) && !(entity instanceof EntityDragon);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch ((EnumGemDirection)((Object)state.func_177229_b(TYPE))) {
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.1875f;
                depthMin = 0.8125f;
                widthMax = 0.125f;
                heightMax = 0.1875f;
                depthMax = 0.0f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.1875f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.1875f;
                depthMax = 0.8125f;
                break;
            }
            case EAST: {
                widthMin = 0.8125f;
                heightMin = 0.1875f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.1875f;
                depthMax = 0.125f;
                break;
            }
            case WEST: {
                widthMin = 0.0f;
                heightMin = 0.1875f;
                depthMin = 0.125f;
                widthMax = 0.8125f;
                heightMax = 0.1875f;
                depthMax = 0.125f;
                break;
            }
            case UP_NORTH: {
                widthMin = 0.125f;
                heightMin = 0.8125f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.1875f;
                break;
            }
            case UP_EAST: {
                widthMin = 0.1875f;
                heightMin = 0.8125f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case UP_SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.8125f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.1875f;
                break;
            }
            case UP_WEST: {
                widthMin = 0.1875f;
                heightMin = 0.8125f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case DOWN_NORTH: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.8125f;
                depthMax = 0.1875f;
                break;
            }
            case DOWN_EAST: {
                widthMin = 0.1875f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.8125f;
                depthMax = 0.125f;
                break;
            }
            case DOWN_SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.1875f;
                widthMax = 0.125f;
                heightMax = 0.8125f;
                depthMax = 0.1875f;
                break;
            }
            case DOWN_WEST: {
                widthMin = 0.1875f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.1875f;
                heightMax = 0.8125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumGemDirection newFacing = (EnumGemDirection)((Object)state.func_177229_b(TYPE));
        boolean flag = false;
        if ((newFacing == EnumGemDirection.UP_NORTH || newFacing == EnumGemDirection.UP_EAST || newFacing == EnumGemDirection.UP_SOUTH || newFacing == EnumGemDirection.UP_WEST) && world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
            flag = true;
        }
        if ((newFacing == EnumGemDirection.DOWN_NORTH || newFacing == EnumGemDirection.DOWN_EAST || newFacing == EnumGemDirection.DOWN_SOUTH || newFacing == EnumGemDirection.DOWN_WEST) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.NORTH && world.isSideSolid(pos.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.SOUTH && world.isSideSolid(pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.WEST && world.isSideSolid(pos.func_177972_a(EnumFacing.WEST), EnumFacing.WEST)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.EAST && world.isSideSolid(pos.func_177972_a(EnumFacing.EAST), EnumFacing.EAST)) {
            flag = true;
        }
        if (!flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        IBlockState activeState = ModBlocks.ENDER_INHIBITOR_OFF.func_176223_P().func_177226_a((IProperty)BlockEnderInhibitorOff.TYPE, state.func_177229_b(TYPE));
        world.func_180501_a(pos, activeState, 3);
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockEnderInhibitorOn.canPlaceBlock(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockEnderInhibitorOn.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        return world.func_175677_d(blockpos, true) && block.func_149662_c(iblockstate) && flag;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int direction = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumGemDirection newFacing = EnumGemDirection.DOWN_NORTH;
        if (facing == EnumFacing.UP) {
            switch (direction) {
                case 0: {
                    newFacing = EnumGemDirection.DOWN_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumGemDirection.DOWN_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumGemDirection.DOWN_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumGemDirection.DOWN_WEST;
                }
            }
        } else if (facing == EnumFacing.DOWN) {
            switch (direction) {
                case 0: {
                    newFacing = EnumGemDirection.UP_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumGemDirection.UP_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumGemDirection.UP_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumGemDirection.UP_WEST;
                }
            }
        } else {
            switch (facing) {
                case SOUTH: {
                    newFacing = EnumGemDirection.NORTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.SOUTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.EAST;
                }
            }
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)newFacing));
    }

    public int func_180651_a(IBlockState state) {
        return EnumGemDirection.DOWN_NORTH.ordinal();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == MobGrindingUtils.TAB) {
            list.add((Object)new ItemStack((Block)this, 1, EnumGemDirection.DOWN_NORTH.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumGemDirection.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumGemDirection type = (EnumGemDirection)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public static enum EnumGemDirection implements IStringSerializable
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

