/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.keyboard;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerRegistry;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.module.BasicModuleHandler;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.gameplay.GuiHandler;
import org.squiddev.plethora.gameplay.ItemBase;
import org.squiddev.plethora.gameplay.keyboard.ServerKeyListener;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.TinySlot;

public class ItemKeyboard
extends ItemBase {
    public ItemKeyboard() {
        super("keyboard", 1);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return ItemKeyboard.onItemUse(player.func_184586_b(hand), world, player);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            TileEntity tile = world.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(hand);
            NBTTagCompound tag = stack.func_77978_p();
            if (tile instanceof TileComputerBase) {
                if (!((TileGeneric)tile).isUsable(player, true)) {
                    return EnumActionResult.FAIL;
                }
                if (tag == null) {
                    tag = new NBTTagCompound();
                    stack.func_77982_d(tag);
                }
                tag.func_74768_a("x", pos.func_177958_n());
                tag.func_74768_a("y", pos.func_177956_o());
                tag.func_74768_a("z", pos.func_177952_p());
                tag.func_74768_a("dim", world.field_73011_w.getDimension());
                tag.func_82580_o("session_id");
                tag.func_82580_o("instance_id");
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.plethora.keyboard.bound", new Object[0]), true);
            } else if (tag != null && tag.func_74764_b("x")) {
                tag.func_82580_o("x");
                tag.func_82580_o("y");
                tag.func_82580_o("z");
                tag.func_82580_o("dim");
                tag.func_82580_o("session_id");
                tag.func_82580_o("instance_id");
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.plethora.keyboard.cleared", new Object[0]), true);
            }
            if (tag != null && tag.func_82582_d()) {
                stack.func_77982_d(null);
            }
            player.field_71071_by.func_70296_d();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("x", 99)) {
            int session = ComputerCraft.serverComputerRegistry.getSessionID();
            boolean dirty = false;
            if (tag.func_74762_e("session_id") != session) {
                tag.func_74768_a("session_id", session);
                tag.func_82580_o("instance_id");
                dirty = true;
            }
            if (!tag.func_150297_b("instance_id", 99) || !ComputerCraft.serverComputerRegistry.contains(tag.func_74762_e("instance_id"))) {
                ServerComputer computer;
                TileEntity tile;
                WorldServer remote = DimensionManager.getWorld((int)tag.func_74762_e("dim"));
                BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                if (remote != null && remote.func_175667_e(pos) && (tile = remote.func_175625_s(pos)) instanceof TileComputerBase && (computer = ((TileComputerBase)tile).getServerComputer()) != null) {
                    tag.func_74768_a("instance_id", computer.getInstanceID());
                    dirty = true;
                }
            }
            if (dirty && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).field_71071_by.func_70296_d();
            }
        }
    }

    private static EnumActionResult onItemUse(ItemStack stack, World world, EntityPlayer player) {
        ServerComputer computer;
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("x", 99)) {
            computer = (ServerComputer)ItemKeyboard.getBlockComputer(ComputerCraft.serverComputerRegistry, tag);
        } else {
            TinySlot slot = NeuralHelpers.getSlot((EntityLivingBase)player);
            if (slot == null) {
                return EnumActionResult.FAIL;
            }
            computer = ItemComputerHandler.getServer(slot.getStack(), (EntityLivingBase)player, slot);
        }
        if (computer == null) {
            return EnumActionResult.FAIL;
        }
        GuiHandler.openKeyboard(player, world, computer);
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EnumActionResult result = ItemKeyboard.onItemUse(stack, world, player);
        return ActionResult.newResult((EnumActionResult)result, (Object)stack);
    }

    private static <T extends IComputer> T getBlockComputer(ComputerRegistry<T> registry, NBTTagCompound tag) {
        if (!tag.func_150297_b("session_id", 99) || !tag.func_150297_b("instance_id", 99)) {
            return null;
        }
        int instance = tag.func_74762_e("instance_id");
        return (T)registry.get(instance);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> out, ITooltipFlag flag) {
        super.func_77624_a(stack, world, out, flag);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("x", 99)) {
            ClientComputer computer = (ClientComputer)ItemKeyboard.getBlockComputer(ComputerCraft.clientComputerRegistry, tag);
            String position = tag.func_74762_e("x") + ", " + tag.func_74762_e("y") + ", " + tag.func_74762_e("z");
            out.add(Helpers.translateToLocalFormatted(computer != null ? "item.plethora.keyboard.binding" : "item.plethora.keyboard.broken", position));
        }
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return KeyboardModule.INSTANCE;
    }

    @SubscribeEvent
    public void onPlayerClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!Helpers.isHolding(event.getEntityLiving(), this)) {
            return;
        }
        if (!event.getEntityLiving().func_70093_af()) {
            event.setCanceled(true);
        }
    }

    private static final class KeyboardModule
    extends BasicModuleHandler {
        public static final KeyboardModule INSTANCE = new KeyboardModule();

        private KeyboardModule() {
            super(new ResourceLocation("plethora", "keyboard"), Registration.itemKeyboard);
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == Constants.MODULE_HANDLER_CAPABILITY;
        }

        @Override
        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            return (T)(capability == Constants.MODULE_HANDLER_CAPABILITY ? this : null);
        }

        @Override
        public void getAdditionalContext(final @Nonnull IModuleAccess access, @Nonnull IContextBuilder builder) {
            super.getAdditionalContext(access, builder);
            Object owner = access.getOwner();
            if (owner instanceof EntityPlayerMP) {
                final EntityPlayerMP player = (EntityPlayerMP)owner;
                builder.addAttachable(new IAttachable(){

                    @Override
                    public void attach() {
                        ServerKeyListener.add(player, access);
                    }

                    @Override
                    public void detach() {
                        ServerKeyListener.remove(player, access);
                    }
                });
            }
        }
    }
}

