/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;

@Injects
public final class MetaFluidStack
extends BasicMetaProvider<FluidStack> {
    public MetaFluidStack() {
        super("Provides information about a fluid, as well as how much is currently stored.");
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull FluidStack fluidStack) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("amount", fluidStack.amount);
        Fluid fluid = fluidStack.getFluid();
        if (fluid != null) {
            data.put("name", fluid.getName());
            data.put("id", FluidRegistry.getDefaultFluidName((Fluid)fluid));
            data.put("rawName", fluid.getUnlocalizedName(fluidStack));
            data.put("displayName", fluid.getLocalizedName(fluidStack));
        }
        return data;
    }

    @Override
    @Nullable
    public FluidStack getExample() {
        return FluidRegistry.getFluidStack((String)"water", (int)525);
    }
}

