/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.ITransferMethod;
import org.squiddev.plethora.api.method.MarkerInterfaces;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public final class MethodsFluidTransfer {
    private MethodsFluidTransfer() {
    }

    @PlethoraMethod(doc="-- Push fluid from this tank to another tank. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static int pushFluid(IContext<IFluidHandler> context, String toName, @Optional(defInt=0x7FFFFFFF) int limit, Fluid fluid) throws LuaException {
        IFluidHandler from = (IFluidHandler)context.getTarget();
        Object location = context.getTransferLocation(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IFluidHandler to = MethodsFluidTransfer.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an tank");
        }
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? MethodsFluidTransfer.moveFluid(from, limit, to) : MethodsFluidTransfer.moveFluid(from, new FluidStack(fluid, limit), to);
    }

    @PlethoraMethod(doc="-- Pull fluid to this tank from another tank. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static int pullFluid(IContext<IFluidHandler> context, String fromName, @Optional(defInt=0x7FFFFFFF) int limit, @Optional Fluid fluid) throws LuaException {
        IFluidHandler to = (IFluidHandler)context.getTarget();
        Object location = context.getTransferLocation(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IFluidHandler from = MethodsFluidTransfer.extractHandler(location);
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? MethodsFluidTransfer.moveFluid(from, limit, to) : MethodsFluidTransfer.moveFluid(from, new FluidStack(fluid, limit), to);
    }

    @Nullable
    private static IFluidHandler extractHandler(@Nonnull Object object) {
        for (Object child : PlethoraAPI.instance().converterRegistry().convertAll(object)) {
            if (child instanceof IFluidHandler) {
                return (IFluidHandler)child;
            }
            if (!(object instanceof ICapabilityProvider)) continue;
            IFluidHandler handler = (IFluidHandler)((ICapabilityProvider)object).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (handler != null) {
                return handler;
            }
            handler = (IFluidHandler)((ICapabilityProvider)object).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private static int moveFluid(IFluidHandler from, int limit, IFluidHandler to) {
        return MethodsFluidTransfer.moveFluid(from, from.drain(limit, false), limit, to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack fluid, IFluidHandler to) {
        return MethodsFluidTransfer.moveFluid(from, from.drain(fluid, false), fluid.amount, to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack extracted, int limit, IFluidHandler to) {
        if (extracted == null || extracted.amount <= 0) {
            return 0;
        }
        extracted = extracted.copy();
        extracted.amount = Math.min(extracted.amount, limit);
        int inserted = to.fill(extracted, true);
        if (inserted <= 0) {
            return 0;
        }
        extracted.amount = inserted;
        from.drain(extracted, true);
        return inserted;
    }
}

