/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public final class WorldPosition {
    private final int dimension;
    private WeakReference<World> world;
    private final Vec3d pos;

    public WorldPosition(@Nonnull World world, @Nonnull Vec3d pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.dimension = world.field_73011_w.getDimension();
        this.world = new WeakReference<World>(world);
        this.pos = pos;
    }

    private WorldPosition(int dimension, @Nonnull Vec3d pos) {
        this.dimension = dimension;
        this.world = new WeakReference<Object>(null);
        this.pos = pos;
    }

    public WorldPosition(@Nonnull World world, @Nonnull BlockPos pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.dimension = world.field_73011_w.getDimension();
        this.world = new WeakReference<World>(world);
        this.pos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public WorldPosition(@Nonnull World world, double x, double y, double z) {
        this(world, new Vec3d(x, y, z));
    }

    @Nullable
    public World getWorld() {
        return (World)this.world.get();
    }

    @Nullable
    public World getWorld(MinecraftServer server) {
        World world = (World)this.world.get();
        if (world == null && DimensionManager.isDimensionRegistered((int)this.dimension)) {
            world = server.func_71218_a(this.dimension);
            this.world = new WeakReference<WorldServer>((WorldServer)world);
        }
        return world;
    }

    public int getDimension() {
        return this.dimension;
    }

    @Nonnull
    public Vec3d getPos() {
        return this.pos;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dim", this.dimension);
        tag.func_74780_a("x", this.pos.field_72450_a);
        tag.func_74780_a("y", this.pos.field_72448_b);
        tag.func_74780_a("z", this.pos.field_72449_c);
        return tag;
    }

    public static WorldPosition deserializeNBT(NBTTagCompound nbt) {
        return new WorldPosition(nbt.func_74762_e("dim"), new Vec3d(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z")));
    }
}

