/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RegionTeleportExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (src instanceof Player) {
            Player player = (Player)src;
            if (args.hasAny("name")) {
                Region region = RegionUtils.load((String)args.getOne("name").get());
                if (region != null && !region.getFlag(EnumRegionFlag.HIDE_REGION)) {
                    if (region.isLocal()) {
                        Region current = RegionUtils.getRegion((Location<World>)player.getLocation());
                        if (current != null && current.getFlag(EnumRegionFlag.EXIT) && region.getFlag(EnumRegionFlag.CAN_TP) && region.getFlag(EnumRegionFlag.ENTER)) {
                            player.setLocation(((LocalRegion)region).getTeleportLocation().getLocation());
                        } else if (!PermissionUtils.hasPermission(player, RegionPermission.REGION)) {
                            MessageUtils.sendErrorMessage(player, RegionText.REGION_NO_TP.getValue());
                        }
                    } else {
                        MessageUtils.sendErrorMessage(player, RegionText.REGION_LOCAL_ONLY.getValue());
                    }
                } else {
                    MessageUtils.sendErrorMessage(player, RegionText.REGION_NOT_FOUND.getValue());
                }
            } else {
                MessageUtils.sendErrorMessage(player, this.getCommandUsage());
            }
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg tp <name>";
    }
}

