/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.region;

import com.universeguard.region.Region;
import com.universeguard.region.components.RegionEffect;
import com.universeguard.region.components.RegionLocation;
import com.universeguard.region.components.RegionMember;
import com.universeguard.region.components.RegionValue;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.region.enums.RegionType;
import com.universeguard.utils.RegionUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.World;

public class LocalRegion
extends Region {
    private RegionLocation FIRST_POINT;
    private RegionLocation SECOND_POINT;
    private int PRIORITY;
    private RegionLocation TELEPORT_LOCATION;
    private RegionLocation SPAWN_LOCATION;
    private ArrayList<RegionMember> MEMBERS;
    private String FAREWELL_MESSAGE;
    private String GREETING_MESSAGE;
    private ArrayList<RegionEffect> EFFECTS;
    private boolean SOLD;
    private RegionValue VALUE;

    public LocalRegion(String name) {
        this(name, null, null, false);
    }

    public LocalRegion(String name, RegionLocation firstPoint, RegionLocation secondPoint, boolean template) {
        super(RegionType.LOCAL, name, template);
        this.FIRST_POINT = firstPoint;
        this.SECOND_POINT = secondPoint;
        this.PRIORITY = 0;
        this.TELEPORT_LOCATION = firstPoint;
        this.SPAWN_LOCATION = secondPoint;
        this.MEMBERS = new ArrayList();
        this.FAREWELL_MESSAGE = "";
        this.GREETING_MESSAGE = "";
        this.EFFECTS = new ArrayList();
        this.SOLD = false;
    }

    public void setFirstPoint(RegionLocation location) {
        this.FIRST_POINT = location;
    }

    public RegionLocation getFirstPoint() {
        return this.FIRST_POINT;
    }

    public void setSecondPoint(RegionLocation location) {
        this.SECOND_POINT = location;
    }

    public RegionLocation getSecondPoint() {
        return this.SECOND_POINT;
    }

    public void setTeleportLocation(RegionLocation location) {
        this.TELEPORT_LOCATION = location;
    }

    public RegionLocation getTeleportLocation() {
        return this.TELEPORT_LOCATION == null ? this.FIRST_POINT : this.TELEPORT_LOCATION;
    }

    public void setSpawnLocation(RegionLocation location) {
        this.SPAWN_LOCATION = location;
    }

    public RegionLocation getSpawnLocation() {
        return this.SPAWN_LOCATION == null ? this.SECOND_POINT : this.SPAWN_LOCATION;
    }

    public int getPriority() {
        return this.PRIORITY;
    }

    public void setPriority(int priority) {
        this.PRIORITY = priority;
    }

    public void setMembers(ArrayList<RegionMember> members) {
        this.MEMBERS = members;
    }

    public ArrayList<RegionMember> getMembers() {
        return this.MEMBERS;
    }

    public void addMemberByUUID(UUID player, RegionRole role) {
        this.addMember(RegionUtils.getPlayer(player), role);
    }

    public void addMember(Player player, RegionRole role) {
        this.MEMBERS.add(new RegionMember(player, role));
    }

    public void addMemberByUUIDAndUsername(UUID player, String username, RegionRole role) {
        this.MEMBERS.add(new RegionMember(player, username, role));
    }

    public void removeMemberByUUID(UUID player) {
        RegionMember toRemove = null;
        for (RegionMember member : this.MEMBERS) {
            if (!member.getUUID().equals(player)) continue;
            toRemove = member;
            break;
        }
        if (toRemove != null) {
            this.MEMBERS.remove(toRemove);
        }
    }

    public void removeMember(Player player) {
        this.removeMemberByUUID(player.getUniqueId());
    }

    public void setFarewellMessage(String message) {
        this.FAREWELL_MESSAGE = message;
    }

    public String getFarewellMessage() {
        return this.FAREWELL_MESSAGE;
    }

    public void setGreetingMessage(String message) {
        this.GREETING_MESSAGE = message;
    }

    public String getGreetingMessage() {
        return this.GREETING_MESSAGE;
    }

    public void setEffects(ArrayList<RegionEffect> effects) {
        this.EFFECTS = effects;
    }

    public ArrayList<RegionEffect> getEffects() {
        return this.EFFECTS;
    }

    public void addEffect(PotionEffectType potion, int level) {
        boolean found = false;
        for (RegionEffect effect : this.EFFECTS) {
            if (!effect.getEffect().equals(potion)) continue;
            effect.setLevel(level);
            found = true;
            break;
        }
        if (!found) {
            this.EFFECTS.add(new RegionEffect(potion, level));
        }
    }

    public void removeEffect(PotionEffectType potion) {
        RegionEffect effectToRemove = null;
        for (RegionEffect effect : this.EFFECTS) {
            if (!effect.getEffect().equals(potion)) continue;
            effectToRemove = effect;
            break;
        }
        if (effectToRemove != null) {
            this.EFFECTS.remove(effectToRemove);
        }
    }

    public void setSold(boolean sold) {
        this.SOLD = sold;
    }

    public boolean getSold() {
        return this.SOLD;
    }

    public void setValue(RegionValue value) {
        this.VALUE = value;
    }

    public RegionValue getValue() {
        return this.VALUE;
    }

    public World getWorld() {
        return this.FIRST_POINT != null && Sponge.getServer().getWorld(this.FIRST_POINT.getWorld()).isPresent() ? (World)Sponge.getServer().getWorld(this.FIRST_POINT.getWorld()).get() : null;
    }
}

