/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import com.universeguard.UniverseGuard;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionExplosion;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.EnumRegionInteract;
import com.universeguard.region.enums.EnumRegionVehicle;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.format.TextColors;

public class FlagUtils {
    public static void setDefaultValues(CommentedConfigurationNode configNode) {
        for (EnumRegionFlag enumRegionFlag : EnumRegionFlag.values()) {
            if (!configNode.getNode(new Object[]{"flags", enumRegionFlag.getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"flags", enumRegionFlag.getName()}).setValue((Object)enumRegionFlag.getValue());
        }
        for (Enum enum_ : EnumRegionInteract.values()) {
            if (!configNode.getNode(new Object[]{"interacts", ((EnumRegionInteract)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"interacts", ((EnumRegionInteract)enum_).getName()}).setValue((Object)((EnumRegionInteract)enum_).getValue());
        }
        for (Enum enum_ : EnumRegionVehicle.values()) {
            if (!configNode.getNode(new Object[]{"vehicleplace", ((EnumRegionVehicle)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"vehicleplace", ((EnumRegionVehicle)enum_).getName()}).setValue((Object)((EnumRegionVehicle)enum_).getPlace());
        }
        for (Enum enum_ : EnumRegionVehicle.values()) {
            if (!configNode.getNode(new Object[]{"vehicledestroy", ((EnumRegionVehicle)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"vehicledestroy", ((EnumRegionVehicle)enum_).getName()}).setValue((Object)((EnumRegionVehicle)enum_).getDestroy());
        }
        for (Enum enum_ : EnumRegionExplosion.values()) {
            if (!configNode.getNode(new Object[]{"explosiondamage", ((EnumRegionExplosion)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"explosiondamage", ((EnumRegionExplosion)enum_).getName()}).setValue((Object)((EnumRegionExplosion)enum_).getDamage());
        }
        for (Enum enum_ : EnumRegionExplosion.values()) {
            if (!configNode.getNode(new Object[]{"explosiondestroy", ((EnumRegionExplosion)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"explosiondestroy", ((EnumRegionExplosion)enum_).getName()}).setValue((Object)((EnumRegionExplosion)enum_).getDestroy());
        }
        if (configNode.getNode(new Object[]{"timers", "hunger"}).isVirtual()) {
            configNode.getNode(new Object[]{"timers", "hunger"}).setValue((Object)UniverseGuard.HUNGER_TIMER).setComment("The update frequency (in seconds) of the hunger flag timer");
        }
        if (configNode.getNode(new Object[]{"timers", "gamemode"}).isVirtual()) {
            configNode.getNode(new Object[]{"timers", "gamemode"}).setValue((Object)UniverseGuard.GAMEMODE_TIMER).setComment("The update frequency (in seconds) of the gamemode flag timer");
        }
        if (configNode.getNode(new Object[]{"timers", "enter_flag"}).isVirtual()) {
            configNode.getNode(new Object[]{"timers", "enter_flag"}).setValue((Object)UniverseGuard.ENTER_FLAG_TIMER).setComment("The update frequency (in milliseconds) of the enter flag timer");
        }
        if (configNode.getNode(new Object[]{"timers", "use_effects"}).isVirtual()) {
            configNode.getNode(new Object[]{"timers", "use_effects"}).setValue((Object)UniverseGuard.USE_EFFECTS).setComment("If Regions can have potion effects");
        }
        if (configNode.getNode(new Object[]{"timers", "effect"}).isVirtual()) {
            configNode.getNode(new Object[]{"timers", "effect"}).setValue((Object)UniverseGuard.EFFECT_TIMER).setComment("The update frequency (in milliseconds) of the effect timer");
        }
        if (configNode.getNode(new Object[]{"players", "unique_regions"}).isVirtual()) {
            configNode.getNode(new Object[]{"players", "unique_regions"}).setValue((Object)UniverseGuard.UNIQUE_REGIONS).setComment("Sets if players can be in more Regions");
        }
        if (configNode.getNode(new Object[]{"selector", "item"}).isVirtual()) {
            configNode.getNode(new Object[]{"selector", "item"}).setValue((Object)UniverseGuard.SELECTOR_ITEM.getId());
        }
        if (configNode.getNode(new Object[]{"regions", "limit_regions_size"}).isVirtual()) {
            configNode.getNode(new Object[]{"regions", "limit_regions_size"}).setValue((Object)UniverseGuard.LIMIT_REGIONS_SIZE).setComment("Sets if Regions must have a max size");
        }
        if (configNode.getNode(new Object[]{"regions", "max_region_size"}).isVirtual()) {
            configNode.getNode(new Object[]{"regions", "max_region_size"}).setValue((Object)UniverseGuard.MAX_REGION_SIZE).setComment("The max size a Region can be. This represents the distance between the first and the second point.");
        }
        if (configNode.getNode(new Object[]{"players", "limit_player_regions"}).isVirtual()) {
            configNode.getNode(new Object[]{"players", "limit_player_regions"}).setValue((Object)UniverseGuard.LIMIT_PLAYER_REGIONS).setComment("Sets if players can be in a max amount of Regions");
        }
        if (configNode.getNode(new Object[]{"players", "max_regions"}).isVirtual()) {
            configNode.getNode(new Object[]{"players", "max_regions"}).setValue((Object)UniverseGuard.MAX_REGIONS).setComment("The max number of Regions a player ca be member or owner");
        }
        for (Enum enum_ : RegionPermission.values()) {
            if (!configNode.getNode(new Object[]{"max_regions", ((RegionPermission)enum_).getName()}).isVirtual()) continue;
            configNode.getNode(new Object[]{"max_regions", ((RegionPermission)enum_).getName()}).setValue((Object)UniverseGuard.MAX_REGIONS);
        }
        if (configNode.getNode(new Object[]{"max_regions", "*"}).isVirtual()) {
            configNode.getNode(new Object[]{"max_regions", "*"}).setValue((Object)UniverseGuard.MAX_REGIONS);
        }
        if (configNode.getNode(new Object[]{"regions", "purchasable_regions"}).isVirtual()) {
            configNode.getNode(new Object[]{"regions", "purchasable_regions"}).setValue((Object)UniverseGuard.PURCHASABLE_REGIONS).setComment("Sets if Regions can be purchased");
        }
    }

    public static void getValues(Game game, CommentedConfigurationNode configNode) {
        for (EnumRegionFlag enumRegionFlag : EnumRegionFlag.values()) {
            enumRegionFlag.setValue(configNode.getNode(new Object[]{"flags", enumRegionFlag.getName()}).getBoolean());
        }
        for (Enum enum_ : EnumRegionInteract.values()) {
            ((EnumRegionInteract)enum_).setValue(configNode.getNode(new Object[]{"interacts", ((EnumRegionInteract)enum_).getName()}).getBoolean());
        }
        for (Enum enum_ : EnumRegionVehicle.values()) {
            ((EnumRegionVehicle)enum_).setPlace(configNode.getNode(new Object[]{"vehicleplace", ((EnumRegionVehicle)enum_).getName()}).getBoolean());
            ((EnumRegionVehicle)enum_).setDestroy(configNode.getNode(new Object[]{"vehicledestroy", ((EnumRegionVehicle)enum_).getName()}).getBoolean());
        }
        for (Enum enum_ : EnumRegionExplosion.values()) {
            ((EnumRegionExplosion)enum_).setDamage(configNode.getNode(new Object[]{"explosiondamage", ((EnumRegionExplosion)enum_).getName()}).getBoolean());
            ((EnumRegionExplosion)enum_).setDestroy(configNode.getNode(new Object[]{"explosiondestroy", ((EnumRegionExplosion)enum_).getName()}).getBoolean());
        }
        UniverseGuard.HUNGER_TIMER = configNode.getNode(new Object[]{"timers", "hunger"}).getInt();
        UniverseGuard.GAMEMODE_TIMER = configNode.getNode(new Object[]{"timers", "gamemode"}).getInt();
        UniverseGuard.ENTER_FLAG_TIMER = configNode.getNode(new Object[]{"timers", "enter_flag"}).getInt();
        UniverseGuard.USE_EFFECTS = configNode.getNode(new Object[]{"timers", "use_effects"}).getBoolean();
        UniverseGuard.EFFECT_TIMER = configNode.getNode(new Object[]{"timers", "effect"}).getInt();
        UniverseGuard.UNIQUE_REGIONS = configNode.getNode(new Object[]{"players", "unique_regions"}).getBoolean();
        UniverseGuard.PURCHASABLE_REGIONS = configNode.getNode(new Object[]{"regions", "purchasable_regions"}).getBoolean();
        UniverseGuard.LIMIT_REGIONS_SIZE = configNode.getNode(new Object[]{"regions", "limit_regions_size"}).getBoolean();
        UniverseGuard.LIMIT_PLAYER_REGIONS = configNode.getNode(new Object[]{"players", "limit_player_regions"}).getBoolean();
        if (!configNode.getNode(new Object[]{"regions", "max_region_size"}).isVirtual()) {
            int maxRegionSize = configNode.getNode(new Object[]{"regions", "max_region_size"}).getInt();
            if (maxRegionSize > 0) {
                UniverseGuard.MAX_REGION_SIZE = maxRegionSize;
            } else {
                LogUtils.print(TextColors.RED, RegionText.TEXT_WRONG_MAX_REGION_SIZE.getValue() + String.valueOf(UniverseGuard.MAX_REGION_SIZE), "flag utils");
            }
        }
        if (!configNode.getNode(new Object[]{"players", "max_regions"}).isVirtual()) {
            int maxRegions = configNode.getNode(new Object[]{"players", "max_regions"}).getInt();
            if (maxRegions > 0) {
                UniverseGuard.MAX_REGIONS = maxRegions;
            } else {
                LogUtils.print(TextColors.RED, RegionText.TEXT_WRONG_MAX_REGIONS.getValue() + String.valueOf(UniverseGuard.MAX_REGIONS), "flag utils");
            }
        }
        for (RegionPermission regionPermission : RegionPermission.values()) {
            if (configNode.getNode(new Object[]{"max_regions", regionPermission.getName()}).isVirtual()) continue;
            int maxRegions = configNode.getNode(new Object[]{"max_regions", regionPermission.getName()}).getInt();
            if (maxRegions > 0) {
                UniverseGuard.MAX_PERMISSION_REGIONS.put(regionPermission.getName(), maxRegions);
                continue;
            }
            LogUtils.print(TextColors.RED, RegionText.TEXT_WRONG_MAX_REGIONS.getValue() + String.valueOf(UniverseGuard.MAX_REGIONS), "flag utils");
        }
        if (!configNode.getNode(new Object[]{"max_regions", "*"}).isVirtual()) {
            int maxRegions = configNode.getNode(new Object[]{"max_regions", "*"}).getInt();
            if (maxRegions > 0) {
                UniverseGuard.MAX_PERMISSION_REGIONS.put("*", maxRegions);
            } else {
                LogUtils.print(TextColors.RED, RegionText.TEXT_WRONG_MAX_REGIONS.getValue() + String.valueOf(UniverseGuard.MAX_REGIONS), "flag utils");
            }
        }
        if (!configNode.getNode(new Object[]{"selector", "item"}).isVirtual()) {
            String id = configNode.getNode(new Object[]{"selector", "item"}).getString();
            Optional type = game.getRegistry().getType(ItemType.class, id);
            if (type.isPresent()) {
                UniverseGuard.SELECTOR_ITEM = (ItemType)type.get();
            } else {
                LogUtils.print(TextColors.RED, RegionText.TEXT_WRONG_SELECTOR_ITEM.getValue() + UniverseGuard.SELECTOR_ITEM.getId(), "flag utils");
            }
        }
    }

    public static EnumRegionFlag getFlag(String name) {
        for (EnumRegionFlag flag : EnumRegionFlag.values()) {
            if (!flag.getName().equalsIgnoreCase(name)) continue;
            return flag;
        }
        return null;
    }

    public static EnumRegionInteract getInteract(String name) {
        for (EnumRegionInteract interact : EnumRegionInteract.values()) {
            if (!interact.getName().equalsIgnoreCase(name)) continue;
            return interact;
        }
        return null;
    }

    public static EnumRegionInteract getInteract(BlockType block) {
        if (block.equals(BlockTypes.CRAFTING_TABLE)) {
            return FlagUtils.getInteract("craftingtable");
        }
        if (block.equals(BlockTypes.ANVIL)) {
            return FlagUtils.getInteract("anvil");
        }
        if (block.equals(BlockTypes.ENCHANTING_TABLE)) {
            return FlagUtils.getInteract("enchantingtable");
        }
        if (block.equals(BlockTypes.HOPPER)) {
            return FlagUtils.getInteract("hopper");
        }
        if (block.equals(BlockTypes.LEVER)) {
            return FlagUtils.getInteract("lever");
        }
        if (block.equals(BlockTypes.STONE_BUTTON) || block.equals(BlockTypes.WOODEN_BUTTON)) {
            return FlagUtils.getInteract("button");
        }
        if (block.equals(BlockTypes.FURNACE)) {
            return FlagUtils.getInteract("furnace");
        }
        if (block.equals(BlockTypes.WOODEN_DOOR) || block.equals(BlockTypes.BIRCH_DOOR) || block.equals(BlockTypes.SPRUCE_DOOR) || block.equals(BlockTypes.JUNGLE_DOOR) || block.equals(BlockTypes.ACACIA_DOOR) || block.equals(BlockTypes.DARK_OAK_DOOR) || block.equals(BlockTypes.IRON_DOOR)) {
            return FlagUtils.getInteract("door");
        }
        if (block.equals(BlockTypes.FENCE_GATE) || block.equals(BlockTypes.BIRCH_FENCE_GATE) || block.equals(BlockTypes.SPRUCE_FENCE_GATE) || block.equals(BlockTypes.JUNGLE_FENCE_GATE) || block.equals(BlockTypes.ACACIA_FENCE_GATE) || block.equals(BlockTypes.DARK_OAK_FENCE_GATE)) {
            return FlagUtils.getInteract("fencegate");
        }
        if (block.equals(BlockTypes.TRAPDOOR) || block.equals(BlockTypes.IRON_TRAPDOOR)) {
            return FlagUtils.getInteract("trapdoor");
        }
        if (block.equals(BlockTypes.STANDING_SIGN) || block.equals(BlockTypes.WALL_SIGN)) {
            return FlagUtils.getInteract("sign");
        }
        return null;
    }

    public static EnumRegionVehicle getVehicle(EntityType entity) {
        if (entity.equals(EntityTypes.CHESTED_MINECART) || entity.equals(EntityTypes.COMMANDBLOCK_MINECART) || entity.equals(EntityTypes.FURNACE_MINECART) || entity.equals(EntityTypes.HOPPER_MINECART) || entity.equals(EntityTypes.MOB_SPAWNER_MINECART) || entity.equals(EntityTypes.RIDEABLE_MINECART) || entity.equals(EntityTypes.TNT_MINECART)) {
            return EnumRegionVehicle.MINECART;
        }
        if (entity.equals(EntityTypes.BOAT)) {
            return EnumRegionVehicle.BOAT;
        }
        return null;
    }

    public static EnumRegionInteract getInteract(EntityType entity) {
        if (entity.equals(EntityTypes.ARMOR_STAND)) {
            return FlagUtils.getInteract("armorstand");
        }
        if (entity.equals(EntityTypes.ITEM_FRAME)) {
            return FlagUtils.getInteract("itemframe");
        }
        return null;
    }

    public static EnumRegionVehicle getVehicle(String name) {
        for (EnumRegionVehicle vehicle : EnumRegionVehicle.values()) {
            if (!vehicle.getName().equalsIgnoreCase(name)) continue;
            return vehicle;
        }
        return null;
    }

    public static EnumRegionExplosion getExplosion(String name) {
        for (EnumRegionExplosion explosion : EnumRegionExplosion.values()) {
            if (!explosion.getName().equalsIgnoreCase(name)) continue;
            return explosion;
        }
        return null;
    }

    public static EnumRegionExplosion getExplosion(EntityType type) {
        if (type.equals(EntityTypes.TNT_MINECART) || type.equals(EntityTypes.PRIMED_TNT)) {
            return FlagUtils.getExplosion("tnt");
        }
        if (type.equals(EntityTypes.CREEPER)) {
            return FlagUtils.getExplosion("creeper");
        }
        if (type.equals(EntityTypes.ENDER_CRYSTAL)) {
            return FlagUtils.getExplosion("endercrystal");
        }
        if (type.equals(EntityTypes.FIREBALL)) {
            return FlagUtils.getExplosion("fireball");
        }
        if (type.equals(EntityTypes.ENDER_DRAGON)) {
            return FlagUtils.getExplosion("enderdragon");
        }
        return null;
    }

    public static boolean isBlockEntity(EntityType type) {
        return type.equals(EntityTypes.ENDER_CRYSTAL) || type.equals(EntityTypes.PAINTING) || type.equals(EntityTypes.ITEM_FRAME) || type.equals(EntityTypes.ARMOR_STAND);
    }

    public static boolean isInteract(BlockType type) {
        return type.equals(BlockTypes.CRAFTING_TABLE) || type.equals(BlockTypes.ENCHANTING_TABLE) || type.equals(BlockTypes.ANVIL);
    }

    public static boolean isVehicle(EntityType type) {
        return type.equals(EntityTypes.CHESTED_MINECART) || type.equals(EntityTypes.COMMANDBLOCK_MINECART) || type.equals(EntityTypes.FURNACE_MINECART) || type.equals(EntityTypes.HOPPER_MINECART) || type.equals(EntityTypes.MOB_SPAWNER_MINECART) || type.equals(EntityTypes.RIDEABLE_MINECART) || type.equals(EntityTypes.TNT_MINECART) || type.equals(EntityTypes.BOAT);
    }

    public static boolean isExplosion(EntityType type) {
        return type.equals(EntityTypes.TNT_MINECART) || type.equals(EntityTypes.PRIMED_TNT) || type.equals(EntityTypes.CREEPER) || type.equals(EntityTypes.ENDER_CRYSTAL) || type.equals(EntityTypes.FIREBALL) || type.equals(EntityTypes.ENDER_DRAGON);
    }

    public static boolean isCrop(BlockType type) {
        return type.equals(BlockTypes.WHEAT) || type.equals(BlockTypes.BEETROOTS) || type.equals(BlockTypes.MELON_STEM) || type.equals(BlockTypes.PUMPKIN_STEM) || type.equals(BlockTypes.CARROTS) || type.equals(BlockTypes.NETHER_WART) || type.equals(BlockTypes.FARMLAND);
    }

    public static String getMobId(String name) {
        for (String id2 : Sponge.getRegistry().getAllOf(EntityType.class).stream().map(CatalogType::getId).filter(id -> id.contains(name.toLowerCase())).collect(Collectors.toList())) {
            if (!(name.contains(":") ? id2.equalsIgnoreCase(name) : id2.substring(id2.indexOf(":") + 1).equalsIgnoreCase(name.toLowerCase()))) continue;
            return id2;
        }
        return null;
    }

    public static List<String> getAllMobIds() {
        return Sponge.getRegistry().getAllOf(EntityType.class).stream().map(CatalogType::getId).collect(Collectors.toList());
    }

    public static boolean isExcludedFromPlace(Region region, BlockType type) {
        return region.getExcludedBlocks().getPlace().contains(type.getId());
    }

    public static boolean isExcludedFromDestroy(Region region, BlockType type) {
        return region.getExcludedBlocks().getDestroy().contains(type.getId());
    }
}

