/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.handler;

import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.handler.ConfigHandler;
import fr.nocturne123.questionstime.handler.MessageHandler;
import fr.nocturne123.questionstime.message.Message;
import fr.nocturne123.questionstime.message.MessageComponents;
import fr.nocturne123.questionstime.question.Question;
import fr.nocturne123.questionstime.question.QuestionCreator;
import fr.nocturne123.questionstime.question.component.Malus;
import fr.nocturne123.questionstime.question.component.Prize;
import fr.nocturne123.questionstime.question.component.PrizeSerializer;
import fr.nocturne123.questionstime.util.TextUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class EventHandler {
    private Map<UUID, Long> playerCooldownAnswer = new HashMap<UUID, Long>();
    private static final Logger logger = QuestionsTime.getInstance().getLogger();

    @Listener
    public void onReceiveMessage(MessageChannelEvent event) {
        if (event.getCause() != null && event.getCause().first(Player.class).isPresent() && !event.getCause().containsType(PluginContainer.class)) {
            QuestionsTime instance = QuestionsTime.getInstance();
            Player player = (Player)event.getCause().first(Player.class).get();
            String message = event.getMessage().toPlain();
            if (message.endsWith("qtc>start") && !instance.isCreator(player.getUniqueId())) {
                instance.addCreator(player.getUniqueId());
                this.handleQuestionCreation(message, player, instance, event);
                return;
            }
            if (message.contains("qt>") && !instance.isCreator(player.getUniqueId()) && instance.getCurrentQuestion().isPresent()) {
                this.handleQuestionAnswer(message, player, instance, event);
            }
            if (message.contains("qtc>") && instance.isCreator(player.getUniqueId())) {
                this.handleQuestionCreation(message, player, instance, event);
            }
        }
    }

    private void handleQuestionAnswer(String message, Player sender, QuestionsTime instance, MessageChannelEvent event) {
        Question question = instance.getCurrentQuestion().get();
        logger.debug("Is personal answer: " + ConfigHandler.isPersonalAnswer());
        if (ConfigHandler.isPersonalAnswer()) {
            event.setMessageCancelled(true);
            logger.debug("Message send cancelled");
        }
        if (this.playerCooldownAnswer.containsKey(sender.getUniqueId())) {
            long time = this.playerCooldownAnswer.get(sender.getUniqueId());
            logger.debug("cooldown for " + sender.getName() + ": " + time);
            logger.debug("current time: " + System.currentTimeMillis());
            if (System.currentTimeMillis() > time) {
                this.playerCooldownAnswer.remove(sender.getUniqueId());
            } else {
                sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.ANSWER_COOLDOWN).setComponent(MessageComponents.TIMER, (int)(this.playerCooldownAnswer.get(sender.getUniqueId()) - System.currentTimeMillis()) / 1000).build())}));
                return;
            }
        }
        if (message.endsWith("qt>" + question.getAnswer())) {
            logger.debug("the answer of the question was found by " + sender.getName());
            QuestionsTime.getInstance().setPlayedQuestion(null);
            if (question.isTimed()) {
                instance.stopTimer();
            }
            logger.debug("timer stopped");
            Task.builder().execute(wait -> Sponge.getServer().getOnlinePlayers().forEach(player -> {
                if (player.getUniqueId().equals(sender.getUniqueId())) {
                    player.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(MessageHandler.Messages.ANSWER_WIN)}));
                } else {
                    player.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.ANSWER_WIN_ANNOUNCE).setComponent(MessageComponents.PLAYER_NAME, sender).build())}));
                }
            })).async().delay(500L, TimeUnit.MILLISECONDS).submit(instance.getContainer().getInstance().get());
            logger.debug("messages sended");
            Optional<Prize> prizeOptional = question.getPrize();
            logger.debug("is the question have a prize: " + prizeOptional.isPresent());
            prizeOptional.ifPresent(prize -> {
                if (prize.getItemStacks().length > 0 || prize.getMoney() > 0 && instance.getEconomy().isPresent()) {
                    logger.debug("prize will be send");
                }
                Task.builder().execute(task -> {
                    sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(MessageHandler.Messages.REWARD_ANNOUNCE)}));
                    if (prize.getItemStacks().length > 0) {
                        for (int i = 0; i < prize.getItemStacks().length; ++i) {
                            ItemStack item = prize.getItemStacks()[i];
                            sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.REWARD_PRIZE).setComponent(MessageComponents.QUANTITY, item.getQuantity()).setComponent(MessageComponents.MOD_ID, item).setComponent(MessageComponents.ITEM, item).setComponent(MessageComponents.METADATA, item).build())}));
                            sender.getInventory().offer(prize.getItemStacks()[i].copy());
                        }
                    }
                    if (prize.getMoney() > 0 && instance.getEconomy().isPresent()) {
                        EconomyService ecoSevice = instance.getEconomy().get();
                        sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.REWARD_MONEY).setComponent(MessageComponents.MONEY, prize.getMoney()).setComponent(MessageComponents.CURRENCY, ecoSevice).build())}));
                        Optional account = ecoSevice.getOrCreateAccount(sender.getUniqueId());
                        if (account.isPresent()) {
                            ((UniqueAccount)account.get()).deposit(ecoSevice.getDefaultCurrency(), BigDecimal.valueOf(prize.getMoney()), event.getCause());
                        } else {
                            instance.getLogger().error("The economy account for " + sender.getName() + " can't be found / created.");
                        }
                    } else if (!instance.getEconomy().isPresent()) {
                        instance.getLogger().info("No Economy Service found.");
                    }
                }).async().delayTicks(60L).name("[QT]SendWinnerPrize").submit(instance.getContainer().getInstance().get());
            });
            instance.sayNewQuestion();
        } else if (message.contains("qt>")) {
            String answer = message.substring(message.lastIndexOf("qt>") + 3);
            sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.ANSWER_FALSE).setComponent(MessageComponents.ANSWER, answer).build())}));
            logger.debug("is timer between answer: " + question.isTimeBetweenAnswer());
            if (question.isTimeBetweenAnswer()) {
                this.playerCooldownAnswer.put(sender.getUniqueId(), System.currentTimeMillis() + (long)(question.getTimeBetweenAnswer() * 1000));
            }
            Optional<Malus> malusOptional = question.getMalus();
            logger.debug("is malus present: " + malusOptional.isPresent());
            malusOptional.ifPresent(malus -> {
                if (malus.getMoney() > 0 && instance.getEconomy().isPresent()) {
                    logger.debug("malus will be send");
                    EconomyService economyService = instance.getEconomy().get();
                    sender.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, MessageHandler.get(Message.builder(MessageHandler.Messages.ANSWER_MALUS).setComponent(MessageComponents.MONEY, malus.getMoney()).setComponent(MessageComponents.CURRENCY, economyService).build())}));
                    Optional account = economyService.getOrCreateAccount(sender.getUniqueId());
                    if (account.isPresent()) {
                        ((UniqueAccount)account.get()).withdraw(economyService.getDefaultCurrency(), BigDecimal.valueOf(malus.getMoney()), event.getCause());
                    } else {
                        instance.getLogger().error("The economy account for " + sender.getName() + " can't be found / created.");
                    }
                } else if (!instance.getEconomy().isPresent()) {
                    instance.getLogger().info("No Economy Service found.");
                }
            });
        }
    }

    private void handleQuestionCreation(String message, Player p, QuestionsTime instance, MessageChannelEvent e) {
        if (instance.getQuestionCreator(p.getUniqueId()).isPresent()) {
            QuestionCreator qc = instance.getQuestionCreator(p.getUniqueId()).get();
            String answer = message.substring(message.lastIndexOf("qtc>") + 4);
            if (answer.equals("stop")) {
                qc.setStop();
            }
            if (answer.equals("confirm") && qc.isConfirm()) {
                qc.nextStep();
            } else {
                qc.setPreviousResponse(answer);
            }
            switch (qc.getCurrentStep()) {
                case -1: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to quit the Question Creator ? The question will not be saved !"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to continue the creation of the command ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer need to be \"", "qtc>yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to stop the Question Creator ?"));
                    p.sendMessage(TextUtils.creatorComposed("Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 0: {
                    if (qc.isHalfConfirm()) {
                        p.sendMessage(TextUtils.creatorComposed("Is \"", answer, "\" the right question ?"));
                        qc.setConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("What's the question ? Answer with \"", "qtc>question", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 1: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("simple")) {
                            p.sendMessage(TextUtils.creatorComposed("The question's type is \"", "simple", "\". That's right ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("proposition")) {
                            p.sendMessage(TextUtils.creatorComposed("The question's type is \"", "proposition", "\". That's right ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The question's type can only be \"", "simple OR proposition", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("What's the question's type ? Answer with \"", "qtc>simple", "\" or \""), Text.builder((String)"qtc>proposition").color(TextColors.BLUE).build(), Text.builder((String)"\"").color(TextColors.GREEN).build()}));
                    qc.setHalfConfirm();
                    break;
                }
                case 2: {
                    if (qc.isHalfConfirm()) {
                        String[] split = answer.split(" ", 2);
                        if (split.length == 2 && !split[0].isEmpty() && !split[1].isEmpty()) {
                            String action = split[0];
                            String argument = split[1];
                            if ("add".equals(action)) {
                                if (argument.contains(";")) {
                                    List<String> listProposition = Arrays.asList(argument.split(";"));
                                    listProposition.removeIf(String::isEmpty);
                                    if (!listProposition.isEmpty()) {
                                        if (qc.getPropositions().size() + listProposition.size() < 128) {
                                            for (int i = 0; i < listProposition.size(); ++i) {
                                                String preposition = listProposition.get(i);
                                                p.sendMessage(TextUtils.creatorComposed("", "[" + (qc.getPropositions().size() + i + 1) + "] " + preposition, " added"));
                                            }
                                            qc.getPropositions().addAll(listProposition);
                                        } else {
                                            p.sendMessage(TextUtils.creatorComposed("The number of proposition will exceed ", String.valueOf(127), ""));
                                        }
                                    } else {
                                        p.sendMessage(TextUtils.creatorNormalWithPrefix("You wrote empty prepositions"));
                                    }
                                } else if (qc.getPropositions().size() < 128) {
                                    qc.getPropositions().add(argument);
                                    p.sendMessage(TextUtils.creatorComposed("Proposition ", "[" + qc.getPropositions().size() + "] " + argument, " added"));
                                } else {
                                    p.sendMessage(TextUtils.creatorComposed("The number of proposition will exceed ", String.valueOf(127), ""));
                                }
                            } else if ("set".equals(action)) {
                                String[] split2 = argument.split(" ", 2);
                                if (split2.length >= 2 && !split2[0].isEmpty() && !split2[1].isEmpty()) {
                                    if (StringUtils.isNumeric((CharSequence)split2[0])) {
                                        int position = Integer.parseInt(split2[0]);
                                        if (position > 0 && position <= qc.getPropositions().size()) {
                                            qc.getPropositions().set(position - 1, split2[1]);
                                            p.sendMessage(TextUtils.creatorComposed("Proposition ", "[" + position + "] " + split2[1], " modified !"));
                                        } else if (qc.getPropositions().isEmpty()) {
                                            p.sendMessage(TextUtils.creatorNormalWithPrefix("No propositions are registered"));
                                        } else if (qc.getPropositions().size() == 1) {
                                            p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("You can only set the proposition ", String.valueOf(1), "")}));
                                        } else {
                                            p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("The position need to be bewteen ", "1", " and "), TextUtils.creatorSpecial(String.valueOf(qc.getPropositions().size()))}));
                                        }
                                    } else {
                                        p.sendMessage(TextUtils.creatorComposed("\"", split2[0], "\" is not a number"));
                                    }
                                } else {
                                    p.sendMessage(TextUtils.creatorComposed("Arguments ", argument, " are empty or less than 2"));
                                }
                            } else if ("del".equals(action)) {
                                if (StringUtils.isNumeric((CharSequence)argument)) {
                                    int position = Integer.parseInt(argument);
                                    if (position > 0 && position <= qc.getPropositions().size()) {
                                        qc.getPropositions().remove(position - 1);
                                        p.sendMessage(TextUtils.creatorComposed("Proposition ", String.valueOf(position), " deleted !"));
                                    } else {
                                        p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("The position need to be bewteen ", "1", " and "), TextUtils.creatorSpecial(String.valueOf(qc.getPropositions().size()))}));
                                    }
                                } else {
                                    p.sendMessage(TextUtils.creatorComposed("\"", argument, "\" is not a number"));
                                }
                            } else {
                                p.sendMessage(TextUtils.creatorComposed("The first word need to be \"", "add OR set OR del OR list", "\""));
                            }
                        } else if ("list".equals(answer)) {
                            if (qc.getPropositions().size() == 0) {
                                p.sendMessage(TextUtils.creatorNormalWithPrefix("No propositions have been made"));
                            } else {
                                for (int i = 0; i < qc.getPropositions().size(); ++i) {
                                    p.sendMessage(TextUtils.creatorComposed("", i + 1 + "] ", qc.getPropositions().get(i)));
                                }
                            }
                        } else {
                            p.sendMessage(TextUtils.creatorComposed("Answer \"", answer, "\" not recognized. Did you add all the arguments required ?"));
                        }
                        if (qc.getPropositions().size() >= 2 && qc.getPropositions().size() <= 127) {
                            qc.setConfirm();
                            break;
                        }
                        qc.setHalfConfirm();
                        if (!"confirm".equals(answer)) break;
                        p.sendMessage(TextUtils.creatorComposed("You need to write ", String.valueOf(2), " propositions at least"));
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Write a proposition with \"", "qtc>add proposition", "\""));
                    p.sendMessage(TextUtils.creatorComposed("You can separate each proposition with a \"", ";", "\""));
                    p.sendMessage(TextUtils.creatorComposed("Modify a proposition with \"", "qtc>set position proposition", "\""));
                    p.sendMessage(TextUtils.creatorComposed("Delete a proposition with \"", "qtc>del position", "\""));
                    p.sendMessage(TextUtils.creatorComposed("You can list the propositions with \"", "qtc>list", "\""));
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("The number of proposition need to be between ", "2", " and "), TextUtils.creatorSpecial("127")}));
                    qc.setHalfConfirm();
                    break;
                }
                case 3: {
                    if (qc.isConfirm() || qc.isHalfConfirm()) {
                        if (qc.getQuestionType() == Question.Types.MULTI) {
                            if (StringUtils.isNumeric((CharSequence)answer)) {
                                int position = Integer.parseInt(answer);
                                if (position <= qc.getPropositions().size() && position >= 0) {
                                    p.sendMessage(TextUtils.creatorComposed("The right proposition is \"", answer, "\". It is correct ?"));
                                    qc.setConfirm();
                                    break;
                                }
                                p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("The right proposition can only be a number between ", "0", " and "), TextUtils.creatorSpecial(String.valueOf(qc.getPropositions().size()))}));
                                qc.setHalfConfirm();
                                break;
                            }
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("The right proposition can only be a number"));
                            qc.setHalfConfirm();
                            break;
                        }
                        if (qc.getQuestionType() != Question.Types.SIMPLE) break;
                        p.sendMessage(TextUtils.creatorComposed("The answer is \"", answer, "\". It is correct ?"));
                        qc.setConfirm();
                        break;
                    }
                    if (qc.getQuestionType() == Question.Types.MULTI) {
                        p.sendMessage(TextUtils.creatorComposed("What's the right proposition ? Answer with \"", "qtc>number", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    if (qc.getQuestionType() != Question.Types.SIMPLE) break;
                    p.sendMessage(TextUtils.creatorComposed("What's the answer of the question ? Answer with \"", "qtc>answer", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 4: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really want to add prizes ?")}));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really don't want to add prizes ?")}));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to add prizes ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 5: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really want to announce the prize after the question was asked ?")}));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really want to not announce the prize after the question was asked ?")}));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to announce the prize ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 6: {
                    if (qc.isHalfConfirm()) {
                        if (StringUtils.isNumeric((CharSequence)answer)) {
                            if (answer.length() <= 18) {
                                if (Long.valueOf(answer) > 0L) {
                                    p.sendMessage(TextUtils.creatorComposed("Is \"", answer, "\" the right amount ?"));
                                    qc.setConfirm();
                                    break;
                                }
                                p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really don't want to add money as a prize ?")}));
                                qc.setConfirm();
                                break;
                            }
                            p.sendMessage(TextUtils.creatorComposed("\"", answer, "\" is too big !"));
                            qc.setHalfConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("\"", answer, "\" isn't a number or a positive number"));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("What is the amount of ", instance.getEconomy().get().getDefaultCurrency().getDisplayName().toPlain(), " ? Answer with \""), TextUtils.creatorSpecial("qtc>amount"), TextUtils.creatorNormal("\" (if you doesn't want, just put 0)")}));
                    qc.setHalfConfirm();
                    break;
                }
                case 7: {
                    if (qc.isConfirm()) {
                        ItemStack is = PrizeSerializer.getStackBySyntax(answer);
                        if (is.getType() != ItemTypes.NONE) {
                            qc.addItemPrize(is);
                            p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" Added \""), TextUtils.readableItemID(is), Text.builder((String)(" * " + is.getQuantity())).color(TextColors.LIGHT_PURPLE).build(), TextUtils.creatorNormal("\"")}));
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("Incorrect syntax : \"", answer, "\""));
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Add an item as prize with \"", "qtc>[ModID]:{ItemID};[Variant];[Count];[DisplayName];[Lore]", "\""));
                    p.sendMessage(TextUtils.creatorComposed("Which \"", "{...}", "\" is obligatory"));
                    p.sendMessage(TextUtils.creatorComposed("And \"", "[...]", "\" optionnal"));
                    p.sendMessage(TextUtils.creatorComposed("If you don't want to add items, type \"", "qtc>confirm", "\" directly"));
                    qc.setConfirm();
                    break;
                }
                case 8: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to add a malus ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to not add a malus ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to add a malus for a wrong answer ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 9: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to announce the malus ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to not announce the malus ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to announce the malus after the question ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 10: {
                    if (qc.isHalfConfirm()) {
                        if (StringUtils.isNumeric((CharSequence)answer)) {
                            if (answer.length() <= 18) {
                                if (Long.valueOf(answer) > 0L) {
                                    p.sendMessage(TextUtils.creatorComposed("Is \"", answer, "\" the right amount ?"));
                                    qc.setConfirm();
                                    break;
                                }
                                p.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorNormal(" You really don't want to add money as a malus ?")}));
                                qc.setConfirm();
                                break;
                            }
                            p.sendMessage(TextUtils.creatorComposed("\"", answer, "\" is too big !"));
                            qc.setHalfConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("\"", answer, "\" isn't a number or a positive number"));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("What is the amount of ", instance.getEconomy().get().getDefaultCurrency().getDisplayName().toPlain(), " ? Answer with \""), TextUtils.creatorSpecial("qtc>amount"), TextUtils.creatorNormal("\" (if you doesn't want, just put 0)")}));
                    qc.setHalfConfirm();
                    break;
                }
                case 11: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to add a timer ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to not add a timer ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to add a timer ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 12: {
                    if (qc.isHalfConfirm()) {
                        this.handleTime(answer, p, qc, instance);
                        break;
                    }
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("How long do players have to wait between each answer ? Answer with this format \"", "qtc>xhxmxs", "\", where "), TextUtils.creatorSpecial("x"), TextUtils.creatorNormal(" is a number")}));
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("Note : the maximum is ", "23h59m59s", " and the minimum is "), TextUtils.creatorSpecial("0h0m10s")}));
                    qc.setHalfConfirm();
                    break;
                }
                case 13: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("yes")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to add a time between an answer ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("no")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to not add a time between an answer ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "yes OR no", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Do you want to add a time between an answer ? Answer with \"", "qtc>yes OR no", "\""));
                    qc.setHalfConfirm();
                    break;
                }
                case 14: {
                    if (qc.isHalfConfirm()) {
                        this.handleTime(answer, p, qc, instance);
                        break;
                    }
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("How long the players can answer ? Answer with this format \"", "qtc>xhxmxs", "\", where "), TextUtils.creatorSpecial("x"), TextUtils.creatorNormal(" is a number")}));
                    p.sendMessage(Text.join((Text[])new Text[]{TextUtils.creatorComposed("Note : the maximum is ", "23h59m59s", " and the minimum is "), TextUtils.creatorSpecial("0h0m10s")}));
                    qc.setHalfConfirm();
                    break;
                }
                case 15: {
                    if (qc.isHalfConfirm()) {
                        if (answer.equals("start")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to start the question ?"));
                            qc.setConfirm();
                            break;
                        }
                        if (answer.equals("save")) {
                            p.sendMessage(TextUtils.creatorNormalWithPrefix("Do you really want to just save the question ?"));
                            qc.setConfirm();
                            break;
                        }
                        p.sendMessage(TextUtils.creatorComposed("The answer can only be \"", "start OR save", "\""));
                        qc.setHalfConfirm();
                        break;
                    }
                    p.sendMessage(TextUtils.creatorComposed("Good, it's finish ! The question is now registered ! Do you want to start the question or just save it ? Answer with \"", "qtc>start OR save", "\""));
                    qc.setHalfConfirm();
                }
            }
            e.setMessageCancelled(true);
        } else {
            instance.getLogger().error("I think a spacetime error occurred because this is -normally- impossible to happen. But, yea, I think you found a bug. It is cool ?");
        }
    }

    private void handleTime(String answer, Player player, QuestionCreator qc, QuestionsTime instance) {
        if (Pattern.matches("^[0-9]+(h)[0-9]+(m)[0-9]+(s)$", answer)) {
            String timeHour = StringUtils.substringBefore((String)answer, (String)"h");
            String timeMinute = StringUtils.substringBetween((String)answer, (String)"h", (String)"m");
            String timeSecond = StringUtils.substringBetween((String)answer, (String)"m", (String)"s");
            if (StringUtils.isNumeric((CharSequence)timeHour) && StringUtils.isNumeric((CharSequence)timeMinute) && StringUtils.isNumeric((CharSequence)timeSecond)) {
                int hour = Integer.valueOf(timeHour);
                int min = Integer.valueOf(timeMinute);
                int sec = Integer.valueOf(timeSecond);
                if (hour >= 0 && hour <= 23) {
                    if (min >= 0 && min <= 59) {
                        if (hour == 0 && min == 0 && sec < 10) {
                            player.sendMessage(TextUtils.creatorNormalWithPrefix("The time need to be at least 10 seconds"));
                            qc.setHalfConfirm();
                        } else if (sec >= 0 && sec <= 59) {
                            player.sendMessage(TextUtils.creatorComposed("Is the time ", hour + "H" + min + "M" + sec + "S", " enough to answer the question ?"));
                            qc.setConfirm();
                        } else {
                            player.sendMessage(TextUtils.creatorComposed("", timeSecond, " need to be between 0 and 59"));
                            qc.setHalfConfirm();
                        }
                    } else {
                        player.sendMessage(TextUtils.creatorComposed("", timeMinute, " need to be between 0 and 59"));
                        qc.setHalfConfirm();
                    }
                } else {
                    player.sendMessage(TextUtils.creatorComposed("", timeHour, " need to be between 0 and 23"));
                    qc.setHalfConfirm();
                }
            } else {
                if (!StringUtils.isNumeric((CharSequence)timeHour)) {
                    player.sendMessage(TextUtils.creatorComposed("", timeHour, " isn't an number"));
                }
                if (!StringUtils.isNumeric((CharSequence)timeMinute)) {
                    player.sendMessage(TextUtils.creatorComposed("", timeMinute, " isn't an number"));
                }
                if (!StringUtils.isNumeric((CharSequence)timeSecond)) {
                    player.sendMessage(TextUtils.creatorComposed("", timeSecond, " isn't an number"));
                }
                qc.setHalfConfirm();
            }
        } else {
            player.sendMessage(Text.join((Text[])new Text[]{instance.qtPrefix, TextUtils.creatorSpecial(" " + answer), TextUtils.creatorNormal(" doesn't matche "), TextUtils.creatorSpecial("xhxmxs")}));
            qc.setHalfConfirm();
        }
    }

    @Listener
    public void onPlayerDisconnected(ClientConnectionEvent.Disconnect e) {
        QuestionsTime instance = QuestionsTime.getInstance();
        if (Sponge.getGame().getServer().getOnlinePlayers().size() == 1 && instance.getCurrentQuestion().isPresent()) {
            instance.setPlayedQuestion(null);
            instance.getLogger().info("The last player connected has been disconnected while a question was said. The question has been stopped.");
            instance.sayNewQuestion();
        }
        if (instance.isCreator(e.getTargetEntity().getUniqueId())) {
            instance.removeCreator(e.getTargetEntity().getUniqueId());
            instance.stopTimer();
            instance.getLogger().info("The player's name " + e.getTargetEntity().getName() + " was creating a question when he disconnected. The question will not be save.");
        }
    }
}

