/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.question;

import com.google.common.base.Strings;
import fr.nocturne123.questionstime.QuestionException;
import fr.nocturne123.questionstime.question.Question;
import java.util.ArrayList;
import java.util.List;

public class QuestionMulti
extends Question {
    private List<String> propositions;
    private byte answer;

    private QuestionMulti(QuestionMultiBuilder builder) {
        super(builder);
        this.propositions = builder.propositions;
        this.answer = builder.answer;
    }

    public List<String> getPropositions() {
        return this.propositions;
    }

    @Override
    public String getAnswer() {
        return String.valueOf(this.answer);
    }

    @Override
    public Question.Types getType() {
        return Question.Types.MULTI;
    }

    public static QuestionMultiBuilder builder() {
        return new QuestionMultiBuilder();
    }

    public static class QuestionMultiBuilder
    extends Question.QuestionBuilder<QuestionMultiBuilder> {
        private List<String> propositions = new ArrayList<String>();
        private byte answer;

        public QuestionMultiBuilder addProposition(String proposition) {
            if (Strings.isNullOrEmpty((String)proposition)) {
                throw new NullPointerException("The proposition is null or empty");
            }
            this.propositions.add(proposition);
            return this;
        }

        public QuestionMultiBuilder addPropositions(List<String> propositions) {
            if (propositions == null || propositions.isEmpty()) {
                throw new IllegalArgumentException("The propositions are null or empty");
            }
            this.propositions.addAll(propositions);
            return this;
        }

        public QuestionMultiBuilder setAnswer(byte answer) {
            this.answer = answer;
            return this;
        }

        @Override
        public QuestionMultiBuilder setAnswer(String answer) {
            throw new IllegalArgumentException("This method has not te be used for a question with propositions");
        }

        @Override
        public QuestionMulti build() {
            if (Strings.isNullOrEmpty((String)this.question)) {
                throw new NullPointerException("The question is null or empty");
            }
            if (this.propositions.size() <= 1) {
                throw new QuestionException("The question need at least 2 propositions");
            }
            if (this.answer < 0) {
                throw new QuestionException("The answer need to be a number egal or superior of 0");
            }
            return new QuestionMulti(this);
        }
    }
}

