/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.util;

import fr.nocturne123.questionstime.QuestionsTime;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class TextUtils {
    private static QuestionsTime instance = QuestionsTime.getInstance();

    public static Text creatorNormal(String message) {
        return Text.builder((String)message).color(TextColors.GREEN).build();
    }

    public static Text creatorNormalWithPrefix(String message) {
        return Text.join((Text[])new Text[]{TextUtils.instance.qtPrefix, TextUtils.creatorNormal(" " + message)});
    }

    public static Text creatorSpecial(String message) {
        return Text.builder((String)message).color(TextColors.BLUE).build();
    }

    public static Text creatorSpecialWithPrefix(String message) {
        return Text.join((Text[])new Text[]{TextUtils.instance.qtPrefix, TextUtils.creatorSpecial(" " + message)});
    }

    public static Text creatorComposed(String normalOne, String special, String normalTwo) {
        return Text.join((Text[])new Text[]{TextUtils.instance.qtPrefix, TextUtils.creatorNormal(" " + normalOne), TextUtils.creatorSpecial(special), TextUtils.creatorNormal(normalTwo)});
    }

    public static Text creatorComposedWhitoutPrefix(String normalOne, String special, String normalTwo) {
        return Text.join((Text[])new Text[]{TextUtils.creatorNormal(normalOne), TextUtils.creatorSpecial(special), TextUtils.creatorNormal(normalTwo)});
    }

    public static void sendTextToEveryone(Text text) {
        Sponge.getServer().getOnlinePlayers().forEach(player -> player.sendMessage(Text.join((Text[])new Text[]{TextUtils.instance.qtPrefix, text})));
    }

    public static Text readableItemID(ItemStack is) {
        Text displayName;
        String itemID = is.getType().getId();
        if (itemID.isEmpty()) {
            return Text.of((String)"itemIDEmpty");
        }
        Text finalID = Text.EMPTY;
        LiteralText textModID = Text.builder((String)"").build();
        if (is.get(Keys.DISPLAY_NAME).isPresent() && !(displayName = (Text)is.get(Keys.DISPLAY_NAME).get()).isEmpty()) {
            finalID = Text.of((Object[])new Object[]{displayName});
        }
        if (finalID.isEmpty()) {
            if (itemID.startsWith("minecraft:")) {
                finalID = Text.of((String)StringUtils.capitalize((String)itemID.substring(10)));
            } else if (itemID.contains(":") && !itemID.split(":")[0].isEmpty()) {
                String modID = itemID.split(":")[0];
                Optional pluginCont = Sponge.getPluginManager().getPlugin(modID);
                if (pluginCont.isPresent()) {
                    String modName = ((PluginContainer)pluginCont.get()).getName();
                    String itemName = itemID.split(":")[1];
                    textModID = Text.builder((String)(modName.substring(0, 1).toUpperCase() + modName.substring(1) + ": ")).color(TextColors.BLUE).build();
                    finalID = Text.of((String)StringUtils.capitalize((String)itemName));
                } else {
                    instance.getLogger().error("No mod with ID \"" + modID + "\" was found.");
                    finalID = Text.of((String)(modID + " - " + itemID + " -> No found"));
                }
            } else {
                finalID = Text.of((String)("error{" + itemID + "}"));
            }
        }
        if (finalID.toPlain().contains("_")) {
            finalID = Text.of((String)finalID.toPlain().replace('_', ' '));
        }
        Map keys = is.toContainer().getValues(true);
        Text metadataText = Text.builder().build();
        if (keys.containsKey(DataQuery.of((String[])new String[]{"UnsafeDamage"})) && keys.get(DataQuery.of((String[])new String[]{"UnsafeDamage"})) instanceof Integer && (Integer)keys.get(DataQuery.of((String[])new String[]{"UnsafeDamage"})) != 0) {
            metadataText = Text.builder((String)(" " + keys.get(DataQuery.of((String[])new String[]{"UnsafeDamage"})))).color(TextColors.AQUA).build();
        }
        return Text.join((Text[])new Text[]{textModID, Text.builder().append(new Text[]{finalID}).color(TextColors.WHITE).build(), metadataText});
    }

    public static class Console {
        public static Text creatorNormal(String message) {
            return Text.builder((String)message).color(TextColors.YELLOW).build();
        }

        public static Text creatorNormalWithPrefix(String message) {
            return Text.join((Text[])new Text[]{instance.qtPrefix, Console.creatorNormal(" " + message)});
        }

        public static Text creatorSpecial(String message) {
            return Text.builder((String)message).color(TextColors.BLUE).build();
        }

        public static Text creatorSpecialWithPrefix(String message) {
            return Text.join((Text[])new Text[]{instance.qtPrefix, Console.creatorSpecial(" " + message)});
        }

        public static Text creatorComposed(String normalOne, String special, String normalTwo) {
            return Text.join((Text[])new Text[]{instance.qtPrefix, Console.creatorNormal(" " + normalOne), Console.creatorSpecial(special), Console.creatorNormal(normalTwo)});
        }

        public static Text creatorComposedWhitoutPrefix(String normalOne, String special, String normalTwo) {
            return Text.join((Text[])new Text[]{Console.creatorNormal(normalOne), Console.creatorSpecial(special), Console.creatorNormal(normalTwo)});
        }

        public static Text creatorError(String message) {
            return Text.join((Text[])new Text[]{instance.qtPrefix, Text.builder((String)message).color(TextColors.RED).build()});
        }
    }
}

