/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.serializer;

import com.carrot.carrotshop.CarrotShop;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.InvalidDataFormatException;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;

public class InventorySerializer
implements TypeSerializer<Inventory> {
    public Inventory deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        Inventory inv = Inventory.builder().build((Object)CarrotShop.getInstance());
        ConfigurationNode items = value.getNode(new Object[]{"nbtitems"});
        for (ConfigurationNode item : items.getChildrenList()) {
            try {
                Optional itemStack = ItemStack.builder().build((DataView)DataFormats.NBT.readFrom((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(item.getString()))));
                if (!itemStack.isPresent()) continue;
                inv.offer((ItemStack)itemStack.get());
            }
            catch (IOException | InvalidDataException | InvalidDataFormatException e) {
                CarrotShop.getLogger().warn("Error occuered when loading item from NBT");
                e.printStackTrace();
            }
        }
        items = value.getNode(new Object[]{"items"});
        for (ConfigurationNode item : items.getChildrenList()) {
            inv.offer((ItemStack)item.getValue(TypeToken.of(ItemStack.class)));
        }
        return inv;
    }

    public void serialize(TypeToken<?> type, Inventory obj, ConfigurationNode value) throws ObjectMappingException {
        ConfigurationNode items = value.getNode(new Object[]{"nbtitems"});
        ConfigurationNode failover = value.getNode(new Object[]{"items"});
        for (Inventory slot : obj.slots()) {
            if (!slot.peek().isPresent()) continue;
            ConfigurationNode item = items.getAppendedNode();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                DataFormats.NBT.writeTo((OutputStream)os, (DataView)((ItemStack)slot.peek().get()).toContainer());
                os.flush();
                item.setValue((Object)Base64.getEncoder().encodeToString(os.toByteArray()));
            }
            catch (IOException e) {
                ConfigurationNode failoveritem = failover.getAppendedNode();
                failoveritem.setValue(TypeToken.of(ItemStack.class), slot.peek().get());
                CarrotShop.getLogger().warn("Error occuered when saving item as NBT. Trying to save plain");
                e.printStackTrace();
            }
        }
    }
}

