/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;

public class SqlQuery {
    private String statement;
    private DataSource dataSource;
    private ResultSet resultSet;
    private int rowsAffected = 0;

    private SqlQuery(Builder builder) {
        this.statement = builder.statement;
        this.dataSource = builder.dataSource;
        if (builder.update) {
            this.executeUpdate();
        } else {
            this.executeQuery();
        }
    }

    public static Builder builder(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public void executeQuery() {
        try {
            Connection conn = this.dataSource.getConnection();
            Optional<ResultSet> resultSetOpt = Optional.of(conn.prepareStatement(this.statement).executeQuery());
            if (resultSetOpt.isPresent()) {
                this.resultSet = resultSetOpt.get();
            }
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int executeUpdate() {
        try {
            Connection conn = this.dataSource.getConnection();
            this.rowsAffected = conn.prepareStatement(this.statement).executeUpdate();
            conn.close();
            return this.rowsAffected;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean recordExists() {
        try {
            if (this.resultSet.isBeforeFirst()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean getBoolean() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getBoolean(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("[SQL] Could not retrieve boolean from database!");
    }

    public boolean getBoolean(boolean def) {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getBoolean(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return def;
    }

    public int getInt() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("[SQL] Could not retrieve integer from database!");
    }

    public int getInt(int def) {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return def;
    }

    public BigDecimal getBigDecimal() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getBigDecimal(1).max(new BigDecimal(Double.MAX_VALUE));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("[SQL] Could not retrieve BigDecimal from database!");
    }

    public BigDecimal getBigDecimal(BigDecimal def) {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return def;
    }

    public String getString() {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("[SQL] Could not retrieve string from database!");
    }

    public String getString(String def) {
        try {
            if (this.resultSet.next()) {
                return this.resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return def;
    }

    public int getRowsAffected() {
        return this.rowsAffected;
    }

    public static class Builder {
        private DataSource dataSource;
        private String statement = "";
        private boolean update = false;

        public Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Builder select(String column) {
            this.statement = this.statement + "SELECT " + column;
            return this;
        }

        public Builder from(String table) {
            this.statement = this.statement + " FROM " + table;
            return this;
        }

        public Builder where(String comp) {
            this.statement = this.statement + " WHERE " + comp;
            return this;
        }

        public Builder equals(String val) {
            this.statement = this.statement + "='" + val + "'";
            return this;
        }

        public Builder and(String comp) {
            this.statement = this.statement + " AND " + comp;
            return this;
        }

        public Builder insert(String table) {
            this.statement = this.statement + "INSERT IGNORE INTO " + table;
            return this;
        }

        public Builder columns(String ... columns) {
            String columnsJoined = " (" + String.join((CharSequence)",", columns) + ")";
            this.statement = this.statement + columnsJoined;
            return this;
        }

        public Builder values(String ... values) {
            String valuesJoined = "('" + String.join((CharSequence)"','", values) + "')";
            this.statement = this.statement + " VALUES " + valuesJoined;
            return this;
        }

        public Builder update(String table) {
            this.update = true;
            this.statement = this.statement + "UPDATE " + table;
            return this;
        }

        public Builder set(String column) {
            this.statement = this.statement + " SET " + column;
            return this;
        }

        public SqlQuery build() {
            return new SqlQuery(this);
        }
    }
}

