/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHorseData;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeHorseData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.Constants;

public class SpongeHorseData
extends AbstractData<HorseData, ImmutableHorseData>
implements HorseData {
    private HorseColor horseColor;
    private HorseStyle horseStyle;

    public SpongeHorseData(HorseColor horseColor, HorseStyle horseStyle) {
        super(HorseData.class);
        this.horseColor = (HorseColor)Preconditions.checkNotNull((Object)horseColor, (Object)"The Horse Color was null!");
        this.horseStyle = (HorseStyle)Preconditions.checkNotNull((Object)horseStyle, (Object)"The Horse Style was null!");
        this.registerGettersAndSetters();
    }

    public SpongeHorseData() {
        this(HorseColors.WHITE, HorseStyles.NONE);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.HORSE_COLOR, this::getHorseColor);
        this.registerFieldSetter(Keys.HORSE_COLOR, this::setHorseColor);
        this.registerKeyValue(Keys.HORSE_COLOR, this::color);
        this.registerFieldGetter(Keys.HORSE_STYLE, this::getHorseStyle);
        this.registerFieldSetter(Keys.HORSE_STYLE, this::setHorseStyle);
        this.registerKeyValue(Keys.HORSE_STYLE, this::style);
    }

    @Override
    public Value<HorseColor> color() {
        return new SpongeValue<HorseColor>(Keys.HORSE_COLOR, Constants.Entity.Horse.DEFAULT_COLOR, this.horseColor);
    }

    @Override
    public Value<HorseStyle> style() {
        return new SpongeValue<HorseStyle>(Keys.HORSE_STYLE, Constants.Entity.Horse.DEFAULT_STYLE, this.horseStyle);
    }

    @Override
    public HorseData copy() {
        return new SpongeHorseData(this.horseColor, this.horseStyle);
    }

    @Override
    public ImmutableHorseData asImmutable() {
        return new ImmutableSpongeHorseData(this.horseColor, this.horseStyle);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HORSE_COLOR.getQuery(), (Object)this.horseColor.getId()).set(Keys.HORSE_STYLE.getQuery(), (Object)this.horseStyle.getId());
    }

    private HorseColor getHorseColor() {
        return this.horseColor;
    }

    private void setHorseColor(HorseColor horseColor) {
        this.horseColor = horseColor;
    }

    private HorseStyle getHorseStyle() {
        return this.horseStyle;
    }

    private void setHorseStyle(HorseStyle horseStyle) {
        this.horseStyle = horseStyle;
    }
}

