/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeDirectionalData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.projectile.ShulkerBulletEntityAccessor;
import org.spongepowered.common.util.Constants;

public class ShulkerBulletDirectionalDataProcessor
extends AbstractSingleDataSingleTargetProcessor<ShulkerBulletEntityAccessor, Direction, Value<Direction>, DirectionalData, ImmutableDirectionalData> {
    public ShulkerBulletDirectionalDataProcessor() {
        super(Keys.DIRECTION, ShulkerBulletEntityAccessor.class);
    }

    @Override
    protected boolean set(ShulkerBulletEntityAccessor dataHolder, Direction value) {
        if (value == Direction.NONE) {
            dataHolder.accessor$setDirection(null);
        } else {
            dataHolder.accessor$setDirection(Constants.DirectionFunctions.getFor(value));
        }
        return true;
    }

    @Override
    protected Optional<Direction> getVal(ShulkerBulletEntityAccessor dataHolder) {
        EnumFacing direction = dataHolder.accessor$getDirection();
        return Optional.of(direction != null ? Constants.DirectionFunctions.getFor(direction) : Direction.NONE);
    }

    @Override
    protected ImmutableValue<Direction> constructImmutableValue(Direction value) {
        return new ImmutableSpongeValue<Direction>(Keys.DIRECTION, Direction.NONE, value);
    }

    @Override
    public boolean supports(ShulkerBulletEntityAccessor dataHolder) {
        return true;
    }

    @Override
    protected Value<Direction> constructValue(Direction actualValue) {
        return new SpongeValue<Direction>(Keys.DIRECTION, Direction.NONE, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected DirectionalData createManipulator() {
        return new SpongeDirectionalData();
    }
}

